/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.array;

import java.lang.ref.WeakReference;

public abstract class ArrayRegistryEntry {
    WeakReference owner;
    WeakReference array;
    boolean ownerIsRoot;

    ArrayRegistryEntry(Object owner, boolean ownerIsRoot, Object array) {
        this.owner = new WeakReference<Object>(owner);
        this.array = new WeakReference<Object>(array);
        this.ownerIsRoot = ownerIsRoot;
        if (ownerIsRoot && owner.getClass().isArray()) {
            throw new RuntimeException("Owner is root and an array was passed in");
        }
        if (!ownerIsRoot && !owner.getClass().isArray()) {
            throw new RuntimeException("Owner is not root and no array was passed in");
        }
    }

    public Object getArray() {
        if (this.array != null) {
            return this.array.get();
        }
        return null;
    }

    public Object getOwner() {
        if (this.owner != null) {
            return this.owner.get();
        }
        return null;
    }

    public boolean isOwnerRoot() {
        return this.ownerIsRoot;
    }
}

