/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InvalidAdviceException;
import org.jboss.aop.advice.NoMatchingAdviceException;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.Joinpoint;

public class PerVmAdvice {
    public static synchronized Interceptor generateOptimized(Joinpoint joinpoint, AspectManager manager, String adviceName, AspectDefinition a) throws Exception {
        Object aspect = manager.getPerVMAspect(a);
        return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interceptor generateInterceptor(Joinpoint joinpoint, Object aspect, String adviceName) throws Exception {
        ClassLoader cl = aspect.getClass().getClassLoader();
        String name = "org.jboss.aop.advice." + aspect.getClass().getName() + "_z_" + adviceName + "_" + System.identityHashCode(cl);
        Class iclass = null;
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        Class<PerVmAdvice> clazz = PerVmAdvice.class;
        synchronized (PerVmAdvice.class) {
            try {
                iclass = cl.loadClass(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            ClassPool pool = AspectManager.instance().findClassPool(cl);
            if (iclass == null) {
                try {
                    ClassLoader pcl = pool.getClassLoader();
                    iclass = pcl.loadClass(name);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (iclass == null) {
                int i;
                Method[] methods = aspect.getClass().getMethods();
                ArrayList<Method> matches = new ArrayList<Method>();
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(adviceName)) continue;
                    matches.add(methods[i]);
                }
                if (matches.size() == 0) {
                    throw new NoMatchingAdviceException(aspect.getClass(), adviceName);
                }
                for (i = 0; i < matches.size(); ++i) {
                    Method method = (Method)matches.get(i);
                    if (method.getParameterTypes().length != 1) {
                        throw new InvalidAdviceException("Only one argument of type invocations is supported. Method '" + method.toString() + "' (aspect class " + aspect.getClass().getName() + ") does not comply");
                    }
                    Class<?> paramClass = method.getParameterTypes()[0];
                    boolean foundInterface = false;
                    if (paramClass.isInterface() && paramClass.getName().equals("org.jboss.aop.joinpoint.Invocation")) {
                        foundInterface = true;
                    } else {
                        Class superParamClass = PerVmAdvice.findSuperClass(paramClass);
                        for (Class<?> iClass : superParamClass.getInterfaces()) {
                            if (!iClass.getName().equals("org.jboss.aop.joinpoint.Invocation")) continue;
                            foundInterface = true;
                        }
                    }
                    if (foundInterface) continue;
                    throw new InvalidAdviceException("Aspect method must have a parameter that implements Invocation. Parameter of advice '" + method.getName() + "' (aspect class" + aspect.getClass().getName() + ") does not comply: " + paramClass.getCanonicalName());
                }
                CtClass clazz2 = TransformerCommon.makeClass(pool, name);
                CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
                CtClass abstractAdviceClass = pool.get("org.jboss.aop.advice.AbstractAdvice");
                clazz2.setSuperclass(abstractAdviceClass);
                CtClass aspectClass = pool.get(aspect.getClass().getName());
                CtField field = new CtField(aspectClass, "aspectField", clazz2);
                field.setModifiers(1);
                clazz2.addField(field);
                CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
                String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + adviceName + "\"; " + "}";
                CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), (String)getNameBody, (CtClass)clazz2);
                getName.setModifiers(1);
                clazz2.addMethod(getName);
                CtMethod invokeTemplate = interceptorInterface.getDeclaredMethod("invoke");
                StringBuffer invokeBody = new StringBuffer();
                invokeBody.append("{  ");
                if (matches.size() > 1) {
                    boolean noArg = false;
                    for (int i2 = 0; i2 < matches.size(); ++i2) {
                        Method advice = (Method)matches.get(i2);
                        if (advice.getParameterTypes().length <= 0) {
                            noArg = true;
                            invokeBody.append("   return aspectField." + adviceName + "(); ");
                            break;
                        }
                        String param = advice.getParameterTypes()[0].getName();
                        invokeBody.append("   if ($1 instanceof " + param + ") return aspectField." + adviceName + "((" + param + ")$1); ");
                    }
                    if (!noArg) {
                        invokeBody.append("   return (org.jboss.aop.joinpoint.Invocation)null; ");
                    }
                } else {
                    Method advice = (Method)matches.get(0);
                    String param = advice.getParameterTypes()[0].getName();
                    invokeBody.append("return aspectField." + adviceName + "((" + param + ")$1); ");
                }
                invokeBody.append("}");
                CtMethod invoke = CtNewMethod.make((CtClass)invokeTemplate.getReturnType(), (String)"invoke", (CtClass[])invokeTemplate.getParameterTypes(), (CtClass[])invokeTemplate.getExceptionTypes(), (String)invokeBody.toString(), (CtClass)clazz2);
                invoke.setModifiers(1);
                clazz2.addMethod(invoke);
                ProtectionDomain pd = aspect.getClass().getProtectionDomain();
                iclass = TransformerCommon.toClass(clazz2, cl, pd);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Interceptor rtn = (Interceptor)iclass.newInstance();
            Field f = iclass.getField("aspectField");
            f.set(rtn, aspect);
            return rtn;
        }
    }

    private static Class findSuperClass(Class clazz) {
        if (clazz.getSuperclass() == null || clazz.getSuperclass().getName().equals("java.lang.Object")) {
            return clazz;
        }
        return PerVmAdvice.findSuperClass(clazz.getSuperclass());
    }
}

