/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.WorkerFactory;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.MRUFilterCachingStrategy;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderFactory;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFactoryImpl
implements SearchFactoryImplementor {
    private static ThreadLocal<WeakHashMap<Configuration, SearchFactoryImpl>> contexts = new ThreadLocal();
    private Map<Class, DocumentBuilder<Object>> documentBuilders = new HashMap<Class, DocumentBuilder<Object>>();
    private Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders = new HashMap<DirectoryProvider, ReentrantLock>();
    private Map<DirectoryProvider, OptimizerStrategy> dirProviderOptimizerStrategies = new HashMap<DirectoryProvider, OptimizerStrategy>();
    private Worker worker;
    private ReaderProvider readerProvider;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private Map<String, FilterDef> filterDefinitions = new HashMap<String, FilterDef>();
    private FilterCachingStrategy filterCachingStrategy;
    private Map<DirectoryProvider, LuceneIndexingParameters> dirProviderIndexingParams = new HashMap<DirectoryProvider, LuceneIndexingParameters>();

    @Override
    public BackendQueueProcessorFactory getBackendQueueProcessorFactory() {
        return this.backendQueueProcessorFactory;
    }

    @Override
    public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
        this.backendQueueProcessorFactory = backendQueueProcessorFactory;
    }

    public SearchFactoryImpl(Configuration cfg) {
        ReflectionManager reflectionManager = SearchFactoryImpl.getReflectionManager(cfg);
        Analyzer analyzer = this.initAnalyzer(cfg);
        this.initDocumentBuilders(cfg, reflectionManager, analyzer);
        Set<Class> indexedClasses = this.documentBuilders.keySet();
        for (DocumentBuilder<Object> builder : this.documentBuilders.values()) {
            builder.postInitialize(indexedClasses);
        }
        this.worker = WorkerFactory.createWorker(cfg, this);
        this.readerProvider = ReaderProviderFactory.createReaderProvider(cfg, this);
        this.buildFilterCachingStrategy(cfg.getProperties());
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.filterDefinitions.containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        FilterDef filterDef = new FilterDef();
        filterDef.setImpl(defAnn.impl());
        filterDef.setCache(defAnn.cache());
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefinitions.put(defAnn.name(), filterDef);
    }

    public static SearchFactoryImpl getSearchFactory(Configuration cfg) {
        SearchFactoryImpl searchFactory;
        WeakHashMap<Configuration, SearchFactoryImpl> contextMap = contexts.get();
        if (contextMap == null) {
            contextMap = new WeakHashMap(2);
            contexts.set(contextMap);
        }
        if ((searchFactory = contextMap.get(cfg)) == null) {
            searchFactory = new SearchFactoryImpl(cfg);
            contextMap.put(cfg, searchFactory);
        }
        return searchFactory;
    }

    @Override
    public Map<Class, DocumentBuilder<Object>> getDocumentBuilders() {
        return this.documentBuilders;
    }

    @Override
    public Map<DirectoryProvider, ReentrantLock> getLockableDirectoryProviders() {
        return this.lockableDirectoryProviders;
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public void addOptimizerStrategy(DirectoryProvider<?> provider, OptimizerStrategy optimizerStrategy) {
        this.dirProviderOptimizerStrategies.put(provider, optimizerStrategy);
    }

    @Override
    public void addIndexingParmeters(DirectoryProvider<?> provider, LuceneIndexingParameters indexingParams) {
        this.dirProviderIndexingParams.put(provider, indexingParams);
    }

    @Override
    public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
        return this.dirProviderOptimizerStrategies.get(provider);
    }

    @Override
    public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
        return this.dirProviderIndexingParams.get(provider);
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readerProvider;
    }

    public static ReflectionManager getReflectionManager(Configuration cfg) {
        ReflectionManager reflectionManager;
        try {
            reflectionManager = (ReflectionManager)cfg.getClass().getMethod("getReflectionManager", new Class[0]).invoke((Object)cfg, new Object[0]);
        }
        catch (Exception e) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    @Override
    public DirectoryProvider[] getDirectoryProviders(Class entity) {
        DocumentBuilder<Object> documentBuilder = this.getDocumentBuilders().get(entity);
        return documentBuilder == null ? null : documentBuilder.getDirectoryProviders();
    }

    @Override
    public void optimize() {
        Set<Class> clazzs = this.getDocumentBuilders().keySet();
        for (Class clazz : clazzs) {
            this.optimize(clazz);
        }
    }

    @Override
    public void optimize(Class entityType) {
        if (!this.getDocumentBuilders().containsKey(entityType)) {
            throw new SearchException("Entity not indexed: " + entityType);
        }
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>(1);
        queue.add(new OptimizeLuceneWork(entityType));
        this.getBackendQueueProcessorFactory().getProcessor(queue).run();
    }

    private void initDocumentBuilders(Configuration cfg, ReflectionManager reflectionManager, Analyzer analyzer) {
        Iterator iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        while (iter.hasNext()) {
            XClass mappedXClass;
            PersistentClass clazz = (PersistentClass)iter.next();
            Class mappedClass = clazz.getMappedClass();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                DirectoryProviderFactory.DirectoryProviders providers = factory.createDirectoryProviders(mappedXClass, cfg, this);
                DocumentBuilder documentBuilder = new DocumentBuilder(mappedXClass, analyzer, providers.getProviders(), providers.getSelectionStrategy(), reflectionManager);
                this.documentBuilders.put(mappedClass, documentBuilder);
            }
            this.bindFilterDefs(mappedXClass);
        }
        factory.startDirectoryProviders();
    }

    private Analyzer initAnalyzer(Configuration cfg) {
        Analyzer defaultAnalyzer;
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName(analyzerClassName);
            }
            catch (Exception e) {
                throw new SearchException("Lucene analyzer class '" + analyzerClassName + "' defined in property '" + "hibernate.search.analyzer" + "' could not be found.", e);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            defaultAnalyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClassName, e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClassName, e);
        }
        return defaultAnalyzer;
    }

    private void buildFilterCachingStrategy(Properties properties) {
        String impl = properties.getProperty("hibernate.search.filter.cache_strategy");
        if (StringHelper.isEmpty(impl) || "mru".equalsIgnoreCase(impl)) {
            this.filterCachingStrategy = new MRUFilterCachingStrategy();
        } else {
            try {
                Class filterCachingStrategyClass = org.hibernate.annotations.common.util.ReflectHelper.classForName(impl, SearchFactoryImpl.class);
                this.filterCachingStrategy = (FilterCachingStrategy)filterCachingStrategyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find filterCachingStrategy class: " + impl, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to instanciate filterCachingStrategy class: " + impl, e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to instanciate filterCachingStrategy class: " + impl, e);
            }
        }
        this.filterCachingStrategy.initialize(properties);
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.filterDefinitions.get(name);
    }

    static {
        Version.touch();
    }
}

