/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.hibernate.annotations.common.AssertionFailure;

public class ChainedFilter
extends Filter {
    private List<Filter> chainedFilters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        this.chainedFilters.add(filter);
    }

    public BitSet bits(IndexReader reader) throws IOException {
        if (this.chainedFilters.size() == 0) {
            throw new AssertionFailure("Chainedfilter has no filters to chain for");
        }
        Filter filter = this.chainedFilters.get(0);
        BitSet result = (BitSet)filter.bits(reader).clone();
        for (int index = 1; index < this.chainedFilters.size(); ++index) {
            result.and(this.chainedFilters.get(index).bits(reader));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChainedFilter [");
        for (Filter filter : this.chainedFilters) {
            sb.append("\n  ").append(filter.toString());
        }
        return sb.append("\n]").toString();
    }
}

