/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.lang.reflect.Method;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.security.Identity;
import org.jboss.seam.util.Strings;

@Interceptor(stateless=true, type=InterceptorType.CLIENT, around={AsynchronousInterceptor.class})
public class SecurityInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6567750187000766925L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method interfaceMethod = invocation.getMethod();
        Method method = this.getComponent().getBeanClass().getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
        Restrict restrict = this.getRestriction(method);
        if (restrict != null && Identity.isSecurityEnabled()) {
            String expr = !Strings.isEmpty(restrict.value()) ? restrict.value() : this.createDefaultExpr(method);
            Identity.instance().checkRestriction(expr);
        }
        return invocation.proceed();
    }

    private Restrict getRestriction(Method method) {
        if (method.isAnnotationPresent(Restrict.class)) {
            return method.getAnnotation(Restrict.class);
        }
        if (this.getComponent().getBeanClass().isAnnotationPresent(Restrict.class) && !this.getComponent().isLifecycleMethod(method)) {
            return this.getComponent().getBeanClass().getAnnotation(Restrict.class);
        }
        return null;
    }

    private String createDefaultExpr(Method method) {
        return String.format("#{s:hasPermission('%s','%s', null)}", this.getComponent().getName(), method.getName());
    }
}

