/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.Serializable;
import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public abstract class Asynchronous
implements Serializable {
    private static final LogProvider log = Logging.getLogProvider(Asynchronous.class);
    static final long serialVersionUID = -551286304424595765L;
    private Long processId;
    private Long taskId;

    protected Asynchronous() {
        if (Init.instance().isJbpmInstalled()) {
            BusinessProcess businessProcess = BusinessProcess.instance();
            this.processId = businessProcess.getProcessId();
            this.taskId = BusinessProcess.instance().getTaskId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object timer) {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        Contexts.getEventContext().set("org.jboss.seam.core.executingAsynchronousCall", true);
        try {
            this.executeInContexts(timer);
        }
        finally {
            Contexts.getEventContext().remove("org.jboss.seam.core.executingAsynchronousCall");
            if (createContexts) {
                Lifecycle.endCall();
            }
        }
    }

    private void executeInContexts(Object timer) {
        if (this.taskId != null) {
            BusinessProcess.instance().resumeTask(this.taskId);
        } else if (this.processId != null) {
            BusinessProcess.instance().resumeProcess(this.processId);
        }
        if (timer != null) {
            Contexts.getEventContext().set("timer", timer);
        }
        if (log.isDebugEnabled()) {
            log.debug("executing: " + this);
        }
        this.call();
    }

    protected abstract void call();
}

