/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.mail.internet.MimeUtility;

public class Base64 {
    public static BufferedReader decode(String b64string) throws Exception {
        return new BufferedReader(new InputStreamReader(MimeUtility.decode(new ByteArrayInputStream(b64string.getBytes()), "base64")));
    }

    public static String decodeAsString(String b64string) throws Exception {
        if (b64string == null) {
            return b64string;
        }
        String returnString = Base64.decode(b64string).readLine();
        if (returnString == null) {
            return returnString;
        }
        return returnString.trim();
    }

    public static ByteArrayOutputStream encode(String plaintext) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] in = plaintext.getBytes();
        ByteArrayOutputStream inStream = new ByteArrayOutputStream();
        inStream.write(in, 0, in.length);
        if (in.length % 3 == 1) {
            inStream.write(0);
            inStream.write(0);
        } else if (in.length % 3 == 2) {
            inStream.write(0);
        }
        inStream.writeTo(MimeUtility.encode(out, "base64"));
        return out;
    }

    public static ByteArrayOutputStream encode(byte[] in) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream inStream = new ByteArrayOutputStream();
        inStream.write(in, 0, in.length);
        if (in.length % 3 == 1) {
            inStream.write(0);
            inStream.write(0);
        } else if (in.length % 3 == 2) {
            inStream.write(0);
        }
        inStream.writeTo(MimeUtility.encode(out, "base64"));
        return out;
    }

    public static String encodeAsString(String plaintext) throws Exception {
        return Base64.encode(plaintext).toString();
    }

    public static byte[] md5(String text) {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot find MD5 algorithm", e);
        }
    }

    public static String md5AsHexString(String text) {
        return Base64.toHexString(Base64.md5(text));
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer hex = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            hex.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
            hex.append(Character.forDigit(bytes[i] & 0xF, 16));
            ++i;
        }
        return hex.toString();
    }
}

