/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.message;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;

public class MailAddress
implements Serializable {
    private static final long serialVersionUID = 3258689918480954416L;
    private String prettyName;
    private String user;
    private String domain;
    private boolean isvalid;
    private boolean isempty;
    public static final String ADDRESS = "([^@> ]+)(?:@([^@> ]+))?";
    public static final String SMTP_ADDRESS = "([^<]*)<((?:@[^@>]+,)*@[^@>]+:)?(?:([^@>]+)(?:@(([^@>]+)|()))?)?>";
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("([^@> ]+)(?:@([^@> ]+))?");
    public static final Pattern SMTP_ADDRESS_PATTERN = Pattern.compile("([^<]*)<((?:@[^@>]+,)*@[^@>]+:)?(?:([^@>]+)(?:@(([^@>]+)|()))?)?>");
    public static final int PRETTY_GROUP = 1;
    public static final int USER_GROUP = 3;
    public static final int DOMAIN_GROUP = 4;

    private MailAddress(String user, String domain, boolean isfrom) {
        this.user = user;
        this.domain = domain;
        if (user != null && user.length() > 0 && domain != null && domain.length() > 0) {
            this.isvalid = true;
        }
        if (!(user != null && user.length() != 0 || domain != null && domain.length() != 0)) {
            this.isempty = true;
            this.isvalid = isfrom;
        }
    }

    private MailAddress(String user, String domain, String prettyName, boolean isfrom) {
        this(user, domain, isfrom);
        this.prettyName = prettyName;
    }

    public MailAddress(MailAddress orig) {
        this.user = new String(orig.getUser());
        this.domain = new String(orig.getDomain());
        this.prettyName = orig.getPrettyName() != null ? new String(orig.getPrettyName()) : null;
        this.isvalid = orig.isValid();
        this.isempty = orig.isempty;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public boolean isValid() {
        return this.isvalid;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public String getUser() {
        return this.user;
    }

    public String getDomain() {
        return this.domain;
    }

    public static MailAddress parseSMTPStyle(String address) {
        return MailAddress.parseSMTPStyle(address, false);
    }

    public static MailAddress parseSMTPStyle(String address, boolean isFrom) {
        MailAddress mailAddress;
        Matcher smtpAddressMatcher = SMTP_ADDRESS_PATTERN.matcher(address);
        Matcher addressMatcher = ADDRESS_PATTERN.matcher(address);
        if (smtpAddressMatcher.matches()) {
            String prettyName = MailAddress.getPrettyName(smtpAddressMatcher);
            String user = MailAddress.getUser(smtpAddressMatcher);
            String domain = MailAddress.getDomain(smtpAddressMatcher);
            if (user.length() > 0 && domain.length() == 0) {
                domain = "localhost";
            }
            mailAddress = new MailAddress(user, domain, prettyName, isFrom);
        } else if (addressMatcher.matches()) {
            String prettyName = "";
            String user = addressMatcher.group(1);
            String domain = addressMatcher.group(2);
            if (user.length() > 0 && (domain == null || domain.length() == 0)) {
                domain = "localhost";
            }
            mailAddress = new MailAddress(user, domain, prettyName, isFrom);
        } else {
            mailAddress = new MailAddress("", "", isFrom);
        }
        return mailAddress;
    }

    private static String getUser(Matcher m) {
        return m.group(3) != null ? m.group(3).trim() : "";
    }

    private static String getPrettyName(Matcher m) {
        return m.group(1) != null ? m.group(1).trim() : "";
    }

    private static String getDomain(Matcher m) {
        return m.group(4) != null ? m.group(4).trim() : "";
    }

    public boolean equals(MailAddress address) {
        if (!(address instanceof MailAddress)) {
            return false;
        }
        return this.getUser().toLowerCase().equals(address.getUser().toLowerCase()) && this.getDomain().toLowerCase().equals(address.getDomain().toLowerCase());
    }

    public String toString() {
        if (this.isempty) {
            return "<>";
        }
        return "<" + this.getUser() + "@" + this.getDomain() + ">";
    }

    public String toSMTPString() {
        return this.toString();
    }

    public String toIMAPString() {
        String name = this.imapFormat(this.getPrettyName());
        String user = this.imapFormat(this.getUser());
        String domain = this.imapFormat(this.getDomain());
        return String.format("(%s NIL %s %s)", name, user, domain);
    }

    private String imapFormat(String val) {
        if (this.isempty || val == null || val.trim().length() == 0) {
            return "NIL";
        }
        return "\"" + val + "\"";
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MailAddress) {
            return this.equals((MailAddress)obj);
        }
        return false;
    }

    public static MailAddress[] parseAddressArray(String[] in) {
        MailAddress[] out = new MailAddress[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = MailAddress.parseSMTPStyle(in[i]);
            ++i;
        }
        return out;
    }

    public static MailAddress[] parseAddressArray(Address[] in) {
        MailAddress[] out = new MailAddress[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = MailAddress.parseAddress(in[i]);
            ++i;
        }
        return out;
    }

    public static MailAddress parseAddress(Address in) {
        return MailAddress.parseSMTPStyle(in.toString());
    }

    public String getRawAddress() {
        return String.valueOf(this.getUser()) + "@" + this.getDomain();
    }
}

