/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.events.CollapseNodeCommandEvent;
import org.richfaces.component.state.events.ExpandNodeCommandEvent;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.event.AjaxExpandedEvent;
import org.richfaces.event.AjaxSelectedEvent;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public abstract class NodeRendererBase
extends CompositeRenderer {
    protected static final String NODE_EXPANDED_INPUT_SUFFIX = "NodeExpanded";
    protected static final String AJAX_EXPANDED_SUFFIX = "AjaxExpanded";
    static /* synthetic */ Class class$org$richfaces$component$Draggable;
    static /* synthetic */ Class class$org$richfaces$component$Dropzone;

    public NodeRendererBase() {
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    protected String getToggleScript(FacesContext context, UITreeNode treeNode, String to) {
        UITree tree = treeNode.getUITree();
        if ("handle".equals(to) && tree.isToggleOnClick() || "mainRow".equals(to) && !tree.isToggleOnClick()) {
            return "";
        }
        boolean showLines = tree.isShowConnectingLines();
        String id = treeNode.getClientId(context);
        if ("ajax".equals(tree.getSwitchType())) {
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tree.getNodeFacet(), (FacesContext)context);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tree.getNodeFacet());
            Map parameters = (Map)eventOptions.get("parameters");
            parameters.remove(id);
            parameters.put(id + NODE_EXPANDED_INPUT_SUFFIX, String.valueOf(!tree.isExpanded()));
            parameters.put(id + AJAX_EXPANDED_SUFFIX, Boolean.TRUE);
            function.addParameter((Object)eventOptions);
            StringBuffer buffer = new StringBuffer();
            function.appendScript(buffer);
            buffer.append(";");
            return buffer.toString();
        }
        if ("server".equals(tree.getSwitchType())) {
            String paramName = id + NODE_EXPANDED_INPUT_SUFFIX;
            StringBuffer result = new StringBuffer();
            result.append('{');
            result.append("var form = A4J.findForm(this);");
            result.append("var params = new Object();");
            result.append("params['");
            result.append(paramName);
            result.append("'] = ");
            result.append(!tree.isExpanded());
            result.append(';');
            result.append("Richfaces.jsFormSubmit('");
            result.append(id);
            result.append("', ");
            result.append("form.id, ");
            result.append("'', ");
            result.append("params);};");
            return result.toString();
        }
        return "";
    }

    public void initializeLines(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        if (tree.isShowConnectingLines()) {
            if (((Boolean)treeNode.getAttributes().get("isLastElement")).booleanValue()) {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-last");
            } else {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-node");
            }
            if (tree.isExpanded()) {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-exp");
            } else {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-clp");
            }
        }
    }

    public void initializeResources(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        String resource = "dr-tree-i-hl";
        resource = resource + " rich-tree-node-highlighted";
        String cssClass = tree.getHighlightedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getHighlightedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("highlightedClass", (Object)resource);
        resource = "dr-tree-i-sel";
        resource = resource + " rich-tree-node-selected";
        cssClass = tree.getSelectedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getSelectedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("selectedClass", (Object)resource);
        resource = ViewUtil.getResourceURL((String)treeNode.getIcon());
        if (resource == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIcon());
        }
        if (resource != null) {
            variables.setVariable("folder", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconCollapsed())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconCollapsed());
        }
        if (resource != null) {
            variables.setVariable("collapsed", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconExpanded())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconExpanded());
        }
        if (resource != null) {
            variables.setVariable("expanded", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL((String)treeNode.getIconLeaf())) == null) {
            resource = ViewUtil.getResourceURL((String)tree.getIconLeaf());
        }
        if (resource != null) {
            variables.setVariable("leaf", (Object)resource);
        }
    }

    private String getHandleDisplayStyle(FacesContext context, UITreeNode node, boolean expandHandle) {
        if (node.getUITree().isExpanded() ^ expandHandle) {
            return "display: none;";
        }
        return "";
    }

    public String getHandleCollapsedDisplayStyle(FacesContext context, UITreeNode node) {
        return this.getHandleDisplayStyle(context, node, false);
    }

    public String getHandleExpandedDisplayStyle(FacesContext context, UITreeNode node) {
        return this.getHandleDisplayStyle(context, node, true);
    }

    public String getExpandedValue(FacesContext context, UITreeNode node) {
        return Boolean.toString(node.getUITree().isExpanded());
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UITreeNode node = (UITreeNode)component;
        UITree tree = node.getUITree();
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(context);
        TreeState componentState = (TreeState)tree.getComponentState();
        String nodeExpandedId = id + NODE_EXPANDED_INPUT_SUFFIX;
        Object nodeExpandedValue = requestMap.get(nodeExpandedId);
        if (nodeExpandedValue != null) {
            boolean nodeExpanded = Boolean.valueOf(nodeExpandedValue.toString());
            if (tree.isExpanded() ^ nodeExpanded) {
                if (nodeExpanded) {
                    new ExpandNodeCommandEvent((UIComponent)tree, key).queue();
                } else {
                    new CollapseNodeCommandEvent((UIComponent)tree, key).queue();
                }
                if (Boolean.valueOf((String)requestMap.get(id + AJAX_EXPANDED_SUFFIX)).booleanValue()) {
                    new AjaxExpandedEvent((UIComponent)node).queue();
                    new AjaxExpandedEvent((UIComponent)tree).queue();
                } else {
                    new NodeExpandedEvent((UIComponent)node).queue();
                    new NodeExpandedEvent((UIComponent)tree).queue();
                }
            }
        }
        if (id.equals(tree.getAttributes().get("_selectionInput"))) {
            if (!componentState.isSelected(key)) {
                if (tree.getAttributes().get(":selectedNode") == null) {
                    new NodeSelectedEvent((UIComponent)tree, componentState.getSelectedNode()).queue();
                    new NodeSelectedEvent((UIComponent)node, componentState.getSelectedNode()).queue();
                } else {
                    new AjaxSelectedEvent((UIComponent)tree, componentState.getSelectedNode()).queue();
                    new AjaxSelectedEvent((UIComponent)node, componentState.getSelectedNode()).queue();
                }
            }
            tree.getAttributes().remove("_selectionInput");
        }
    }

    public String getAjaxSelectedListenerFlag(FacesContext context, UITreeNode treeNode) throws IOException {
        if (treeNode.hasAjaxSubmitSelection()) {
            return "ajax_selected_listener_flag";
        }
        return null;
    }

    private void convertOptions(Map opts) {
        Iterator iterator = opts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof JSFunctionDefinition)) continue;
            JSFunctionDefinition definition = (JSFunctionDefinition)value;
            entry.setValue(definition.toScript());
        }
    }

    public String getDraggableScriptOptions(FacesContext context, UITreeNode component) {
        TreeNodeOptions options = new TreeNodeOptions((UIComponent)component);
        this.mergeScriptOptions(options, context, (UIComponent)component, class$org$richfaces$component$Draggable == null ? (class$org$richfaces$component$Draggable = NodeRendererBase.class$("org.richfaces.component.Draggable")) : class$org$richfaces$component$Draggable);
        this.convertOptions(options.getMap());
        return ScriptUtils.toScript((Object)((Object)options));
    }

    public String getDropzoneScriptOptions(FacesContext context, UITreeNode component) {
        TreeNodeOptions options = new TreeNodeOptions((UIComponent)component);
        this.mergeScriptOptions(options, context, (UIComponent)component, class$org$richfaces$component$Dropzone == null ? (class$org$richfaces$component$Dropzone = NodeRendererBase.class$("org.richfaces.component.Dropzone")) : class$org$richfaces$component$Dropzone);
        this.convertOptions(options.getMap());
        return ScriptUtils.toScript((Object)((Object)options));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TreeNodeOptions
    extends ScriptOptions {
        public TreeNodeOptions(UIComponent component) {
            super(component);
        }
    }
}

