/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Work;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkQueue {
    private List<Work> queue;
    private List<LuceneWork> sealedQueue;

    public WorkQueue(int size) {
        this.queue = new ArrayList<Work>(size);
    }

    private WorkQueue(List<Work> queue) {
        this.queue = queue;
    }

    public WorkQueue() {
        this(10);
    }

    public void add(Work work) {
        this.queue.add(work);
    }

    public List<Work> getQueue() {
        return this.queue;
    }

    public WorkQueue splitQueue() {
        WorkQueue subQueue = new WorkQueue(this.queue);
        this.queue = new ArrayList<Work>(this.queue.size());
        return subQueue;
    }

    public List<LuceneWork> getSealedQueue() {
        if (this.sealedQueue == null) {
            throw new AssertionFailure("Access a Sealed WorkQueue whcih has not been sealed");
        }
        return this.sealedQueue;
    }

    public void setSealedQueue(List<LuceneWork> sealedQueue) {
        this.queue = null;
        this.sealedQueue = sealedQueue;
    }

    public void clear() {
        this.queue.clear();
        if (this.sealedQueue != null) {
            this.sealedQueue.clear();
        }
    }

    public int size() {
        return this.queue.size();
    }
}

