/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.common.InternalFactHandle;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public class FactHandleIndexHashTable
extends AbstractHashTable
implements FactHandleMemory {
    private static final long serialVersionUID = 400L;
    public static final int PRIME = 31;
    private int startResult = 31;
    private FieldIndexHashTableIterator tupleValueIterator;
    private int factSize;
    private AbstractHashTable.Index index;

    public FactHandleIndexHashTable(AbstractHashTable.FieldIndex[] index) {
        this(16, 0.75f, index);
    }

    public FactHandleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index) {
        super(capacity, loadFactor);
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.startResult = 31 * this.startResult + index[i].getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("FieldIndexHashTable does not support  iterator()");
    }

    public Iterator iterator(ReteTuple tuple) {
        FieldIndexEntry entry;
        if (this.tupleValueIterator == null) {
            this.tupleValueIterator = new FieldIndexHashTableIterator();
        }
        this.tupleValueIterator.reset((entry = this.get(tuple)) != null ? entry.first : null);
        return this.tupleValueIterator;
    }

    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public Entry[] toArray() {
        Entry[] result = new Entry[this.factSize];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (FieldIndexEntry fieldIndexEntry = (FieldIndexEntry)this.table[i]; fieldIndexEntry != null; fieldIndexEntry = (FieldIndexEntry)fieldIndexEntry.getNext()) {
                for (Entry entry = fieldIndexEntry.getFirst(); entry != null; entry = entry.getNext()) {
                    result[index++] = entry;
                }
            }
        }
        return result;
    }

    public boolean add(InternalFactHandle handle) {
        FieldIndexEntry entry = this.getOrCreate(handle.getObject());
        entry.add(handle);
        ++this.factSize;
        return true;
    }

    public boolean add(InternalFactHandle handle, boolean checkExists) {
        throw new UnsupportedOperationException("FieldIndexHashTable does not support add(InternalFactHandle handle, boolean checkExists)");
    }

    public boolean remove(InternalFactHandle handle) {
        FieldIndexEntry previous;
        Object object = handle.getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry current = previous = (FieldIndexEntry)this.table[index];
        while (current != null) {
            FieldIndexEntry next = (FieldIndexEntry)current.next;
            if (current.matches(object, hashCode)) {
                current.remove(handle);
                --this.factSize;
                if (current.first == null) {
                    if (previous == current) {
                        this.table[index] = next;
                    } else {
                        previous.next = next;
                    }
                    current.next = null;
                    --this.size;
                }
                return true;
            }
            previous = current;
            current = next;
        }
        return false;
    }

    public boolean contains(InternalFactHandle handle) {
        Object object = handle.getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry current = (FieldIndexEntry)this.table[index];
        while (current != null) {
            if (current.matches(object, hashCode)) {
                return true;
            }
            current = (FieldIndexEntry)current.next;
        }
        return false;
    }

    public FieldIndexEntry get(ReteTuple tuple) {
        FieldIndexEntry entry;
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        for (entry = (FieldIndexEntry)this.table[index]; entry != null; entry = (FieldIndexEntry)entry.getNext()) {
            if (!entry.matches(tuple, hashCode)) continue;
            return entry;
        }
        return entry;
    }

    private FieldIndexEntry getOrCreate(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry entry = (FieldIndexEntry)this.table[index];
        while (entry != null) {
            if (entry.matches(object, hashCode)) {
                return entry;
            }
            entry = (FieldIndexEntry)entry.next;
        }
        if (entry == null) {
            entry = new FieldIndexEntry(this.index, hashCode);
            entry.next = this.table[index];
            this.table[index] = entry;
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return entry;
    }

    public int size() {
        return this.factSize;
    }

    public static class FieldIndexEntry
    implements Entry {
        private static final long serialVersionUID = 400L;
        private Entry next;
        private AbstractHashTable.FactEntryImpl first;
        private final int hashCode;
        private AbstractHashTable.Index index;

        public FieldIndexEntry(AbstractHashTable.Index index, int hashCode) {
            this.index = index;
            this.hashCode = hashCode;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public AbstractHashTable.FactEntryImpl getFirst() {
            return this.first;
        }

        public void add(InternalFactHandle handle) {
            AbstractHashTable.FactEntryImpl entry = new AbstractHashTable.FactEntryImpl(handle);
            entry.next = this.first;
            this.first = entry;
        }

        public AbstractHashTable.FactEntryImpl get(InternalFactHandle handle) {
            long id = handle.getId();
            AbstractHashTable.FactEntryImpl current = this.first;
            while (current != null) {
                if (current.handle.getId() == id) {
                    return current;
                }
                current = (AbstractHashTable.FactEntryImpl)current.next;
            }
            return null;
        }

        public AbstractHashTable.FactEntryImpl remove(InternalFactHandle handle) {
            AbstractHashTable.FactEntryImpl previous;
            long id = handle.getId();
            AbstractHashTable.FactEntryImpl current = previous = this.first;
            while (current != null) {
                AbstractHashTable.FactEntryImpl next = (AbstractHashTable.FactEntryImpl)current.next;
                if (current.handle.getId() == id) {
                    if (this.first == current) {
                        this.first = next;
                    } else {
                        previous.next = next;
                    }
                    current.next = null;
                    return current;
                }
                previous = current;
                current = next;
            }
            return current;
        }

        public boolean matches(Object object, int objectHashCode) {
            return this.hashCode == objectHashCode && this.index.equal(this.first.getFactHandle().getObject(), object);
        }

        public boolean matches(ReteTuple tuple, int tupleHashCode) {
            return this.hashCode == tupleHashCode && this.index.equal(this.first.getFactHandle().getObject(), tuple);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            FieldIndexEntry other = (FieldIndexEntry)object;
            return this.hashCode == other.hashCode && this.index == other.index;
        }

        public String toString() {
            return "FieldIndexEntry( hashCode=" + this.hashCode + " first=" + this.first + " )";
        }
    }

    public static class FieldIndexHashTableIterator
    implements Iterator {
        private Entry entry;

        public Object next() {
            Entry current = this.entry;
            this.entry = this.entry != null ? this.entry.getNext() : null;
            return current;
        }

        public void reset(Entry entry) {
            this.entry = entry;
        }
    }
}

