/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.codehaus.groovy.groovydoc.GroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

public class SimpleGroovyClassDocAssembler
extends VisitorAdapter {
    private Stack stack;
    private Map classDocs;
    private SimpleGroovyClassDoc currentClassDoc;
    private SimpleGroovyConstructorDoc currentConstructorDoc;
    private SimpleGroovyMethodDoc currentMethodDoc;
    private SourceBuffer sourceBuffer;
    private String packagePath;

    public SimpleGroovyClassDocAssembler(String packagePath, String file, SourceBuffer sourceBuffer) {
        this.sourceBuffer = sourceBuffer;
        this.packagePath = packagePath;
        this.stack = new Stack();
        this.classDocs = new HashMap();
        String className = file;
        if (file != null) {
            int idx = file.lastIndexOf(".");
            className = file.substring(0, idx);
        }
        this.currentClassDoc = new SimpleGroovyClassDoc(className);
        this.currentClassDoc.setFullPathName(packagePath + "/" + className);
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
    }

    public Map getGroovyClassDocs() {
        this.postProcessClassDocs();
        return this.classDocs;
    }

    private void postProcessClassDocs() {
        Iterator classDocIterator = this.classDocs.values().iterator();
        while (classDocIterator.hasNext()) {
            SimpleGroovyClassDoc classDoc = (SimpleGroovyClassDoc)classDocIterator.next();
            GroovyConstructorDoc[] constructors = classDoc.constructors();
            if (constructors == null || constructors.length != 0) continue;
            SimpleGroovyConstructorDoc constructorDoc = new SimpleGroovyConstructorDoc(classDoc.name());
            classDoc.add(constructorDoc);
        }
    }

    public void visitClassDef(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String className = t.childOfType(84).getText();
            this.currentClassDoc = (SimpleGroovyClassDoc)this.classDocs.get(this.packagePath + "/" + className);
            if (this.currentClassDoc == null) {
                this.currentClassDoc = new SimpleGroovyClassDoc(className);
            }
            this.currentClassDoc.setFullPathName(this.packagePath + "/" + this.currentClassDoc.name());
            this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        }
    }

    public void visitCtorIdent(GroovySourceAST t, int visit) {
        if (visit == 1) {
            this.currentConstructorDoc = new SimpleGroovyConstructorDoc(this.currentClassDoc.name());
            String commentText = this.getJavaDocCommentsBeforeNode(t);
            this.currentConstructorDoc.setRawCommentText(commentText);
            this.addParametersTo(this.currentConstructorDoc, t, visit);
            this.currentClassDoc.add(this.currentConstructorDoc);
        }
    }

    public void visitMethodDef(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String methodName = t.childOfType(84).getText();
            this.currentMethodDoc = new SimpleGroovyMethodDoc(methodName);
            String commentText = this.getJavaDocCommentsBeforeNode(t);
            this.currentMethodDoc.setRawCommentText(commentText);
            String returnTypeName = this.getTypeNodeAsText(t.childOfType(12), "def");
            SimpleGroovyType returnType = new SimpleGroovyType(returnTypeName);
            this.currentMethodDoc.setReturnType(returnType);
            this.addParametersTo(this.currentMethodDoc, t, visit);
            this.currentClassDoc.add(this.currentMethodDoc);
        }
    }

    private String getJavaDocCommentsBeforeNode(GroovySourceAST t) {
        int firstFullStopIndex;
        int lastGroupIndex;
        String returnValue = "";
        String text = this.sourceBuffer.getSnippet(new LineColumn(1, 1), new LineColumn(t.getLine(), t.getColumn()));
        Pattern p = Pattern.compile("(?s).*/\\*\\*([^/]*?)\\*/[^\\*/}]*$");
        Matcher m = p.matcher(text);
        if (m.matches() && (lastGroupIndex = m.groupCount()) > 0 && (firstFullStopIndex = (returnValue = m.group(lastGroupIndex)).indexOf(".")) >= 0) {
            returnValue = returnValue.substring(0, returnValue.indexOf("."));
        }
        return returnValue;
    }

    private String getText(GroovySourceAST node) {
        String returnValue = null;
        if (node != null) {
            returnValue = node.getText();
        }
        return returnValue;
    }

    private String getTypeNodeAsText(GroovySourceAST typeNode, String defaultText) {
        String returnValue = defaultText;
        if (typeNode != null && typeNode.getType() == 12 && typeNode.getNumberOfChildren() > 0) {
            GroovySourceAST child = (GroovySourceAST)typeNode.getFirstChild();
            switch (child.getType()) {
                case 100: {
                    returnValue = "boolean";
                    break;
                }
                case 101: {
                    returnValue = "byte";
                    break;
                }
                case 102: {
                    returnValue = "char";
                    break;
                }
                case 107: {
                    returnValue = "double";
                    break;
                }
                case 105: {
                    returnValue = "float";
                    break;
                }
                case 104: {
                    returnValue = "int";
                    break;
                }
                case 106: {
                    returnValue = "long";
                    break;
                }
                case 103: {
                    returnValue = "short";
                    break;
                }
                case 99: {
                    returnValue = "void";
                    break;
                }
                case 84: {
                    returnValue = child.getText();
                }
            }
        }
        return returnValue;
    }

    private void addParametersTo(SimpleGroovyExecutableMemberDoc executableMemberDoc, GroovySourceAST t, int visit) {
        GroovySourceAST parametersNode = t.childOfType(19);
        if (parametersNode != null && parametersNode.getNumberOfChildren() > 0) {
            for (GroovySourceAST currentNode = (GroovySourceAST)parametersNode.getFirstChild(); currentNode != null; currentNode = (GroovySourceAST)currentNode.getNextSibling()) {
                String parameterTypeName = this.getTypeNodeAsText(currentNode.childOfType(12), "def");
                String parameterName = this.getText(currentNode.childOfType(84));
                SimpleGroovyParameter parameter = new SimpleGroovyParameter(parameterName);
                parameter.setTypeName(parameterTypeName);
                executableMemberDoc.add(parameter);
            }
        }
    }

    public void push(GroovySourceAST t) {
        this.stack.push(t);
    }

    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return (GroovySourceAST)this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        Object parentNode = null;
        Object currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            parentNode = this.stack.peek();
        }
        this.stack.push(currentNode);
        return parentNode;
    }
}

