/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class MemoryAwareConcurrentReadMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private volatile long concurrentReads = 0L;
    private Object writeLock = new Object();
    private Object writeQueue = new Object();
    private Entry[] table = new Entry[16];
    private int tableSize;
    private int size;
    private ReferenceQueue queue = new ReferenceQueue();
    private int threshold;

    public MemoryAwareConcurrentReadMap() {
        this.tableSize = this.table.length;
        this.threshold = this.newThreshold();
    }

    private int newThreshold() {
        return (int)((float)this.tableSize * 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.waitForWriteState();
            this.putNonBlocking(key, value, false);
        }
    }

    private void putNonBlocking(Object key, Object value, boolean hard) {
        this.removeDereferencedEntries();
        int hash = key.hashCode();
        int index = this.index(hash, this.table.length);
        Entry current = this.table[index];
        Entry prev = null;
        while (current != null) {
            if (hash == current.hash) {
                Object oldKey = current.getKey();
                if (!current.isValid()) {
                    if (prev != null) {
                        prev.next = current.next;
                    } else {
                        this.table[index] = current.next;
                    }
                    current = current.invalidate();
                    --this.size;
                    continue;
                }
                if (key == oldKey | key.equals(oldKey)) {
                    current.setValue(oldKey, value, hard);
                    return;
                }
            }
            prev = current;
            current = current.next;
        }
        Entry newEntry = new Entry(key, value, hash, hard);
        Entry oldEntry = this.table[index];
        newEntry.next = oldEntry;
        this.table[index] = newEntry;
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rehash() {
        if (this.size < this.threshold) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.waitForWriteState();
            this.removeDereferencedEntries();
            if (this.size < this.threshold) {
                return;
            }
            this.removeStaleEntries();
            if (this.size < this.threshold) {
                return;
            }
            this.tableSize *= 2;
            Entry[] newTable = new Entry[this.tableSize];
            this.transfer(this.table, newTable);
            this.table = newTable;
            this.threshold = this.newThreshold();
        }
    }

    private void removeDereferencedEntries() {
        SoftRef e;
        while ((e = (SoftRef)this.queue.poll()) != null) {
            Entry entry = e.getEntry();
            e.clear();
            if (entry == null) continue;
            this.removeEntry(entry);
        }
    }

    private int removeStaleEntries() {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry current = this.table[i];
            Entry prev = null;
            while (current != null) {
                if (current.isValid()) {
                    prev = current;
                    current = current.next;
                    continue;
                }
                ++count;
                current = current.invalidate();
                if (prev != null) {
                    prev.next = current;
                    continue;
                }
                this.table[i] = current;
            }
        }
        this.size -= count;
        return count;
    }

    private void transfer(Entry[] oldTable, Entry[] newTable) {
        for (int oldIndex = 0; oldIndex < oldTable.length; ++oldIndex) {
            Entry current = oldTable[oldIndex];
            while (current != null) {
                int index = this.index(current.hash, newTable.length);
                Entry newHead = newTable[index];
                Entry newEntry = current;
                current = current.next;
                newEntry.next = newHead;
                newTable[index] = newEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        Object object = this.writeLock;
        synchronized (object) {
            this.waitForWriteState();
            this.removeDereferencedEntries();
            int hash = key.hashCode();
            int index = this.index(hash, this.table.length);
            Entry current = this.table[index];
            Entry prev = null;
            while (current != null) {
                if (hash == current.hash) {
                    Object oldKey = current.getKey();
                    if (!current.isValid()) {
                        current = current.invalidate();
                        if (prev != null) {
                            prev.next = current;
                        } else {
                            this.table[index] = current;
                        }
                        --this.size;
                        continue;
                    }
                    if (key == oldKey || key.equals(oldKey)) {
                        current = current.invalidate();
                        if (prev != null) {
                            prev.next = current;
                        } else {
                            this.table[index] = current;
                        }
                        --this.size;
                        return;
                    }
                }
                prev = current;
                current = current.next;
            }
        }
    }

    private void removeEntry(Entry e) {
        int hash = e.hash;
        int index = this.index(hash, this.table.length);
        Entry current = this.table[index];
        Entry prev = null;
        while (current != null && current != e) {
            prev = current;
            current = current.next;
        }
        if (current == null) {
            return;
        }
        current = current.invalidate();
        if (prev == null) {
            this.table[index] = current;
        } else {
            prev.next = current;
        }
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWriteState() {
        Object object = this.writeQueue;
        synchronized (object) {
            while (this.concurrentReads != 0L) {
                try {
                    this.writeQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStrong(Object key, Object value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.waitForWriteState();
            this.putNonBlocking(key, value, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockWrite() {
        Object object = this.writeLock;
        synchronized (object) {
            ++this.concurrentReads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockWrite() {
        Object object = this.writeLock;
        synchronized (object) {
            --this.concurrentReads;
        }
        object = this.writeQueue;
        synchronized (object) {
            this.writeQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        int hash = key.hashCode();
        this.lockWrite();
        try {
            int index = this.index(hash, this.table.length);
            Entry current = this.table[index];
            while (current != null) {
                if (hash == current.hash) {
                    Object oldKey = current.getKey();
                    Object oldValue = current.getValue();
                    if (current.isValid() && (key == oldKey || key.equals(oldKey))) {
                        Object object = oldValue;
                        return object;
                    }
                }
                current = current.next;
            }
        }
        finally {
            this.unlockWrite();
        }
        return null;
    }

    private int index(int hash, int max) {
        return hash & max - 1;
    }

    public int getSize() {
        return this.size;
    }

    private class Entry {
        private final int hash;
        private Ref value;
        private Ref key;
        private Entry next;

        public Entry(Object key, Object value, int hash, boolean hard) {
            this.hash = hash;
            this.setValue(key, value, hard);
        }

        public boolean isValid() {
            Object v = this.value != null ? this.value.get() : null;
            Object k = this.key != null ? this.key.get() : null;
            return v != null && k != null;
        }

        public Entry invalidate() {
            if (this.value != null) {
                this.value.clear();
                this.value = null;
            }
            if (this.key != null) {
                this.key.clear();
                this.key = null;
            }
            Entry tmp = this.next;
            this.next = null;
            return tmp;
        }

        public Object getKey() {
            return this.key != null ? this.key.get() : null;
        }

        public Object getValue() {
            return this.value != null ? this.value.get() : null;
        }

        public void setValue(Object key, Object value, boolean hard) {
            if (hard) {
                this.value = new HardRef(value, this);
                this.key = new HardRef(key, this);
            } else {
                this.value = new SoftRef(value, this, MemoryAwareConcurrentReadMap.this.queue);
                this.key = new SoftRef(key, this, MemoryAwareConcurrentReadMap.this.queue);
            }
        }
    }

    private static class SoftRef
    extends SoftReference
    implements Ref {
        private Entry entry;

        public SoftRef(Object v, Entry e, ReferenceQueue queue) {
            super(v, queue);
            this.entry = e;
        }

        public void clear() {
            super.clear();
            this.entry = null;
        }

        public Entry getEntry() {
            return this.entry;
        }
    }

    private static class HardRef
    implements Ref {
        private Object value;
        private Entry entry;

        public HardRef(Object value, Entry e) {
            this.value = value;
            this.entry = e;
        }

        public Object get() {
            return this.value;
        }

        public void clear() {
            this.value = null;
            this.entry = null;
        }

        public Entry getEntry() {
            return this.entry;
        }
    }

    private static interface Ref {
        public Object get();

        public void clear();

        public Entry getEntry();
    }
}

