/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovyjarjarasm.asm.Opcodes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.VerifierCodeVisitor;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.syntax.Token;

public class Verifier
implements GroovyClassVisitor,
Opcodes {
    public static final String __TIMESTAMP = "__timeStamp";
    private ClassNode classNode;
    private MethodNode methodNode;

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public void visitClass(ClassNode node) {
        this.classNode = node;
        if ((this.classNode.getModifiers() & 0x200) > 0) {
            ConstructorNode dummy = new ConstructorNode(0, null);
            this.addInitialization(node, dummy);
            node.visitContents(this);
            return;
        }
        this.addDefaultParameterMethods(node);
        this.addDefaultParameterConstructors(node);
        if (!node.isDerivedFromGroovyObject()) {
            boolean addDelegateObject;
            node.addInterface(ClassHelper.make(GroovyObject.class));
            StaticMethodCallExpression initMetaClassCall = new StaticMethodCallExpression(ClassHelper.make(ScriptBytecodeAdapter.class), "initMetaClass", VariableExpression.THIS_EXPRESSION);
            PropertyNode metaClassProperty = node.addProperty("metaClass", 1, ClassHelper.make(MetaClass.class), initMetaClassCall, null, null);
            metaClassProperty.setSynthetic(true);
            FieldNode metaClassField = metaClassProperty.getField();
            metaClassField.setModifiers(metaClassField.getModifiers() | 0x80);
            FieldExpression metaClassVar = new FieldExpression(metaClassField);
            IfStatement initMetaClassField = new IfStatement(new BooleanExpression(new BinaryExpression(metaClassVar, Token.newSymbol(123, -1, -1), ConstantExpression.NULL)), new ExpressionStatement(new BinaryExpression(metaClassVar, Token.newSymbol(100, -1, -1), initMetaClassCall)), EmptyStatement.INSTANCE);
            node.addSyntheticMethod("getMetaClass", 1, ClassHelper.make(MetaClass.class), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(metaClassVar)}, new VariableScope()));
            ClassNode superClass = node.getSuperClass();
            boolean bl = addDelegateObject = node instanceof InnerClassNode && superClass.equals(ClassHelper.CLOSURE_TYPE) || superClass.equals(ClassHelper.GSTRING_TYPE);
            if (!addDelegateObject) {
                VariableExpression vMethods = new VariableExpression("method");
                VariableExpression vArguments = new VariableExpression("arguments");
                VariableScope blockScope = new VariableScope();
                blockScope.getReferencedLocalVariables().put("method", vMethods);
                blockScope.getReferencedLocalVariables().put("arguments", vArguments);
                node.addSyntheticMethod("invokeMethod", 1, ClassHelper.OBJECT_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "method"), new Parameter(ClassHelper.OBJECT_TYPE, "arguments")}, ClassNode.EMPTY_ARRAY, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(new MethodCallExpression((Expression)metaClassVar, "invokeMethod", (Expression)new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, vMethods, vArguments})))}, blockScope));
                if (!node.isScript()) {
                    node.addSyntheticMethod("getProperty", 1, ClassHelper.OBJECT_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "property")}, ClassNode.EMPTY_ARRAY, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(new MethodCallExpression((Expression)metaClassVar, "getProperty", (Expression)new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, new VariableExpression("property")})))}, new VariableScope()));
                    VariableExpression vProp = new VariableExpression("property");
                    VariableExpression vValue = new VariableExpression("value");
                    blockScope = new VariableScope();
                    blockScope.getReferencedLocalVariables().put("property", vProp);
                    blockScope.getReferencedLocalVariables().put("value", vValue);
                    node.addSyntheticMethod("setProperty", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "property"), new Parameter(ClassHelper.OBJECT_TYPE, "value")}, ClassNode.EMPTY_ARRAY, new BlockStatement(new Statement[]{initMetaClassField, new ExpressionStatement(new MethodCallExpression((Expression)metaClassVar, "setProperty", (Expression)new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, vProp, vValue})))}, blockScope));
                }
            }
        }
        if (node.getDeclaredConstructors().isEmpty()) {
            ConstructorNode constructor = new ConstructorNode(1, null);
            constructor.setSynthetic(true);
            node.addConstructor(constructor);
        }
        if (!(node instanceof InnerClassNode)) {
            FieldNode timeTagField = new FieldNode(__TIMESTAMP, 9, ClassHelper.Long_TYPE, node, new ConstantExpression(new Long(System.currentTimeMillis())));
            timeTagField.setSynthetic(true);
            node.addField(timeTagField);
        }
        this.addInitialization(node);
        this.checkReturnInObjectInitializer(node.getObjectInitializerStatements());
        node.getObjectInitializerStatements().clear();
        node.visitContents(this);
    }

    private void checkReturnInObjectInitializer(List init) {
        CodeVisitorSupport cvs = new CodeVisitorSupport(){

            public void visitReturnStatement(ReturnStatement statement) {
                throw new RuntimeParserException("'return' is not allowed in object initializer", statement);
            }
        };
        Iterator iterator = init.iterator();
        while (iterator.hasNext()) {
            Statement stm = (Statement)iterator.next();
            stm.visit(cvs);
        }
    }

    public void visitConstructor(ConstructorNode node) {
        CodeVisitorSupport checkSuper = new CodeVisitorSupport(){
            boolean firstMethodCall = true;
            String type = null;

            public void visitMethodCallExpression(MethodCallExpression call) {
                if (!this.firstMethodCall) {
                    return;
                }
                this.firstMethodCall = false;
                String name = call.getMethodAsString();
                if (name == null) {
                    return;
                }
                if (!name.equals("super") && !name.equals("this")) {
                    return;
                }
                this.type = name;
                call.getArguments().visit(this);
                this.type = null;
            }

            public void visitVariableExpression(VariableExpression expression) {
                if (this.type == null) {
                    return;
                }
                String name = expression.getName();
                if (!name.equals("this") && !name.equals("super")) {
                    return;
                }
                throw new RuntimeParserException("cannot reference " + name + " inside of " + this.type + "(....) before supertype constructor has been called", expression);
            }
        };
        Statement s = node.getCode();
        if (s == null) {
            return;
        }
        s.visit(checkSuper);
    }

    public void visitMethod(MethodNode node) {
        Parameter param;
        Parameter[] params;
        this.methodNode = node;
        Statement statement = node.getCode();
        if (!node.isVoidMethod()) {
            if (statement instanceof ExpressionStatement) {
                ExpressionStatement expStmt = (ExpressionStatement)statement;
                node.setCode(new ReturnStatement(expStmt.getExpression()));
            } else if (statement instanceof BlockStatement) {
                BlockStatement block = (BlockStatement)statement;
                ArrayList<ReturnStatement> list = new ArrayList<ReturnStatement>(block.getStatements());
                if (!list.isEmpty()) {
                    int idx = list.size() - 1;
                    Statement last = (Statement)list.get(idx);
                    if (last instanceof ExpressionStatement) {
                        ExpressionStatement expStmt = (ExpressionStatement)last;
                        list.set(idx, new ReturnStatement(expStmt));
                    } else if (!(last instanceof ReturnStatement)) {
                        list.add(new ReturnStatement(ConstantExpression.NULL));
                    }
                } else {
                    list.add(new ReturnStatement(ConstantExpression.NULL));
                }
                node.setCode(new BlockStatement(this.filterStatements(list), block.getVariableScope()));
            }
        } else if (!node.isAbstract()) {
            BlockStatement newBlock = new BlockStatement();
            if (statement instanceof BlockStatement) {
                newBlock.addStatements(this.filterStatements(((BlockStatement)statement).getStatements()));
            } else {
                newBlock.addStatement(this.filterStatement(statement));
            }
            newBlock.addStatement(ReturnStatement.RETURN_NULL_OR_VOID);
            node.setCode(newBlock);
        }
        if (node.getName().equals("main") && node.isStatic() && (params = node.getParameters()).length == 1 && ((param = params[0]).getType() == null || param.getType() == ClassHelper.OBJECT_TYPE)) {
            param.setType(ClassHelper.STRING_TYPE.makeArray());
        }
        if ((statement = node.getCode()) != null) {
            statement.visit(new VerifierCodeVisitor(this));
        }
    }

    public void visitField(FieldNode node) {
    }

    public void visitProperty(PropertyNode node) {
        Statement setterBlock;
        String name = node.getName();
        FieldNode field = node.getField();
        String getterName = "get" + Verifier.capitalize(name);
        String setterName = "set" + Verifier.capitalize(name);
        Statement getterBlock = node.getGetterBlock();
        if (getterBlock == null && !node.isPrivate() && this.classNode.getGetterMethod(getterName) == null) {
            getterBlock = this.createGetterBlock(node, field);
        }
        if ((setterBlock = node.getSetterBlock()) == null && !node.isPrivate() && (node.getModifiers() & 0x10) == 0 && this.classNode.getSetterMethod(setterName) == null) {
            setterBlock = this.createSetterBlock(node, field);
        }
        if (getterBlock != null) {
            MethodNode getter = new MethodNode(getterName, node.getModifiers(), node.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, getterBlock);
            getter.setSynthetic(true);
            this.classNode.addMethod(getter);
            this.visitMethod(getter);
            if (ClassHelper.boolean_TYPE == node.getType() || ClassHelper.Boolean_TYPE == node.getType()) {
                String secondGetterName = "is" + Verifier.capitalize(name);
                MethodNode secondGetter = new MethodNode(secondGetterName, node.getModifiers(), node.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, getterBlock);
                secondGetter.setSynthetic(true);
                this.classNode.addMethod(secondGetter);
                this.visitMethod(secondGetter);
            }
        }
        if (setterBlock != null) {
            Parameter[] setterParameterTypes = new Parameter[]{new Parameter(node.getType(), "value")};
            MethodNode setter = new MethodNode(setterName, node.getModifiers(), ClassHelper.VOID_TYPE, setterParameterTypes, ClassNode.EMPTY_ARRAY, setterBlock);
            setter.setSynthetic(true);
            this.classNode.addMethod(setter);
            this.visitMethod(setter);
        }
    }

    protected void addDefaultParameterMethods(final ClassNode node) {
        ArrayList methods = new ArrayList(node.getMethods());
        this.addDefaultParameters(methods, new DefaultArgsAction(){

            public void call(ArgumentListExpression arguments, Parameter[] newParams, MethodNode method) {
                MethodCallExpression expression = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, method.getName(), (Expression)arguments);
                expression.setImplicitThis(true);
                Statement code = null;
                code = method.isVoidMethod() ? new ExpressionStatement(expression) : new ReturnStatement(expression);
                node.addMethod(method.getName(), method.getModifiers(), method.getReturnType(), newParams, method.getExceptions(), code);
            }
        });
    }

    protected void addDefaultParameterConstructors(final ClassNode node) {
        ArrayList methods = new ArrayList(node.getDeclaredConstructors());
        this.addDefaultParameters(methods, new DefaultArgsAction(){

            public void call(ArgumentListExpression arguments, Parameter[] newParams, MethodNode method) {
                ConstructorNode ctor = (ConstructorNode)method;
                ConstructorCallExpression expression = new ConstructorCallExpression(ClassNode.THIS, arguments);
                ExpressionStatement code = new ExpressionStatement(expression);
                node.addConstructor(ctor.getModifiers(), newParams, ctor.getExceptions(), code);
            }
        });
    }

    protected void addDefaultParameters(List methods, DefaultArgsAction action) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!method.hasDefaultValue()) continue;
            Parameter[] parameters = method.getParameters();
            int counter = 0;
            ArrayList<Object> paramValues = new ArrayList<Object>();
            int size = parameters.length;
            for (int i = size - 1; i >= 0; --i) {
                Parameter parameter = parameters[i];
                if (parameter == null || !parameter.hasInitialExpression()) continue;
                paramValues.add(new Integer(i));
                paramValues.add(parameter.getInitialExpression());
                ++counter;
            }
            for (int j = 1; j <= counter; ++j) {
                Parameter[] newParams = new Parameter[parameters.length - j];
                ArgumentListExpression arguments = new ArgumentListExpression();
                int index = 0;
                int k = 1;
                for (int i = 0; i < parameters.length; ++i) {
                    if (k > counter - j && parameters[i] != null && parameters[i].hasInitialExpression()) {
                        arguments.addExpression(parameters[i].getInitialExpression());
                        ++k;
                        continue;
                    }
                    if (parameters[i] != null && parameters[i].hasInitialExpression()) {
                        newParams[index++] = parameters[i];
                        arguments.addExpression(new VariableExpression(parameters[i].getName()));
                        ++k;
                        continue;
                    }
                    newParams[index++] = parameters[i];
                    arguments.addExpression(new VariableExpression(parameters[i].getName()));
                }
                action.call(arguments, newParams, method);
            }
        }
    }

    protected void addClosureCode(InnerClassNode node) {
    }

    protected void addInitialization(ClassNode node) {
        Iterator iter = node.getDeclaredConstructors().iterator();
        while (iter.hasNext()) {
            this.addInitialization(node, (ConstructorNode)iter.next());
        }
    }

    protected void addInitialization(ClassNode node, ConstructorNode constructorNode) {
        Statement firstStatement = constructorNode.getFirstStatement();
        ConstructorCallExpression first = this.getFirstIfSpecialConstructorCall(firstStatement);
        if (first != null && first.isThisCall()) {
            return;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        ArrayList staticStatements = new ArrayList();
        Iterator iter = node.getFields().iterator();
        while (iter.hasNext()) {
            this.addFieldInitialization(statements, staticStatements, (FieldNode)iter.next());
        }
        statements.addAll(node.getObjectInitializerStatements());
        if (!statements.isEmpty()) {
            Statement code = constructorNode.getCode();
            BlockStatement block = new BlockStatement();
            List otherStatements = block.getStatements();
            if (code instanceof BlockStatement) {
                block = (BlockStatement)code;
                otherStatements = block.getStatements();
            } else if (code != null) {
                otherStatements.add(code);
            }
            if (!otherStatements.isEmpty()) {
                if (first != null) {
                    otherStatements.remove(0);
                    statements.add(0, firstStatement);
                }
                statements.addAll(otherStatements);
            }
            constructorNode.setCode(new BlockStatement(statements, block.getVariableScope()));
        }
        if (!staticStatements.isEmpty()) {
            node.addStaticInitializerStatements(staticStatements, true);
        }
    }

    private ConstructorCallExpression getFirstIfSpecialConstructorCall(Statement code) {
        if (code == null || !(code instanceof ExpressionStatement)) {
            return null;
        }
        Expression expression = ((ExpressionStatement)code).getExpression();
        if (!(expression instanceof ConstructorCallExpression)) {
            return null;
        }
        ConstructorCallExpression cce = (ConstructorCallExpression)expression;
        if (cce.isSpecialCall()) {
            return cce;
        }
        return null;
    }

    protected void addFieldInitialization(List list, List staticList, FieldNode fieldNode) {
        Expression expression = fieldNode.getInitialExpression();
        if (expression != null) {
            ExpressionStatement statement = new ExpressionStatement(new BinaryExpression(new FieldExpression(fieldNode), Token.newSymbol(100, fieldNode.getLineNumber(), fieldNode.getColumnNumber()), expression));
            if (fieldNode.isStatic()) {
                staticList.add(statement);
            } else {
                list.add(statement);
            }
        }
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    protected Statement createGetterBlock(PropertyNode propertyNode, FieldNode field) {
        FieldExpression expression = new FieldExpression(field);
        return new ReturnStatement(expression);
    }

    protected Statement createSetterBlock(PropertyNode propertyNode, FieldNode field) {
        FieldExpression expression = new FieldExpression(field);
        return new ExpressionStatement(new BinaryExpression(expression, Token.newSymbol(100, 0, 0), new VariableExpression("value")));
    }

    protected List filterStatements(List list) {
        ArrayList<Statement> answer = new ArrayList<Statement>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            answer.add(this.filterStatement((Statement)iter.next()));
        }
        return answer;
    }

    protected Statement filterStatement(Statement statement) {
        ClosureExpression closureExp;
        ExpressionStatement expStmt;
        Expression expression;
        if (statement instanceof ExpressionStatement && (expression = (expStmt = (ExpressionStatement)statement).getExpression()) instanceof ClosureExpression && !(closureExp = (ClosureExpression)expression).isParameterSpecified()) {
            return closureExp.getCode();
        }
        return statement;
    }

    private static interface DefaultArgsAction {
        public void call(ArgumentListExpression var1, Parameter[] var2, MethodNode var3);
    }
}

