/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.MetaMethod;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class ReflectorGenerator
implements Opcodes {
    private List methods;
    private ClassVisitor cw;
    private BytecodeHelper helper = new BytecodeHelper(null);
    private String classInternalName;

    public ReflectorGenerator(List methods) {
        this.methods = methods;
    }

    public void generate(ClassVisitor cw, String className) {
        this.cw = cw;
        this.classInternalName = BytecodeHelper.getClassInternalName(className);
        cw.visit(47, 33, this.classInternalName, null, "org/codehaus/groovy/runtime/Reflector", null);
        MethodVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "org/codehaus/groovy/runtime/Reflector", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        this.generateInvokeMethod();
        cw.visitEnd();
    }

    protected void generateInvokeMethod() {
        MetaMethod method;
        int i;
        int methodCount = this.methods.size();
        MethodVisitor cv = this.cw.visitMethod(1, "invoke", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 2);
        cv.visitVarInsn(25, 3);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(182, "groovy/lang/MetaMethod", "getMethodIndex", "()I");
        Label defaultLabel = new Label();
        Label[] labels = new Label[methodCount];
        int[] indices = new int[methodCount];
        for (i = 0; i < methodCount; ++i) {
            labels[i] = new Label();
            method = (MetaMethod)this.methods.get(i);
            method.setMethodIndex(i + 1);
            indices[i] = method.getMethodIndex();
        }
        cv.visitLookupSwitchInsn(defaultLabel, indices, labels);
        for (i = 0; i < methodCount; ++i) {
            cv.visitLabel(labels[i]);
            cv.visitMethodInsn(183, this.classInternalName, "m" + i, "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            cv.visitInsn(176);
        }
        cv.visitLabel(defaultLabel);
        cv.visitMethodInsn(182, this.classInternalName, "noSuchMethod", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(4, 4);
        cv.visitEnd();
        for (i = 0; i < methodCount; ++i) {
            cv = this.cw.visitMethod(2, "m" + i, "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            this.helper = new BytecodeHelper(cv);
            method = (MetaMethod)this.methods.get(i);
            this.invokeMethod(method, cv);
            if (method.getReturnType() == Void.TYPE) {
                cv.visitInsn(1);
            }
            cv.visitInsn(176);
            cv.visitMaxs(0, 0);
            cv.visitEnd();
        }
    }

    protected void invokeMethod(MetaMethod method, MethodVisitor cv) {
        Class callClass = method.getInterfaceClass();
        boolean useInterface = false;
        if (callClass == null) {
            callClass = method.getCallClass();
        } else {
            useInterface = true;
        }
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameterTypes());
        if (method.isStatic()) {
            this.loadParameters(method, 3, cv);
            cv.visitMethodInsn(184, type, method.getName(), descriptor);
        } else {
            cv.visitVarInsn(25, 2);
            this.helper.doCast(callClass);
            this.loadParameters(method, 3, cv);
            cv.visitMethodInsn(useInterface ? 185 : 182, type, method.getName(), descriptor);
        }
        this.helper.box(method.getReturnType());
    }

    protected void loadParameters(MetaMethod method, int argumentIndex, MethodVisitor cv) {
        Class[] parameters = method.getParameterTypes();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            cv.visitVarInsn(25, argumentIndex);
            this.helper.pushConstant(i);
            cv.visitInsn(50);
            Class type = parameters[i];
            if (type.isPrimitive()) {
                this.helper.unbox(type);
                continue;
            }
            this.helper.doCast(type);
        }
    }
}

