/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.Collection;
import java.util.Iterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.classgen.AnnotationVisitor;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ExtendedVerifier
implements GroovyClassVisitor {
    public static final String JVM_ERROR_MESSAGE = "Please make sure you are running on a JVM >= 1.5";
    private SourceUnit source;
    private ClassNode currentClass;

    public ExtendedVerifier(SourceUnit sourceUnit) {
        this.source = sourceUnit;
    }

    public void visitClass(ClassNode node) {
        this.currentClass = node;
        this.visitAnnotations(node, 1);
        node.visitContents(this);
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitAnnotations(node, 2);
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations(node, 8);
    }

    public void visitMethod(MethodNode node) {
        this.visitAnnotations(node, 4);
    }

    public void visitProperty(PropertyNode node) {
    }

    protected void visitAnnotations(AnnotatedNode node, int target) {
        if (node.getAnnotations().isEmpty()) {
            return;
        }
        this.currentClass.setAnnotated(true);
        if (!this.isAnnotationCompatible()) {
            this.addError("Annotations are not supported in the current runtime.Please make sure you are running on a JVM >= 1.5", node);
            return;
        }
        Collection annotations = node.getAnnotations().values();
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            AnnotationNode annotation = this.visitAnnotation(an);
            if (!annotation.isValid()) {
                return;
            }
            if (annotation.isTargetAllowed(target)) continue;
            this.addError("Annotation @" + annotation.getClassNode().getName() + " is not allowed on element " + AnnotationNode.targetToName(target), annotation);
        }
    }

    private AnnotationNode visitAnnotation(AnnotationNode node) {
        ErrorCollector errorCollector = new ErrorCollector(this.source.getConfiguration());
        AnnotationVisitor visitor = new AnnotationVisitor(this.source, errorCollector);
        AnnotationNode solvedAnnotation = visitor.visit(node);
        this.source.getErrorCollector().addCollectorContents(errorCollector);
        return solvedAnnotation;
    }

    protected boolean isAnnotationCompatible() {
        return "1.5".equals(this.source.getConfiguration().getTargetBytecode());
    }

    protected void addError(String msg, ASTNode expr) {
        this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr.getLineNumber(), expr.getColumnNumber()), this.source));
    }
}

