/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;

public class AnnotationNode
extends ASTNode {
    public static final int TYPE_TARGET = 1;
    public static final int CONSTRUCTOR_TARGET = 2;
    public static final int METHOD_TARGET = 4;
    public static final int FIELD_TARGET = 8;
    public static final int PARAMETER_TARGET = 16;
    public static final int LOCAL_VARIABLE_TARGET = 32;
    public static final int ANNOTATION_TARGET = 64;
    private static final int ALL_TARGETS = 127;
    private ClassNode classNode;
    private Map members = new HashMap();
    private boolean runtimeRetention = false;
    private boolean sourceRetention = false;
    private int allowedTarges = 127;
    private boolean valid;

    public AnnotationNode(ClassNode classNode) {
        this.classNode = classNode;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public Map getMembers() {
        return this.members;
    }

    public Expression getMember(String name) {
        return (Expression)this.members.get(name);
    }

    public void addMember(String name, Expression value) {
        Expression oldValue = (Expression)this.members.get(name);
        if (oldValue == null) {
            this.members.put(name, value);
        } else {
            ArrayList<Expression> list = null;
            if (oldValue instanceof List) {
                list = (ArrayList<Expression>)((Object)oldValue);
            } else {
                list = new ArrayList<Expression>();
                list.add(oldValue);
                this.members.put(name, list);
            }
            list.add(value);
        }
    }

    public void setMember(String name, Expression value) {
        this.members.put(name, value);
    }

    public boolean isBuiltIn() {
        return false;
    }

    public boolean hasRuntimeRetention() {
        return this.runtimeRetention;
    }

    public void setRuntimeRetention(boolean flag) {
        this.runtimeRetention = flag;
    }

    public boolean hasSourceRetention() {
        return this.sourceRetention;
    }

    public void setSourceRetention(boolean flag) {
        this.sourceRetention = flag;
    }

    public void setAllowedTargets(int bitmap) {
        this.allowedTarges = bitmap;
    }

    public boolean isTargetAllowed(int target) {
        return (this.allowedTarges & target) == target;
    }

    public void setValid(boolean flag) {
        this.valid = flag;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static final String targetToName(int target) {
        switch (target) {
            case 1: {
                return "TYPE";
            }
            case 2: {
                return "CONSTRUCTOR";
            }
            case 4: {
                return "METHOD";
            }
            case 8: {
                return "FIELD";
            }
            case 16: {
                return "PARAMETER";
            }
            case 32: {
                return "LOCAL_VARIABLE";
            }
            case 64: {
                return "ANNOTATION";
            }
        }
        return "unknown target";
    }
}

