/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml.streamingmarkupsupport;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StreamingMarkupWriter
extends Writer {
    protected final Writer writer;
    protected final String encoding;
    protected final CharsetEncoder encoder;
    protected boolean writingAttribute = false;
    private final Writer escapedWriter = new Writer(){

        public void close() throws IOException {
            StreamingMarkupWriter.this.close();
        }

        public void flush() throws IOException {
            StreamingMarkupWriter.this.flush();
        }

        public void write(int c) throws IOException {
            if (!StreamingMarkupWriter.this.encoder.canEncode((char)c)) {
                StreamingMarkupWriter.this.writer.write("&#x");
                StreamingMarkupWriter.this.writer.write(Integer.toHexString(c));
                StreamingMarkupWriter.this.writer.write(59);
            } else if (c == 60) {
                StreamingMarkupWriter.this.writer.write("&lt;");
            } else if (c == 62) {
                StreamingMarkupWriter.this.writer.write("&gt;");
            } else if (c == 38) {
                StreamingMarkupWriter.this.writer.write("&amp;");
            } else if (c == 39 && StreamingMarkupWriter.this.writingAttribute) {
                StreamingMarkupWriter.this.writer.write("&apos;");
            } else {
                StreamingMarkupWriter.this.writer.write(c);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public void setWritingAttribute(boolean writingAttribute) {
            StreamingMarkupWriter.this.writingAttribute = writingAttribute;
        }

        public Writer excaped() {
            return StreamingMarkupWriter.this.escapedWriter;
        }

        public Writer unescaped() {
            return StreamingMarkupWriter.this;
        }
    };

    public StreamingMarkupWriter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding != null ? encoding : (writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : "US-ASCII");
        this.encoder = Charset.forName(this.encoding).newEncoder();
    }

    public StreamingMarkupWriter(Writer writer) {
        this(writer, null);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(int c) throws IOException {
        if (!this.encoder.canEncode((char)c)) {
            this.writer.write("&#x");
            this.writer.write(Integer.toHexString(c));
            this.writer.write(59);
        } else if (c == 39 && this.writingAttribute) {
            this.writer.write("&apos;");
        } else {
            this.writer.write(c);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len-- > 0) {
            this.write(cbuf[off++]);
        }
    }

    public void setWritingAttribute(boolean writingAttribute) {
        this.writingAttribute = writingAttribute;
    }

    public Writer escaped() {
        return this.escapedWriter;
    }

    public Writer unescaped() {
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

