/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.factory;

import groovy.swing.SwingBuilder;
import groovy.swing.factory.Factory;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.Box;

public class BoxFactory
implements Factory {
    public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
        Object o;
        int axis = 0;
        if (properties.containsKey("axis") && (o = properties.remove("axis")) instanceof Number) {
            axis = ((Number)o).intValue();
        }
        return new Box(axis);
    }

    public static class RigidAreaFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            Dimension dim;
            Object o = properties.remove("size");
            if (o instanceof Dimension) {
                dim = (Dimension)o;
            } else {
                o = properties.remove("width");
                int w = o instanceof Number ? ((Number)o).intValue() : 6;
                o = properties.remove("height");
                int h = o instanceof Number ? ((Number)o).intValue() : 6;
                dim = new Dimension(w, h);
            }
            return Box.createRigidArea(dim);
        }
    }

    public static class GlueFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            return Box.createGlue();
        }
    }

    public static class VStrutFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            Object num = value != null ? value : properties.remove("height");
            if (num instanceof Number) {
                return Box.createVerticalStrut(((Number)num).intValue());
            }
            return Box.createVerticalStrut(6);
        }
    }

    public static class VGlueFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            return Box.createVerticalGlue();
        }
    }

    public static class VBoxFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            return Box.createVerticalBox();
        }
    }

    public static class HStrutFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            Object num = value != null ? value : properties.remove("width");
            if (num instanceof Number) {
                return Box.createHorizontalStrut(((Number)num).intValue());
            }
            return Box.createHorizontalStrut(6);
        }
    }

    public static class HGlueFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            return Box.createHorizontalGlue();
        }
    }

    public static class HBoxFactory
    implements Factory {
        public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            return Box.createHorizontalBox();
        }
    }
}

