/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing;

import groovy.model.DefaultTableModel;
import groovy.swing.factory.ActionFactory;
import groovy.swing.factory.BoxFactory;
import groovy.swing.factory.BoxLayoutFactory;
import groovy.swing.factory.ComboBoxFactory;
import groovy.swing.factory.DialogFactory;
import groovy.swing.factory.Factory;
import groovy.swing.factory.FormattedTextFactory;
import groovy.swing.factory.FrameFactory;
import groovy.swing.factory.MapFactory;
import groovy.swing.factory.SplitPaneFactory;
import groovy.swing.factory.TableLayoutFactory;
import groovy.swing.factory.TableModelFactory;
import groovy.swing.factory.WidgetFactory;
import groovy.swing.factory.WindowFactory;
import groovy.swing.impl.ComponentFacade;
import groovy.swing.impl.ContainerFacade;
import groovy.swing.impl.Startable;
import groovy.util.BuilderSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SwingBuilder
extends BuilderSupport {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Map factories = new HashMap();
    private Object constraints;
    private Map widgets = new HashMap();
    private LinkedList containingWindows = new LinkedList();

    public SwingBuilder() {
        this.registerWidgets();
    }

    public Object getProperty(String name) {
        Object widget = this.widgets.get(name);
        if (widget == null) {
            return super.getProperty(name);
        }
        return widget;
    }

    protected void setParent(Object parent, Object child) {
        if (child instanceof Action) {
            this.setParentForAction(parent, (Action)child);
        } else if (child instanceof LayoutManager) {
            Container target = SwingBuilder.getLayoutTarget(parent);
            InvokerHelper.setProperty(target, "layout", child);
        } else if (parent instanceof JTable && child instanceof TableColumn) {
            JTable table = (JTable)parent;
            TableColumn column = (TableColumn)child;
            table.addColumn(column);
        } else if (parent instanceof JTabbedPane && child instanceof Component) {
            JTabbedPane tabbedPane = (JTabbedPane)parent;
            tabbedPane.add((Component)child);
        } else if (!(child instanceof Window)) {
            Component component = null;
            if (child instanceof Component) {
                component = (Component)child;
            } else if (child instanceof ComponentFacade) {
                ComponentFacade facade = (ComponentFacade)child;
                component = facade.getComponent();
            }
            if (component != null) {
                this.setParentForComponent(parent, component);
            }
        }
    }

    private void setParentForComponent(Object parent, Component component) {
        if (parent instanceof JFrame && component instanceof JMenuBar) {
            JFrame frame = (JFrame)parent;
            frame.setJMenuBar((JMenuBar)component);
        } else if (parent instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)parent;
            if (this.constraints != null) {
                rpc.getContentPane().add(component, this.constraints);
            } else {
                rpc.getContentPane().add(component);
            }
        } else if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            if (component instanceof JViewport) {
                scrollPane.setViewport((JViewport)component);
            } else {
                scrollPane.setViewportView(component);
            }
        } else if (parent instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)parent;
            if (splitPane.getOrientation() == 1) {
                if (splitPane.getTopComponent() == null) {
                    splitPane.setTopComponent(component);
                } else {
                    splitPane.setBottomComponent(component);
                }
            } else if (splitPane.getLeftComponent() == null) {
                splitPane.setLeftComponent(component);
            } else {
                splitPane.setRightComponent(component);
            }
        } else if (parent instanceof JMenuBar && component instanceof JMenu) {
            JMenuBar menuBar = (JMenuBar)parent;
            menuBar.add((JMenu)component);
        } else if (parent instanceof Container) {
            Container container = (Container)parent;
            if (this.constraints != null) {
                container.add(component, this.constraints);
            } else {
                container.add(component);
            }
        } else if (parent instanceof ContainerFacade) {
            ContainerFacade facade = (ContainerFacade)parent;
            facade.addComponent(component);
        }
    }

    private void setParentForAction(Object parent, Action action) {
        try {
            InvokerHelper.setProperty(parent, "action", action);
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        Object keyStroke = action.getValue("KeyStroke");
        if (parent instanceof JComponent) {
            JComponent component = (JComponent)parent;
            KeyStroke stroke = null;
            if (keyStroke instanceof String) {
                stroke = KeyStroke.getKeyStroke((String)keyStroke);
            } else if (keyStroke instanceof KeyStroke) {
                stroke = (KeyStroke)keyStroke;
            }
            if (stroke != null) {
                String key = action.toString();
                component.getInputMap().put(stroke, key);
                component.getActionMap().put(key, action);
            }
        }
    }

    public static Container getLayoutTarget(Object parent) {
        Container target = (Container)parent;
        if (target instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)((Object)target);
            target = rpc.getContentPane();
        }
        return target;
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (node instanceof TableModel && parent instanceof JTable) {
            JTable table = (JTable)parent;
            TableModel model = (TableModel)node;
            table.setModel(model);
            if (model instanceof DefaultTableModel) {
                table.setColumnModel(((DefaultTableModel)model).getColumnModel());
            }
        }
        if (node instanceof Startable) {
            Startable startable = (Startable)node;
            startable.start();
        }
        if (node instanceof Window && !this.containingWindows.isEmpty() && this.containingWindows.getLast() == node) {
            this.containingWindows.removeLast();
        }
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP, null);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        String widgetName = (String)attributes.remove("id");
        this.constraints = attributes.remove("constraints");
        Object widget = null;
        Factory factory = (Factory)this.factories.get(name);
        if (factory == null) {
            this.log.log(Level.WARNING, "Could not find match for name: " + name);
            return null;
        }
        try {
            widget = factory.newInstance(this, name, value, attributes);
            if (widget == null) {
                this.log.log(Level.WARNING, "Factory for name: " + name + " returned null");
                return null;
            }
            if (widgetName != null) {
                this.widgets.put(widgetName, widget);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("For name: " + name + " created widget: " + widget);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        this.handleWidgetAttributes(widget, attributes);
        if (widget != null && value != null && widget != value) {
            if (value instanceof String) {
                InvokerHelper.invokeMethod(widget, "setText", (String)value);
            } else {
                throw new RuntimeException("The first argument of " + name + " must be a String.");
            }
        }
        return widget;
    }

    protected void handleWidgetAttributes(Object widget, Map attributes) {
        Object mnemonic;
        Object o;
        if (attributes.isEmpty() || widget == null) {
            return;
        }
        if (attributes.containsKey("buttonGroup") && (o = attributes.get("buttonGroup")) instanceof ButtonGroup && widget instanceof AbstractButton) {
            ((AbstractButton)widget).getModel().setGroup((ButtonGroup)o);
            attributes.remove("buttonGroup");
        }
        if ((mnemonic = attributes.remove("mnemonic")) != null) {
            if (mnemonic instanceof Number) {
                InvokerHelper.setProperty(widget, "mnemonic", new Character((char)((Number)mnemonic).intValue()));
            } else {
                InvokerHelper.setProperty(widget, "mnemonic", new Character(mnemonic.toString().charAt(0)));
            }
        }
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setProperty(widget, property, value);
        }
    }

    public static String capitalize(String text) {
        char ch = text.charAt(0);
        if (Character.isUpperCase(ch)) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        buffer.append(Character.toUpperCase(ch));
        buffer.append(text.substring(1));
        return buffer.toString();
    }

    protected void registerWidgets() {
        this.registerFactory("action", new ActionFactory());
        this.registerBeanFactory("buttonGroup", ButtonGroup.class);
        this.registerFactory("map", new MapFactory());
        this.registerFactory("widget", new WidgetFactory());
        this.registerFactory("dialog", new DialogFactory());
        this.registerBeanFactory("fileChooser", JFileChooser.class);
        this.registerFactory("frame", new FrameFactory());
        this.registerBeanFactory("optionPane", JOptionPane.class);
        this.registerFactory("window", new WindowFactory());
        this.registerBeanFactory("button", JButton.class);
        this.registerBeanFactory("checkBox", JCheckBox.class);
        this.registerBeanFactory("checkBoxMenuItem", JCheckBoxMenuItem.class);
        this.registerBeanFactory("colorChooser", JColorChooser.class);
        this.registerFactory("comboBox", new ComboBoxFactory());
        this.registerBeanFactory("desktopPane", JDesktopPane.class);
        this.registerBeanFactory("editorPane", JEditorPane.class);
        this.registerFactory("formattedTextField", new FormattedTextFactory());
        this.registerBeanFactory("internalFrame", JInternalFrame.class);
        this.registerBeanFactory("label", JLabel.class);
        this.registerBeanFactory("layeredPane", JLayeredPane.class);
        this.registerBeanFactory("list", JList.class);
        this.registerBeanFactory("menu", JMenu.class);
        this.registerBeanFactory("menuBar", JMenuBar.class);
        this.registerBeanFactory("menuItem", JMenuItem.class);
        this.registerBeanFactory("panel", JPanel.class);
        this.registerBeanFactory("passwordField", JPasswordField.class);
        this.registerBeanFactory("popupMenu", JPopupMenu.class);
        this.registerBeanFactory("progressBar", JProgressBar.class);
        this.registerBeanFactory("radioButton", JRadioButton.class);
        this.registerBeanFactory("radioButtonMenuItem", JRadioButtonMenuItem.class);
        this.registerBeanFactory("scrollBar", JScrollBar.class);
        this.registerBeanFactory("scrollPane", JScrollPane.class);
        this.registerBeanFactory("separator", JSeparator.class);
        this.registerBeanFactory("slider", JSlider.class);
        this.registerBeanFactory("spinner", JSpinner.class);
        this.registerFactory("splitPane", new SplitPaneFactory());
        this.registerBeanFactory("tabbedPane", JTabbedPane.class);
        this.registerBeanFactory("table", JTable.class);
        this.registerBeanFactory("tableColumn", TableColumn.class);
        this.registerBeanFactory("textArea", JTextArea.class);
        this.registerBeanFactory("textPane", JTextPane.class);
        this.registerBeanFactory("textField", JTextField.class);
        this.registerBeanFactory("toggleButton", JToggleButton.class);
        this.registerBeanFactory("toolBar", JToolBar.class);
        this.registerBeanFactory("tree", JTree.class);
        this.registerBeanFactory("viewport", JViewport.class);
        this.registerBeanFactory("boundedRangeModel", DefaultBoundedRangeModel.class);
        this.registerBeanFactory("spinnerDateModel", SpinnerDateModel.class);
        this.registerBeanFactory("spinnerListModel", SpinnerListModel.class);
        this.registerBeanFactory("spinnerNumberModel", SpinnerNumberModel.class);
        this.registerFactory("tableModel", new TableModelFactory());
        this.registerFactory("propertyColumn", new TableModelFactory.PropertyColumnFactory());
        this.registerFactory("closureColumn", new TableModelFactory.ClosureColumnFactory());
        this.registerBeanFactory("borderLayout", BorderLayout.class);
        this.registerBeanFactory("cardLayout", CardLayout.class);
        this.registerBeanFactory("flowLayout", FlowLayout.class);
        this.registerBeanFactory("gridBagLayout", GridBagLayout.class);
        this.registerBeanFactory("gridLayout", GridLayout.class);
        this.registerBeanFactory("overlayLayout", OverlayLayout.class);
        this.registerBeanFactory("springLayout", SpringLayout.class);
        this.registerBeanFactory("gridBagConstraints", GridBagConstraints.class);
        this.registerBeanFactory("gbc", GridBagConstraints.class);
        this.registerFactory("boxLayout", new BoxLayoutFactory());
        this.registerFactory("box", new BoxFactory());
        this.registerFactory("hbox", new BoxFactory.HBoxFactory());
        this.registerFactory("hglue", new BoxFactory.HGlueFactory());
        this.registerFactory("hstrut", new BoxFactory.HStrutFactory());
        this.registerFactory("vbox", new BoxFactory.VBoxFactory());
        this.registerFactory("vglue", new BoxFactory.VGlueFactory());
        this.registerFactory("vstrut", new BoxFactory.VStrutFactory());
        this.registerFactory("glue", new BoxFactory.GlueFactory());
        this.registerFactory("rigidArea", new BoxFactory.RigidAreaFactory());
        this.registerFactory("tableLayout", new TableLayoutFactory());
        this.registerFactory("tr", new TableLayoutFactory.TRFactory());
        this.registerFactory("td", new TableLayoutFactory.TDFactory());
    }

    public void registerBeanFactory(String name, final Class beanClass) {
        this.registerFactory(name, new Factory(){

            public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
                return beanClass.newInstance();
            }
        });
    }

    public void registerFactory(String name, Factory factory) {
        this.factories.put(name, factory);
    }

    public LinkedList getContainingWindows() {
        return this.containingWindows;
    }

    public Object getCurrent() {
        return super.getCurrent();
    }
}

