/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.pdf.DocumentData;
import org.jboss.seam.ui.util.Faces;

@Name(value="org.jboss.seam.pdf.documentStore")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0)
public class DocumentStore
implements Serializable {
    private static final long serialVersionUID = -357154201942127711L;
    Map<String, DocumentData> dataStore = new HashMap<String, DocumentData>();
    long nextId = 1L;
    boolean useExtensions = false;
    String errorPage = null;

    public void setUseExtensions(boolean useExtensions) {
        this.useExtensions = useExtensions;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public String newId() {
        return String.valueOf(this.nextId++);
    }

    public void saveData(String id, DocumentData documentData) {
        this.dataStore.put(id, documentData);
    }

    public boolean idIsValid(String id) {
        return this.dataStore.get(id) != null;
    }

    public DocumentData getDocumentData(String id) {
        return this.dataStore.get(id);
    }

    public static DocumentStore instance() {
        return (DocumentStore)Component.getInstance(DocumentStore.class);
    }

    public String preferredUrlForContent(String baseName, String extension, String contentId) {
        return this.baseUrlForContent(baseName, extension) + "?docId=" + contentId;
    }

    protected String baseUrlForContent(String baseName, String extension) {
        if (this.useExtensions) {
            return baseName + "." + extension;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ViewHandler handler = context.getApplication().getViewHandler();
        String url = handler.getActionURL(context, "/seam-doc" + Faces.getDefaultSuffix((FacesContext)context));
        return context.getExternalContext().encodeActionURL(url);
    }
}

