/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private Runnable nextRunnable;
    private Object nextRunnableLock = new Object();
    private WorkerThread[] workers;
    private String threadNamePrefix = "SimpleThreadPoolWorker";
    static /* synthetic */ Class class$org$quartz$simpl$SimpleThreadPool;

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int threadCount, int threadPriority) {
        this.setThreadCount(threadCount);
        this.setThreadPriority(threadPriority);
    }

    public Log getLog() {
        return LogFactory.getLog(class$org$quartz$simpl$SimpleThreadPool == null ? (class$org$quartz$simpl$SimpleThreadPool = SimpleThreadPool.class$("org.quartz.simpl.SimpleThreadPool")) : class$org$quartz$simpl$SimpleThreadPool);
    }

    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int count) {
        this.count = count;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int prio) {
        this.prio = prio;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String prfx) {
        this.threadNamePrefix = prfx;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader) {
        this.inheritLoader = inheritLoader;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup) {
        this.inheritGroup = inheritGroup;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public void initialize() throws SchedulerConfigException {
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.threadGroup = parent;
                parent = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup(parent, "SimpleThreadPool");
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        this.workers = this.createWorkerThreads(this.count);
        for (int i = 0; i < this.count; ++i) {
            if (!this.isThreadsInheritContextClassLoaderOfInitializingThread()) continue;
            this.workers[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    protected WorkerThread[] createWorkerThreads(int count) {
        this.workers = new WorkerThread[count];
        for (int i = 0; i < count; ++i) {
            this.workers[i] = new WorkerThread(this, this.threadGroup, this.getThreadNamePrefix() + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForJobsToComplete) {
        this.isShutdown = true;
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) continue;
            this.workers[i].shutdown();
        }
        Object i = this.nextRunnableLock;
        synchronized (i) {
            this.nextRunnableLock.notifyAll();
        }
        if (waitForJobsToComplete) {
            int alive = this.workers.length;
            while (alive > 0) {
                alive = 0;
                for (int i2 = 0; i2 < this.workers.length; ++i2) {
                    if (!this.workers[i2].isAlive()) continue;
                    try {
                        this.getLog().debug("Waiting for thread no. " + i2 + " to shut down");
                        ++alive;
                        this.workers[i2].join(200L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            int activeCount = this.threadGroup.activeCount();
            if (activeCount > 0) {
                this.getLog().info("There are still " + activeCount + " worker threads active." + " See javadoc runInThread(Runnable) for a possible explanation");
            }
            this.getLog().debug("shutdown complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        if (this.isShutdown) {
            try {
                this.getLog().info("SimpleThreadPool.runInThread(): thread pool has been shutdown. Runnable will not be executed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while (this.nextRunnable != null && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isShutdown) {
                this.nextRunnable = runnable;
                this.nextRunnableLock.notifyAll();
            }
        }
        if (this.isShutdown) {
            new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, false, runnable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getNextRunnable() throws InterruptedException {
        Runnable toRun = null;
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (this.nextRunnable == null) {
                this.nextRunnableLock.wait(1000L);
            }
            if (this.nextRunnable != null) {
                toRun = this.nextRunnable;
                this.nextRunnable = null;
                this.nextRunnableLock.notifyAll();
            }
        }
        return toRun;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WorkerThread
    extends Thread {
        private boolean run = true;
        private SimpleThreadPool tp;
        private Runnable runnable = null;

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon) {
            this(tp, threadGroup, name, prio, isDaemon, null);
        }

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable) {
            super(threadGroup, name);
            this.tp = tp;
            this.runnable = runnable;
            this.setPriority(prio);
            this.setDaemon(isDaemon);
            this.start();
        }

        void shutdown() {
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean runOnce;
            boolean bl = runOnce = this.runnable != null;
            while (this.run) {
                Object var5_9;
                try {
                    block17: {
                        try {
                            if (this.runnable == null) {
                                this.runnable = this.tp.getNextRunnable();
                            }
                            if (this.runnable == null) break block17;
                            this.runnable.run();
                        }
                        catch (InterruptedException unblock) {
                            try {
                                SimpleThreadPool.this.getLog().error("worker threat got 'interrupt'ed.", unblock);
                            }
                            catch (Exception e) {
                            }
                            var5_9 = null;
                            if (runOnce) {
                                this.run = false;
                            }
                            this.runnable = null;
                            this.setPriority(this.tp.getThreadPriority());
                            continue;
                        }
                        catch (Exception exceptionInRunnable) {
                            try {
                                SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable);
                            }
                            catch (Exception exception) {
                            }
                            var5_9 = null;
                            if (runOnce) {
                                this.run = false;
                            }
                            this.runnable = null;
                            this.setPriority(this.tp.getThreadPriority());
                            continue;
                        }
                    }
                    var5_9 = null;
                    if (runOnce) {
                        this.run = false;
                    }
                    this.runnable = null;
                }
                catch (Throwable throwable) {
                    var5_9 = null;
                    if (runOnce) {
                        this.run = false;
                    }
                    this.runnable = null;
                    this.setPriority(this.tp.getThreadPriority());
                    throw throwable;
                }
                this.setPriority(this.tp.getThreadPriority());
            }
            try {
                SimpleThreadPool.this.getLog().debug("WorkerThread is shutting down");
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

