/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.util.IdentitySet;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.PersistentClassConstraint;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Valid;
import org.hibernate.validator.Validator;
import org.hibernate.validator.ValidatorClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassValidator<T>
implements Serializable {
    private static Log log = LogFactory.getLog(ClassValidator.class);
    private static final InvalidValue[] EMPTY_INVALID_VALUE_ARRAY = new InvalidValue[0];
    private final Class<T> beanClass;
    private transient ResourceBundle messageBundle;
    private transient boolean defaultResourceBundle;
    private final transient Map<Class, ClassValidator> childClassValidators;
    private transient List<Validator> beanValidators;
    private transient List<Validator> memberValidators;
    private transient List<Member> memberGetters;
    private transient Map<Validator, String> messages;
    private transient List<Member> childGetters;
    private static final String DEFAULT_VALIDATOR_MESSAGE = "org.hibernate.validator.resources.DefaultValidatorMessages";

    public ClassValidator(Class<T> beanClass) {
        this(beanClass, null);
    }

    public ClassValidator(Class<T> beanClass, ResourceBundle resourceBundle) {
        this(beanClass, resourceBundle, new HashMap<Class, ClassValidator>());
    }

    protected ClassValidator(Class<T> beanClass, ResourceBundle resourceBundle, Map<Class, ClassValidator> childClassValidators) {
        this.beanClass = beanClass;
        this.messageBundle = resourceBundle == null ? this.getDefaultResourceBundle() : resourceBundle;
        this.childClassValidators = childClassValidators;
        this.initValidator(beanClass, childClassValidators, this.messageBundle);
    }

    private ResourceBundle getDefaultResourceBundle() {
        ResourceBundle rb;
        try {
            rb = ResourceBundle.getBundle("ValidatorMessages");
        }
        catch (MissingResourceException e) {
            log.debug((Object)"ResourceBundle ValidatorMessages not found. Delegate to org.hibernate.validator.resources.DefaultValidatorMessages");
            rb = ResourceBundle.getBundle(DEFAULT_VALIDATOR_MESSAGE);
        }
        this.defaultResourceBundle = true;
        return rb;
    }

    private void initValidator(Class<T> beanClass, Map<Class, ClassValidator> childClassValidators, ResourceBundle resourceBundle) {
        this.beanValidators = new ArrayList<Validator>();
        this.memberValidators = new ArrayList<Validator>();
        this.memberGetters = new ArrayList<Member>();
        this.messages = new HashMap<Validator, String>();
        this.childGetters = new ArrayList<Member>();
        childClassValidators.put(beanClass, this);
        Annotation[] classAnnotations = beanClass.getAnnotations();
        for (int i = 0; i < classAnnotations.length; ++i) {
            Annotation classAnnotation = classAnnotations[i];
            Validator beanValidator = this.createValidator(classAnnotation);
            if (beanValidator == null) continue;
            this.beanValidators.add(beanValidator);
        }
        HashSet<Class> classes = new HashSet<Class>();
        this.addSuperClassesAndInterfaces(beanClass, classes);
        for (Class currClass : classes) {
            Method[] methods = currClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.createMemberValidator(method);
                Class<?> clazz = method.getReturnType();
                this.createChildValidator(resourceBundle, method, clazz);
            }
            Field[] fields = currClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                this.createMemberValidator(field);
                Class<?> clazz = field.getType();
                this.createChildValidator(resourceBundle, field, clazz);
            }
        }
    }

    private void addSuperClassesAndInterfaces(Class clazz, Collection<Class> classes) {
        for (Class currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            Class<?>[] interfaces;
            if (!classes.add(currClass)) {
                return;
            }
            for (Class<?> interf : interfaces = currClass.getInterfaces()) {
                this.addSuperClassesAndInterfaces(interf, classes);
            }
        }
    }

    private void createChildValidator(ResourceBundle resourceBundle, Member member, Class clazz) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class)) {
            ClassValidator.setAccessible(member);
            this.childGetters.add(member);
            if (!this.childClassValidators.containsKey(clazz)) {
                new ClassValidator<T>(clazz, resourceBundle, this.childClassValidators);
            }
        }
    }

    private void createMemberValidator(Member member) {
        Annotation[] memberAnnotations = ((AnnotatedElement)((Object)member)).getAnnotations();
        for (int j = 0; j < memberAnnotations.length; ++j) {
            Annotation methodAnnotation = memberAnnotations[j];
            Validator propertyValidator = this.createValidator(methodAnnotation);
            if (propertyValidator == null) continue;
            this.memberValidators.add(propertyValidator);
            ClassValidator.setAccessible(member);
            this.memberGetters.add(member);
        }
    }

    private static void setAccessible(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    private Validator createValidator(Annotation annotation) {
        try {
            ValidatorClass validatorClass = annotation.annotationType().getAnnotation(ValidatorClass.class);
            if (validatorClass == null) {
                return null;
            }
            Validator beanValidator = validatorClass.value().newInstance();
            beanValidator.initialize(annotation);
            String messageTemplate = (String)annotation.getClass().getMethod("message", null).invoke((Object)annotation, new Object[0]);
            String message = this.replace(messageTemplate, annotation);
            this.messages.put(beanValidator, message);
            return beanValidator;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not instantiate ClassValidator", e);
        }
    }

    public boolean hasValidationRules() {
        return this.beanValidators.size() != 0 || this.memberValidators.size() != 0;
    }

    public InvalidValue[] getInvalidValues(T bean) {
        return this.getInvalidValues(bean, (Set<Object>)new IdentitySet());
    }

    protected InvalidValue[] getInvalidValues(T bean, Set<Object> circularityState) {
        Object value;
        Member getter;
        int i;
        if (circularityState.contains(bean)) {
            return EMPTY_INVALID_VALUE_ARRAY;
        }
        circularityState.add(bean);
        if (!this.beanClass.isInstance(bean)) {
            throw new IllegalArgumentException("not an instance of: " + bean.getClass());
        }
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (i = 0; i < this.beanValidators.size(); ++i) {
            Validator validator = this.beanValidators.get(i);
            if (validator.isValid(bean)) continue;
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, null, bean, bean));
        }
        for (i = 0; i < this.memberValidators.size(); ++i) {
            getter = this.memberGetters.get(i);
            if (!Hibernate.isPropertyInitialized(bean, (String)getter.getName())) continue;
            value = this.getMemberValue(bean, getter);
            Validator validator = this.memberValidators.get(i);
            if (validator.isValid(value)) continue;
            String propertyName = this.getPropertyName(getter);
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, propertyName, value, bean));
        }
        for (i = 0; i < this.childGetters.size(); ++i) {
            InvalidValue[] invalidValues;
            getter = this.childGetters.get(i);
            if (!Hibernate.isPropertyInitialized(bean, (String)getter.getName()) || (value = this.getMemberValue(bean, getter)) == null || !Hibernate.isInitialized((Object)value)) continue;
            String propertyName = this.getPropertyName(getter);
            for (InvalidValue invalidValue : invalidValues = this.getClassValidator(value).getInvalidValues(value, circularityState)) {
                invalidValue.addParentBean(bean, propertyName);
                results.add(invalidValue);
            }
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    private ClassValidator getClassValidator(Object value) {
        Class<?> clazz = value.getClass();
        ClassValidator validator = this.childClassValidators.get(clazz);
        if (validator == null) {
            validator = new ClassValidator(clazz);
        }
        return validator;
    }

    public InvalidValue[] getInvalidValues(T bean, String propertyName) {
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (int i = 0; i < this.memberValidators.size(); ++i) {
            Member getter = this.memberGetters.get(i);
            if (!this.getPropertyName(getter).equals(propertyName)) continue;
            Object value = this.getMemberValue(bean, getter);
            Validator validator = this.memberValidators.get(i);
            if (validator.isValid(value)) continue;
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, propertyName, value, bean));
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    public InvalidValue[] getPotentialInvalidValues(String propertyName, Object value) {
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (int i = 0; i < this.memberValidators.size(); ++i) {
            Validator validator;
            Member getter = this.memberGetters.get(i);
            if (!this.getPropertyName(getter).equals(propertyName) || (validator = this.memberValidators.get(i)).isValid(value)) continue;
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, propertyName, value, null));
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    private Object getMemberValue(T bean, Member getter) {
        Object value;
        try {
            value = this.getValue(getter, bean);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    private Object getValue(Member member, T bean) throws IllegalAccessException, InvocationTargetException {
        if (member instanceof Field) {
            return ((Field)member).get(bean);
        }
        if (member instanceof Method) {
            return ((Method)member).invoke(bean, new Object[0]);
        }
        throw new AssertionFailure("Unexpected member: " + member.getClass().getName());
    }

    public String getPropertyName(Member member) {
        String propertyName;
        if (member instanceof Field) {
            propertyName = member.getName();
        } else if (member instanceof Method) {
            propertyName = member.getName();
            if (propertyName.startsWith("is")) {
                propertyName = Introspector.decapitalize(propertyName.substring(2));
            } else if (propertyName.startsWith("get")) {
                propertyName = Introspector.decapitalize(propertyName.substring(3));
            }
        } else {
            throw new AssertionFailure("Unexpected member: " + member.getClass().getName());
        }
        return propertyName;
    }

    private String replace(String message, Annotation parameters) {
        StringTokenizer tokens = new StringTokenizer(message, "{}", true);
        StringBuilder buf = new StringBuilder(30);
        boolean escaped = false;
        while (tokens.hasMoreTokens()) {
            String string;
            Method member;
            String token = tokens.nextToken();
            if ("{".equals(token)) {
                escaped = true;
                continue;
            }
            if ("}".equals(token)) {
                escaped = false;
                continue;
            }
            if (!escaped) {
                buf.append(token);
                continue;
            }
            try {
                member = parameters.getClass().getMethod(token, null);
            }
            catch (NoSuchMethodException nsfme) {
                member = null;
            }
            if (member != null) {
                try {
                    buf.append(member.invoke((Object)parameters, new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("could not render message", e);
                }
            }
            if (this.messageBundle == null || (string = this.messageBundle.getString(token)) == null) continue;
            buf.append(this.replace(string, parameters));
        }
        return buf.toString();
    }

    public void apply(PersistentClass persistentClass) {
        for (Validator validator : this.beanValidators) {
            if (!(validator instanceof PersistentClassConstraint)) continue;
            ((PersistentClassConstraint)((Object)validator)).apply(persistentClass);
        }
        Iterator<Validator> validators = this.memberValidators.iterator();
        Iterator<Member> getters = this.memberGetters.iterator();
        while (validators.hasNext()) {
            Validator validator = validators.next();
            String propertyName = this.getPropertyName(getters.next());
            if (!(validator instanceof PropertyConstraint)) continue;
            try {
                Property property = persistentClass.getIdentifierProperty();
                if (property == null || !propertyName.equals(property.getName())) {
                    property = persistentClass.getProperty(propertyName);
                }
                ((PropertyConstraint)((Object)validator)).apply(property);
            }
            catch (MappingException pnfe) {}
        }
    }

    public void assertValid(T bean) {
        InvalidValue[] values = this.getInvalidValues(bean);
        if (values.length > 0) {
            throw new InvalidStateException(values);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ResourceBundle rb = this.messageBundle;
        if (rb != null && !(rb instanceof Serializable)) {
            this.messageBundle = null;
            if (!this.defaultResourceBundle) {
                log.warn((Object)"Serializing a ClassValidator with a not serializable ResourceBundle: ResourceBundle ignored");
            }
        }
        oos.defaultWriteObject();
        oos.writeObject(this.messageBundle);
        this.messageBundle = rb;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ResourceBundle rb = (ResourceBundle)ois.readObject();
        if (rb == null) {
            rb = this.getDefaultResourceBundle();
        }
        this.initValidator(this.beanClass, new HashMap<Class, ClassValidator>(), rb);
    }
}

