/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom3.bootstrap.DOMImplementationRegistry;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.AbstractMarshaller;
import org.jboss.xml.binding.AttributesImpl;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentWriter;
import org.jboss.xml.binding.DelegatingObjectModelProvider;
import org.jboss.xml.binding.GenericObjectModelProvider;
import org.jboss.xml.binding.ObjectModelProvider;
import org.xml.sax.SAXException;

public class XercesXsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(XercesXsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final Map prefixByUri = new HashMap();
    private Object root;

    public void declareNamespace(String name, String uri) {
        this.prefixByUri.put(uri, name);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        XSModel model = this.loadSchema(xsdReader);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        XSModel model = this.loadSchema(xsdURL);
        this.marshallInternal(provider, root, model, writer);
    }

    private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer) throws IOException, SAXException {
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootQNames.isEmpty()) {
            XSNamedMap components = model.getComponents((short)2);
            for (int i = 0; i < components.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(i);
                this.marshalElement(element, 1, 1);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                AbstractMarshaller.QName qName = (AbstractMarshaller.QName)this.rootQNames.get(i);
                XSElementDeclaration element = model.getElementDeclaration(qName.name, qName.namespaceUri);
                if (element == null) {
                    XSNamedMap components = model.getComponents((short)2);
                    String roots = "";
                    for (int j = 0; j < components.getLength(); ++j) {
                        XSObject xsObject = components.item(j);
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + xsObject.getNamespace() + ":" + xsObject.getName();
                    }
                    throw new IllegalStateException("Root element not found: " + qName.namespaceUri + ":" + qName.name + " among " + roots);
                }
                this.marshalElement(element, 1, 1);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
    }

    private boolean marshalElement(XSElementDeclaration element, int minOccurs, int maxOccurs) {
        Object value;
        if (this.stack.isEmpty()) {
            value = this.provider.getRoot(this.root, element.getNamespace(), element.getName());
            if (value == null) {
                return false;
            }
        } else if (this.stack.peek() instanceof Collection) {
            value = (Collection)this.stack.peek();
        } else {
            value = this.provider.getChildren(this.stack.peek(), element.getNamespace(), element.getName());
            if (value == null) {
                value = this.provider.getElementValue(this.stack.peek(), element.getNamespace(), element.getName());
            }
        }
        if (value != null) {
            this.stack.push(value);
            if (maxOccurs != 1 && value instanceof Collection) {
                Iterator iter = ((Collection)value).iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    this.stack.push(item);
                    this.marshalElementType(element);
                    this.stack.pop();
                }
            } else {
                this.marshalElementType(element);
            }
            this.stack.pop();
        }
        return minOccurs == 0 || value != null;
    }

    private void marshalElementType(XSElementDeclaration element) {
        XSTypeDefinition type = element.getTypeDefinition();
        switch (type.getTypeCategory()) {
            case 16: {
                this.marshalSimpleType(element);
                break;
            }
            case 15: {
                this.marshalComplexType(element);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
            }
        }
    }

    private void marshalSimpleType(XSElementDeclaration element) {
        Object value = this.stack.peek();
        String valueStr = value.toString();
        String prefix = (String)this.prefixByUri.get(element.getNamespace());
        String qName = prefix == null ? element.getName() : prefix + ':' + element.getName();
        this.content.startElement(element.getNamespace(), element.getName(), qName, null);
        this.content.characters(valueStr.toCharArray(), 0, valueStr.length());
        this.content.endElement(element.getNamespace(), element.getName(), qName);
    }

    private void marshalComplexType(XSElementDeclaration element) {
        XSComplexTypeDefinition type = (XSComplexTypeDefinition)element.getTypeDefinition();
        XSParticle particle = type.getParticle();
        XSObjectList attributeUses = type.getAttributeUses();
        AttributesImpl attrs = attributeUses.getLength() > 0 ? new AttributesImpl(attributeUses.getLength()) : null;
        for (int i = 0; i < attributeUses.getLength(); ++i) {
            XSAttributeUse attrUse = (XSAttributeUse)attributeUses.item(i);
            XSAttributeDeclaration attrDec = attrUse.getAttrDeclaration();
            Object attrValue = this.provider.getAttributeValue(this.stack.peek(), attrDec.getNamespace(), attrDec.getName());
            if (attrValue == null) continue;
            attrs.add(attrDec.getNamespace(), attrDec.getName(), attrDec.getName(), attrDec.getTypeDefinition().getName(), attrValue.toString());
        }
        String prefix = (String)this.prefixByUri.get(element.getNamespace());
        String qName = prefix == null ? element.getName() : prefix + ':' + element.getName();
        this.content.startElement(element.getNamespace(), element.getName(), qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle);
        }
        this.content.endElement(element.getNamespace(), element.getName(), qName);
    }

    /*
     * WARNING - void declaration
     */
    private boolean marshalParticle(XSParticle particle) {
        void var2_3;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                boolean marshalled = this.marshalModelGroup((XSModelGroup)term);
                break;
            }
            case 9: {
                boolean marshalled = this.marshalWildcard((XSWildcard)term);
                break;
            }
            case 2: {
                boolean marshalled = this.marshalElement((XSElementDeclaration)term, particle.getMinOccurs(), particle.getMaxOccurs());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        return (boolean)var2_3;
    }

    private boolean marshalWildcard(XSWildcard wildcard) {
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(this.stack.peek().getClass());
        if (mapping == null) {
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + this.stack.peek());
        }
        GenericObjectModelProvider parentProvider = this.provider;
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        this.root = this.stack.peek();
        this.provider = mapping.provider;
        this.stack = new AbstractMarshaller.StackImpl();
        boolean marshalled = false;
        XSModel model = this.loadSchema(mapping.schemaUrl);
        XSNamedMap components = model.getComponents((short)2);
        for (int i = 0; i < components.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)components.item(i);
            marshalled = this.marshalElement(element, 1, 1);
        }
        this.root = parentRoot;
        this.provider = parentProvider;
        this.stack = parentStack;
        return marshalled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean marshalModelGroup(XSModelGroup modelGroup) {
        void var2_2;
        switch (modelGroup.getCompositor()) {
            case 3: {
                boolean marshalled = this.marshalModelGroupAll(modelGroup.getParticles());
                break;
            }
            case 2: {
                boolean marshalled = this.marshalModelGroupChoice(modelGroup.getParticles());
                break;
            }
            case 1: {
                boolean marshalled = this.marshalModelGroupSequence(modelGroup.getParticles());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
            }
        }
        return (boolean)var2_2;
    }

    private boolean marshalModelGroupAll(XSObjectList particles) {
        boolean marshalled = false;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled |= this.marshalParticle(particle);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(XSObjectList particles) {
        boolean marshalled = false;
        Content mainContent = this.content;
        for (int i = 0; i < particles.getLength() && !marshalled; ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.content = new Content();
            marshalled = this.marshalParticle(particle);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(XSObjectList particles) {
        boolean marshalled = true;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled &= this.marshalParticle(particle);
        }
        return marshalled;
    }

    private XSModel loadSchema(String xsdURL) {
        XSImplementation impl = this.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.loadURI(xsdURL);
        if (model == null) {
            throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
        }
        return model;
    }

    private XSModel loadSchema(Reader xsdReader) {
        XSImplementation impl = this.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.load(null);
        if (model == null) {
            throw new IllegalArgumentException("Cannot load schema");
        }
        return model;
    }

    private XSImplementation getXSImplementation() {
        XSImplementation impl;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        }
        catch (Exception e) {
            log.error("Failed to create schema loader.", e);
            throw new IllegalStateException("Failed to create schema loader: " + e.getMessage());
        }
        return impl;
    }
}

