/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.InputStream;
import java.io.Reader;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xml.binding.JBossXBException;
import org.jboss.xml.binding.ObjectModelBuilder;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;
import org.jboss.xml.binding.parser.JBossXBParser;
import org.jboss.xml.binding.parser.xni.XniJBossXBParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class UnmarshallerImpl
implements Unmarshaller {
    private static final Logger log = Logger.getLogger(UnmarshallerImpl.class);
    private ObjectModelBuilder builder = new ObjectModelBuilder();
    private final JBossXBParser parser = new XniJBossXBParser();

    public UnmarshallerImpl() throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/validation", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
        this.parser.setEntityResolver(new JBossEntityResolver());
    }

    public void setValidation(boolean validation) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/validation", validation);
    }

    public void setNamespaceAware(boolean namespaces) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/namespaces", namespaces);
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        this.builder.mapFactoryToNamespace(factory, namespaceUri);
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root);
        this.parser.parse(reader, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root);
        this.parser.parse(is, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root);
        this.parser.parse(systemId, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }
}

