/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class NamespaceRegistry
implements NamespaceContext {
    public static final String PREFIX_XML_SCHEMA = "xsd";
    public static final String URI_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String PREFIX_XML_SCHEMA_INSTANCE = "xsi";
    public static final String URI_XML_SCHEMA_INSTANCE = "http://www.w3.org/2000/10/XMLSchema-instance";
    private int namespaceIndex;
    private final Map prefixByUri = new HashMap();
    private final Map uriByPrefix = new HashMap();

    public NamespaceRegistry() {
        this.registerURI(URI_XML_SCHEMA, PREFIX_XML_SCHEMA);
        this.registerURI(URI_XML_SCHEMA_INSTANCE, PREFIX_XML_SCHEMA_INSTANCE);
    }

    public QName registerQName(QName qname) {
        if (qname == null) {
            return null;
        }
        String nsURI = qname.getNamespaceURI();
        String prefix = this.getPrefix(nsURI);
        if (prefix == null) {
            prefix = qname.getPrefix();
            prefix = prefix.length() == 0 ? this.registerURI(nsURI, null) : this.registerURI(nsURI, prefix);
        }
        qname = new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        return qname;
    }

    public String registerURI(String nsURI, String prefix) {
        if (prefix == null) {
            prefix = "ns" + ++this.namespaceIndex;
        }
        this.addPrefixMapping(prefix, nsURI);
        return prefix;
    }

    public void addPrefixMapping(String prefix, String uri) {
        LinkedList<Object> list;
        Object obj = this.uriByPrefix.get(prefix);
        if (obj == null) {
            this.uriByPrefix.put(prefix, uri);
        } else if (obj instanceof String) {
            list = new LinkedList<Object>();
            list.add(obj);
            list.add(uri);
            this.uriByPrefix.put(prefix, list);
        } else if (obj instanceof LinkedList) {
            ((LinkedList)obj).add(uri);
        } else {
            this.throwUnexpectedEntryException(obj);
        }
        obj = this.prefixByUri.get(uri);
        if (obj == null) {
            this.prefixByUri.put(uri, prefix);
        } else if (obj instanceof String) {
            list = new LinkedList();
            list.add(obj);
            list.add(prefix);
            this.prefixByUri.put(uri, list);
        } else if (obj instanceof LinkedList) {
            ((LinkedList)obj).add(prefix);
        } else {
            this.throwUnexpectedEntryException(obj);
        }
    }

    public void removePrefixMapping(String prefix) {
        Object obj = this.uriByPrefix.get(prefix);
        if (obj != null) {
            LinkedList list;
            String uri = null;
            if (obj instanceof String) {
                uri = (String)obj;
                this.uriByPrefix.remove(prefix);
            } else if (obj instanceof LinkedList) {
                list = (LinkedList)obj;
                uri = (String)list.removeLast();
                if (list.isEmpty()) {
                    this.uriByPrefix.remove(prefix);
                }
            } else {
                this.throwUnexpectedEntryException(obj);
            }
            if (uri != null) {
                obj = this.prefixByUri.get(uri);
                if (obj instanceof String) {
                    if (!prefix.equals(obj)) {
                        throw new IllegalStateException("Inconsistent mapping: prefix=" + prefix + ", found=" + obj);
                    }
                    this.prefixByUri.remove(uri);
                } else if (obj instanceof LinkedList) {
                    list = (LinkedList)obj;
                    list.remove(prefix);
                    if (list.isEmpty()) {
                        this.prefixByUri.remove(uri);
                    }
                } else {
                    this.throwUnexpectedEntryException(obj);
                }
            }
        }
    }

    public void unregisterURI(String nsURI) {
        Object obj = this.prefixByUri.get(nsURI);
        if (obj != null) {
            String prefix = null;
            if (obj instanceof String) {
                prefix = (String)obj;
                this.prefixByUri.remove(nsURI);
                this.removePrefixMappingOnly(prefix, nsURI);
            } else if (obj instanceof LinkedList) {
                LinkedList list = (LinkedList)obj;
                for (int i = 0; i < list.size(); ++i) {
                    this.removePrefixMappingOnly((String)list.get(i), nsURI);
                }
                this.prefixByUri.remove(nsURI);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
    }

    public boolean isRegistered(String nsURI) {
        return this.prefixByUri.containsKey(nsURI);
    }

    public Iterator getRegisteredURIs() {
        return this.prefixByUri.keySet().iterator();
    }

    public String getPrefix(String nsURI) {
        Object obj = this.prefixByUri.get(nsURI);
        String prefix = null;
        if (obj != null) {
            if (obj instanceof String) {
                prefix = (String)obj;
            } else if (obj instanceof LinkedList) {
                prefix = (String)((LinkedList)obj).getLast();
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
        return prefix;
    }

    public Iterator getPrefixes(String namespaceURI) {
        Object obj = this.prefixByUri.get(namespaceURI);
        Iterator<Object> result = null;
        if (obj == null) {
            result = Collections.EMPTY_LIST.iterator();
        } else if (obj instanceof String) {
            result = Collections.singletonList(obj).iterator();
        } else if (obj instanceof LinkedList) {
            result = ((LinkedList)obj).iterator();
        } else {
            this.throwUnexpectedEntryException(obj);
        }
        return result;
    }

    public String getNamespaceURI(String prefix) {
        Object obj = this.uriByPrefix.get(prefix);
        String uri = null;
        if (obj != null) {
            if (obj instanceof String) {
                uri = (String)obj;
            } else if (obj instanceof LinkedList) {
                uri = (String)((LinkedList)obj).getLast();
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
        return uri;
    }

    private void removePrefixMappingOnly(String prefix, String nsURI) {
        Object obj = this.uriByPrefix.get(prefix);
        if (obj instanceof String) {
            if (!obj.equals(nsURI)) {
                throw new IllegalStateException("Inconsistent mapping: uri=" + nsURI + ", found=" + obj);
            }
            this.uriByPrefix.remove(prefix);
        } else if (obj instanceof LinkedList) {
            LinkedList list = (LinkedList)obj;
            list.remove(prefix);
            if (list.isEmpty()) {
                this.uriByPrefix.remove(prefix);
            }
        }
    }

    private void throwUnexpectedEntryException(Object entry) {
        throw new IllegalStateException("Unexpected entry type: expected java.lang.String or java.util.LinkedList but got " + entry.getClass());
    }
}

