/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import javassist.CtMember;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.pointcut.Pointcut;

public class JoinpointSimpleClassifier
extends JoinpointClassifier {
    protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher) throws NotFoundException {
        Collection pointcuts = advisor.getManager().getPointcuts().values();
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            Pointcut pointcut = (Pointcut)it.next();
            if (!joinpointMatcher.matches(pointcut, advisor, member)) continue;
            if (AspectManager.verbose) {
                System.out.println("[debug] " + member + " matches pointcut: " + pointcut.getExpr());
            }
            return JoinpointClassification.WRAPPED;
        }
        if (AspectManager.verbose) {
            System.out.println("[debug] " + member + " matches no pointcuts");
        }
        return JoinpointClassification.NOT_INSTRUMENTED;
    }
}

