/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CodeConversionObserver;
import org.jboss.aop.instrument.Codifier;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;

public class FieldAccessTransformer
implements CodeConversionObserver {
    Instrumentor instrumentor;
    boolean optimize;
    NotOptimizedTransformer notOptimizedTransformer;
    OptimizedTransformer optimizedTransformer;
    private Codifier codifier;
    private JoinpointClassifier classifier;
    private static final String[] transformations = new String[]{"get", "set"};
    private static final int GET_INDEX = 0;
    private static final int SET_INDEX = 1;
    private static final WrapperTransformer wrapper = new WrapperTransformer(transformations);

    public FieldAccessTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.optimize = AspectManager.optimize;
        this.codifier = new Codifier();
        this.classifier = instrumentor.joinpointClassifier;
        if (this.optimize) {
            this.optimizedTransformer = new OptimizedTransformer();
        } else {
            this.notOptimizedTransformer = new NotOptimizedTransformer();
        }
    }

    public void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
        if (this.optimize) {
            this.optimizedTransformer.buildFieldWrappers(clazz, advisor);
        } else {
            this.notOptimizedTransformer.buildFieldWrappers(clazz, advisor);
        }
    }

    public boolean replaceFieldAccess(List fields, CtClass clazz, ClassAdvisor fieldsAdvisor) throws NotFoundException {
        CodeConverter converter = this.instrumentor.getCodeConverter();
        boolean converted = false;
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            JoinpointClassification fieldSetClassification;
            CtField field = (CtField)it.next();
            if (Modifier.isPrivate((int)field.getModifiers()) || !Instrumentor.isAdvisable(field)) continue;
            JoinpointClassification fieldGetClassification = this.classifier.classifyFieldGet(field, fieldsAdvisor);
            if (fieldGetClassification.equals(JoinpointClassification.WRAPPED)) {
                converted = true;
                converter.replaceFieldRead(field, clazz, this.fieldRead(field.getName()));
            }
            if (!(fieldSetClassification = this.classifier.classifyFieldSet(field, fieldsAdvisor)).equals(JoinpointClassification.WRAPPED)) continue;
            converted = true;
            converter.replaceFieldWrite(field, clazz, this.fieldWrite(field.getName()));
        }
        return converted;
    }

    public void wrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet) throws CannotCompileException, NotFoundException {
        CtMethod method;
        String code;
        CtField field;
        int fieldIndex;
        List advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        Iterator iterator = fieldsGet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 0)) continue;
            wrapper.wrap((CtMember)field, 0);
            code = "{" + field.getType().getName() + " var; return var;}";
            method = clazz.getDeclaredMethod(this.fieldRead(field.getName()));
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, true, fieldIndex);
            if (!Modifier.isPrivate((int)field.getModifiers())) {
                this.instrumentor.converter.replaceFieldRead(field, clazz, this.fieldRead(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, true, false, fieldIndex);
            method.setBody(code);
        }
        iterator = fieldsSet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 1)) continue;
            wrapper.wrap((CtMember)field, 1);
            code = "{ System.out.print(\"\"); }";
            method = clazz.getDeclaredMethod(this.fieldWrite(field.getName()));
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, false, fieldIndex);
            if (!Modifier.isPrivate((int)field.getModifiers())) {
                this.instrumentor.converter.replaceFieldWrite(field, clazz, this.fieldWrite(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, false, true, fieldIndex);
            method.setBody(code);
        }
    }

    public void unwrap(CtClass clazz, Collection fieldsGet, Collection fieldsSet) throws CannotCompileException, NotFoundException {
        String target;
        CtMethod method;
        CtField field;
        int fieldIndex;
        ClassPool classPool = this.instrumentor.getClassPool();
        List advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        Iterator iterator = fieldsGet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 0)) continue;
            wrapper.unwrap((CtMember)field, 0);
            method = clazz.getDeclaredMethod(this.fieldRead(field.getName()));
            target = Modifier.isStatic((int)field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody("return " + target + "." + field.getName() + ";");
        }
        iterator = fieldsSet.iterator();
        while (iterator.hasNext()) {
            fieldIndex = (Integer)iterator.next();
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared((CtMember)field, 1)) continue;
            wrapper.unwrap((CtMember)field, 1);
            method = clazz.getDeclaredMethod(this.fieldWrite(field.getName()));
            target = Modifier.isStatic((int)field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody(target + "." + field.getName() + "=$2" + ";");
        }
    }

    public void codeConverted() throws NotFoundException, CannotCompileException {
        this.codifier.codifyPending();
    }

    private int fieldOffset(CtClass clazz) throws NotFoundException {
        if (clazz == null) {
            return 0;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return 0;
        }
        int offset = this.fieldOffset(clazz.getSuperclass());
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Instrumentor.isAdvisable(fields[i])) continue;
            ++offset;
        }
        return offset;
    }

    private JoinpointClassification[] classifyFieldGet(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        List fields = Instrumentor.getAdvisableFields(clazz);
        JoinpointClassification[] classification = new JoinpointClassification[fields.size()];
        int index = 0;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CtField field = (CtField)iterator.next();
            classification[index] = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
            ++index;
        }
        return classification;
    }

    private JoinpointClassification[] classifyFieldSet(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        List fields = Instrumentor.getAdvisableFields(clazz);
        JoinpointClassification[] classification = new JoinpointClassification[fields.size()];
        int index = 0;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CtField field = (CtField)iterator.next();
            classification[index] = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
            ++index;
        }
        return classification;
    }

    String fieldRead(String fieldName) {
        return fieldName + "_r_" + "$aop";
    }

    String fieldWrite(String fieldName) {
        return fieldName + "_w_" + "$aop";
    }

    private int getModifiers(CtField field) {
        int mod = 8;
        mod = (field.getModifiers() & 1) != 0 ? (mod |= 1) : ((field.getModifiers() & 4) != 0 ? (mod |= 4) : ((field.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
        return mod;
    }

    private void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        FieldAccessExprEditor expr = new FieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    private void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod) throws NotFoundException, CannotCompileException {
        if (doGet) {
            this.buildReadWrapperPlaceHolder(clazz, field, mod);
        }
        if (doSet) {
            this.buildWriteWrapperPlaceHolder(clazz, field, mod);
        }
    }

    private void buildReadWrapperPlaceHolder(CtClass clazz, CtField field, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        String name = field.getName();
        CtClass ftype = field.getType();
        CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
        String code = "{" + ftype.getName() + " var = ";
        if (ftype.isPrimitive()) {
            if (ftype == CtClass.booleanType) {
                code = code + false;
            } else if (ftype == CtClass.byteType) {
                code = code + "(byte)0";
            } else if (ftype == CtClass.charType) {
                code = code + "(char)0";
            } else if (ftype == CtClass.doubleType) {
                code = code + "0.0";
            } else if (ftype == CtClass.floatType) {
                code = code + "(float)0.0";
            } else if (ftype == CtClass.intType) {
                code = code + "0";
            } else if (ftype == CtClass.longType) {
                code = code + "(long)0";
            } else if (ftype == CtClass.shortType) {
                code = code + "(short)0";
            }
        } else {
            code = code + "null";
        }
        code = code + "; return var;}";
        CtMethod rmethod = CtNewMethod.make((CtClass)ftype, (String)this.fieldRead(name), (CtClass[])readParam, null, null, (CtClass)clazz);
        rmethod.setModifiers(mod);
        rmethod.setBody(code);
        clazz.addMethod(rmethod);
    }

    private void buildWriteWrapperPlaceHolder(CtClass clazz, CtField field, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        String name = field.getName();
        CtClass ftype = field.getType();
        CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
        String code = "{ System.out.print(\"\"); }";
        CtMethod wmethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)this.fieldWrite(name), (CtClass[])writeParam, null, null, (CtClass)clazz);
        wmethod.setModifiers(mod);
        wmethod.setBody(code);
        clazz.addMethod(wmethod);
    }

    private String getWrapperBody(CtClass clazz, CtField field, boolean get, int fieldIndex) throws NotFoundException, CannotCompileException {
        if (this.optimize) {
            return this.optimizedTransformer.getOptimizedWrapperBody(clazz, field, get, fieldIndex);
        }
        return this.notOptimizedTransformer.getNotOptimizedWrapperBody(clazz, field, get, fieldIndex);
    }

    private class FieldAccessExprEditor
    extends ExprEditor {
        CtClass clazz;
        CtField field;
        boolean doGet;
        boolean doSet;
        int fieldIndex;

        public FieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            this.clazz = clazz;
            this.field = field;
            this.doGet = doGet;
            this.doSet = doSet;
            this.fieldIndex = index;
        }

        public void edit(FieldAccess fieldAccess) throws CannotCompileException {
            if (!fieldAccess.getClassName().equals(this.clazz.getName())) {
                return;
            }
            if (!fieldAccess.getFieldName().equals(this.field.getName())) {
                return;
            }
            if (fieldAccess.isReader() && this.doGet) {
                this.replaceRead(fieldAccess);
            }
            if (fieldAccess.isWriter() && this.doSet) {
                this.replaceWrite(fieldAccess);
            }
        }

        private void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            if (FieldAccessTransformer.this.optimize) {
                this.replaceReadOptimized(fieldAccess);
            } else {
                this.replaceReadNotOptimized(fieldAccess);
            }
        }

        private void replaceReadOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.this.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.this.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        private void replaceReadNotOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            String code = null;
            try {
                if (fieldAccess.isStatic()) {
                    code = "    if (aop$classAdvisor$aop.doesHaveAspects)     {        Object obj = null;       $_ = ($r)aop$classAdvisor$aop.invokeRead(obj, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = " + this.clazz.getName() + "." + this.field.getName() + "; " + "    } " + "";
                    fieldAccess.replace(code);
                } else {
                    code = "    if (aop$classAdvisor$aop.doesHaveAspects || ($0._instanceAdvisor != null && $0._instanceAdvisor.hasInstanceAspects))     {        $_ = ($r)aop$classAdvisor$aop.invokeRead($0, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = $0." + fieldAccess.getFieldName() + "; " + "    } ";
                    fieldAccess.replace(code);
                }
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("failed with: " + code, e);
            }
        }

        private void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            if (FieldAccessTransformer.this.optimize) {
                this.replaceWriteOptimized(fieldAccess);
            } else {
                this.replaceWriteNotOptimized(fieldAccess);
            }
        }

        private void replaceWriteOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            String fieldWrite = FieldAccessTransformer.this.fieldWrite(this.field.getName());
            if (fieldAccess.isStatic()) {
                String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        private void replaceWriteNotOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects)     {        Object obj = null;      aop$classAdvisor$aop.invokeWrite(obj, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       " + this.clazz.getName() + "." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            } else {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects || ($0._instanceAdvisor != null && $0._instanceAdvisor.hasInstanceAspects))     {        aop$classAdvisor$aop.invokeWrite($0, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       $0." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            }
        }
    }

    class NotOptimizedTransformer {
        NotOptimizedTransformer() {
        }

        public void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
            List fields = Instrumentor.getAdvisableFields(clazz);
            ClassPool classPool = FieldAccessTransformer.this.instrumentor.getClassPool();
            JoinpointClassification[] classificationGet = FieldAccessTransformer.this.classifyFieldGet(clazz, advisor);
            JoinpointClassification[] classificationSet = FieldAccessTransformer.this.classifyFieldSet(clazz, advisor);
            int fieldIndex = FieldAccessTransformer.this.fieldOffset(clazz.getSuperclass());
            CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
            Iterator it = fields.iterator();
            boolean skipFieldInterception = true;
            int index = 0;
            while (it.hasNext()) {
                boolean preparedSet;
                CtField field = (CtField)it.next();
                boolean preparedGet = classificationGet[index] != JoinpointClassification.NOT_INSTRUMENTED;
                boolean bl = preparedSet = classificationSet[index] != JoinpointClassification.NOT_INSTRUMENTED;
                if (preparedGet || preparedSet) {
                    FieldAccessTransformer.this.instrumentor.setupBasics(clazz);
                    boolean wrappedGet = classificationGet[index].equals(JoinpointClassification.WRAPPED);
                    boolean wrappedSet = classificationSet[index].equals(JoinpointClassification.WRAPPED);
                    int mod = FieldAccessTransformer.this.getModifiers(field);
                    FieldAccessTransformer.this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
                    if (!Modifier.isPrivate((int)field.getModifiers())) {
                        skipFieldInterception = false;
                        if (preparedGet) {
                            wrapper.prepareForWrapping((CtMember)field, 0);
                        }
                        if (preparedSet) {
                            wrapper.prepareForWrapping((CtMember)field, 1);
                        }
                        if (wrappedGet) {
                            wrapper.wrap((CtMember)field, 0);
                            if (classificationGet[index].equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                                FieldAccessTransformer.this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
                            }
                        }
                        if (wrappedSet) {
                            wrapper.wrap((CtMember)field, 1);
                            if (classificationSet[index].equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                                FieldAccessTransformer.this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
                            }
                        }
                        FieldAccessTransformer.this.buildWrapperPlaceHolders(clazz, field, preparedGet, preparedSet, mod);
                        this.buildNotOptimizedWrappers(clazz, field, preparedGet, preparedSet, fieldIndex);
                    }
                }
                ++index;
                ++fieldIndex;
            }
            if (skipFieldInterception) {
                advisor.getManager().skipFieldAccess(clazz.getName());
            } else {
                advisor.getManager().addFieldInterceptionMarker(clazz.getName());
            }
        }

        public void buildNotOptimizedWrappers(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
            CtMethod method;
            String code;
            if (doGet) {
                code = this.getNotOptimizedWrapperBody(clazz, field, true, index);
                method = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldRead(field.getName()));
                method.setBody(code);
            }
            if (doSet) {
                code = this.getNotOptimizedWrapperBody(clazz, field, false, index);
                method = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldWrite(field.getName()));
                method.setBody(code);
            }
        }

        public String getNotOptimizedWrapperBody(CtClass clazz, CtField field, boolean get, int fieldIndex) throws NotFoundException, CannotCompileException {
            String name = field.getName();
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            String access = "";
            String instanceCheck = "";
            if (!isStatic) {
                access = "((" + clazz.getName() + ")$1).";
                instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
            }
            if (get) {
                return "{     if (aop$classAdvisor$aop.doesHaveAspects " + instanceCheck + " ) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeRead($1, (int)" + fieldIndex + "); " + "    } " + "    return " + access + name + "; " + "}";
            }
            return "{     if (aop$classAdvisor$aop.doesHaveAspects " + instanceCheck + " ) " + "    { " + "       " + "aop$classAdvisor$aop" + ".invokeWrite($1, (int)" + fieldIndex + ", ($w)$2); " + "    } " + "    else " + "    { " + "       " + access + name + " = $2; " + "    } " + "}";
        }
    }

    class OptimizedTransformer {
        OptimizedTransformer() {
        }

        void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
            List fields = Instrumentor.getAdvisableFields(clazz);
            int fieldIndex = FieldAccessTransformer.this.fieldOffset(clazz.getSuperclass());
            JoinpointClassification[] classificationGet = FieldAccessTransformer.this.classifyFieldGet(clazz, advisor);
            JoinpointClassification[] classificationSet = FieldAccessTransformer.this.classifyFieldSet(clazz, advisor);
            Iterator it = fields.iterator();
            boolean skipFieldInterception = true;
            int index = 0;
            while (it.hasNext()) {
                boolean preparedSet;
                CtField field = (CtField)it.next();
                boolean preparedGet = classificationGet[index] != JoinpointClassification.NOT_INSTRUMENTED;
                boolean bl = preparedSet = classificationSet[index] != JoinpointClassification.NOT_INSTRUMENTED;
                if (preparedGet || preparedSet) {
                    if (!Modifier.isPrivate((int)field.getModifiers())) {
                        skipFieldInterception = false;
                    }
                    FieldAccessTransformer.this.instrumentor.setupBasics(clazz);
                    boolean wrappedGet = classificationGet[index].equals(JoinpointClassification.WRAPPED);
                    boolean wrappedSet = classificationSet[index].equals(JoinpointClassification.WRAPPED);
                    int mod = FieldAccessTransformer.this.getModifiers(field);
                    FieldAccessTransformer.this.buildWrapperPlaceHolders(clazz, field, preparedGet, preparedSet, mod);
                    try {
                        if (preparedGet) {
                            this.createOptimizedInvocationClass(clazz, field, true);
                            wrapper.prepareForWrapping((CtMember)field, 0);
                        }
                        if (preparedSet) {
                            this.createOptimizedInvocationClass(clazz, field, false);
                            wrapper.prepareForWrapping((CtMember)field, 1);
                        }
                    }
                    catch (Exception e) {
                        throw new CannotCompileException((Throwable)e);
                    }
                    if (wrappedGet) {
                        wrapper.wrap((CtMember)field, 0);
                        if (classificationGet[index].equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                            FieldAccessTransformer.this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
                        }
                    }
                    if (wrappedSet) {
                        wrapper.wrap((CtMember)field, 1);
                        if (classificationSet[index].equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                            FieldAccessTransformer.this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
                        }
                    }
                    FieldAccessTransformer.this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
                    this.buildOptimizedWrappers(clazz, field, wrappedGet, wrappedSet, fieldIndex);
                }
                ++index;
                ++fieldIndex;
            }
            if (skipFieldInterception) {
                advisor.getManager().skipFieldAccess(clazz.getName());
            } else {
                advisor.getManager().addFieldInterceptionMarker(clazz.getName());
            }
        }

        private String getOptimizedInvocationClassName(CtClass clazz, CtField field, boolean get) throws Exception {
            StringBuffer sb = new StringBuffer(clazz.getName());
            sb.append(".").append(field.getName());
            if (get) {
                sb.append("_Get");
            } else {
                sb.append("_Set");
            }
            return sb.toString();
        }

        private String getOptimizedWrapperBody(CtClass clazz, CtField field, boolean get, int index) throws NotFoundException, CannotCompileException {
            if (get) {
                return this.getOptimizedReadWrapperBody(clazz, field, index);
            }
            return this.getOptimizedWriteWrapperBody(clazz, field, index);
        }

        private String getOptimizedReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
            String optimizedInvocation;
            String wrappedName = field.getName();
            try {
                optimizedInvocation = this.getOptimizedInvocationClassName(clazz, field, true);
                optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf(46) + 1);
                optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CannotCompileException((Throwable)e);
            }
            String name = field.getName();
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            String code = !isStatic ? "{     org.jboss.aop.ClassInstanceAdvisor instAdv = ((" + clazz.getName() + ")$1)._instanceAdvisor;" + "    org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldReadInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects))" + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return ((" + clazz.getName() + ")$1)." + wrappedName + ";" + "    }" + "}" : "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldReadInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "    " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return " + clazz.getName() + "." + wrappedName + ";" + "    }" + "}";
            return code;
        }

        private String getOptimizedWriteWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
            String optimizedInvocation;
            String wrappedName = field.getName();
            try {
                optimizedInvocation = this.getOptimizedInvocationClassName(clazz, field, false);
                optimizedInvocation = optimizedInvocation.substring(optimizedInvocation.lastIndexOf(46) + 1);
                optimizedInvocation = clazz.getName() + "$" + optimizedInvocation;
            }
            catch (Exception e) {
                throw new CannotCompileException((Throwable)e);
            }
            String name = field.getName();
            CtClass ftype = field.getType();
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            String code = !isStatic ? "{     org.jboss.aop.ClassInstanceAdvisor instAdv = ((" + clazz.getName() + ")$1)._instanceAdvisor;" + "    org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldWriteInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       ((" + clazz.getName() + ")$1)." + wrappedName + "=$2" + ";" + "    }" + "}" : "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldWriteInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + clazz.getName() + "." + wrappedName + "=$2" + ";" + "    }" + "}";
            return code;
        }

        public void buildOptimizedWrappers(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
            CtMethod method;
            String code;
            if (doGet) {
                code = this.getOptimizedReadWrapperBody(clazz, field, index);
                method = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldRead(field.getName()));
                method.setBody(code);
                this.setOptimizedInvocationInvokeCode(clazz, field, true);
            }
            if (doSet) {
                code = this.getOptimizedWriteWrapperBody(clazz, field, index);
                method = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldWrite(field.getName()));
                method.setBody(code);
                this.setOptimizedInvocationInvokeCode(clazz, field, false);
            }
        }

        private void setOptimizedInvocationInvokeCode(CtClass clazz, CtField field, boolean get) throws CannotCompileException, NotFoundException {
            String ref;
            String invocationName = null;
            try {
                invocationName = this.getOptimizedInvocationClassName(clazz, field, get);
            }
            catch (Exception e) {
                throw new CannotCompileException((Throwable)e);
            }
            invocationName = invocationName.substring(invocationName.lastIndexOf(46) + 1);
            invocationName = clazz.getName() + "$" + invocationName;
            CtClass invocation = FieldAccessTransformer.this.instrumentor.getClassPool().get(invocationName);
            invocation.defrost();
            CtMethod in = invocation.getSuperclass().getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            String string = ref = Modifier.isStatic((int)field.getModifiers()) ? field.getDeclaringClass().getName() + "." : " typedTargetObject.";
            if (get) {
                code = code + "return ($w) " + ref + field.getName() + ";";
            } else {
                CtClass type = field.getType();
                code = code + ref + field.getName() + " = " + this.castInvocationValueToTypeString(type) + " return null;";
            }
            code = code + "}";
            invokeNext.setBody(code);
            invocation.addMethod(invokeNext);
        }

        private String createOptimizedInvocationClass(CtClass clazz, CtField field, boolean get) throws Exception {
            String wrappedName = field.getName();
            AOPClassPool pool = (AOPClassPool)FieldAccessTransformer.this.instrumentor.getClassPool();
            CtClass fieldInvocation = get ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
            String className = this.getOptimizedInvocationClassName(clazz, field, get);
            boolean makeInnerClass = true;
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, clazz, className, fieldInvocation);
            invocation.stopPruning(true);
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            if (!isStatic) {
                CtField target = new CtField(field.getDeclaringClass(), "typedTargetObject", invocation);
                target.setModifiers(1);
                invocation.addField(target);
            }
            this.addCopy(pool, invocation, isStatic, get);
            TransformerCommon.compileOrLoadClass(field.getDeclaringClass(), invocation);
            return invocation.getName();
        }

        private String castInvocationValueToTypeString(CtClass type) {
            String cast = null;
            if (type.isPrimitive()) {
                if (type.equals(CtClass.booleanType)) {
                    cast = "((Boolean)value).booleanValue();";
                } else if (type.equals(CtClass.byteType)) {
                    cast = "((Byte)value).byteValue();";
                } else if (type.equals(CtClass.charType)) {
                    cast = "((Character)value).charValue();";
                } else if (type.equals(CtClass.doubleType)) {
                    cast = "((Double)value).doubleValue();";
                } else if (type.equals(CtClass.floatType)) {
                    cast = "((Float)value).floatValue();";
                } else if (type.equals(CtClass.intType)) {
                    cast = "((Integer)value).intValue();";
                } else if (type.equals(CtClass.longType)) {
                    cast = "((Long)value).longValue();";
                } else if (type.equals(CtClass.shortType)) {
                    cast = "((Short)value).shortValue();";
                }
            } else {
                cast = type.isArray() ? "(" + type.getName() + ")value;" : "(" + type.getName() + ")value;";
            }
            return cast;
        }

        private void addCopy(ClassPool pool, CtClass invocation, boolean isStatic, boolean isGet) throws Exception {
            CtClass fieldInvocation = isGet ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
            CtMethod template = fieldInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(template.getModifiers());
            String newExpr = isGet ? invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.interceptors); " : invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.value, this.interceptors); ";
            String code = "{    " + newExpr + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; ";
            if (!isStatic) {
                code = code + "   wrapper.typedTargetObject = this.typedTargetObject; ";
                code = code + "   wrapper.targetObject = this.targetObject; ";
            }
            code = code + "   return wrapper; }";
            copy.setBody(code);
            invocation.addMethod(copy);
        }
    }
}

