/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.properties;

import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.LinkedProperties;
import de.java2html.util.RGB;
import java.util.Properties;

public class ConversionOptionsPropertiesWriter {
    public Properties write(JavaSourceConversionOptions options) {
        LinkedProperties properties = new LinkedProperties();
        properties.setProperty("defaultStyleName", options.getStyleTable().getName());
        properties.setProperty("showFileName", String.valueOf(options.isShowFileName()));
        properties.setProperty("showTableBorder", String.valueOf(options.isShowTableBorder()));
        properties.setProperty("showLineNumbers", String.valueOf(options.isShowLineNumbers()));
        properties.setProperty("showJava2HtmlLink", String.valueOf(options.isShowJava2HtmlLink()));
        properties.setProperty("horizontalAlignment", options.getHorizontalAlignment().getName());
        properties.setProperty("TAB_SIZE", String.valueOf(options.getTabSize()));
        this.addStyleEntries(properties, options.getStyleTable());
        return properties;
    }

    private void addStyleEntries(Properties properties, JavaSourceStyleTable table) {
        JavaSourceType[] sourceTypes = JavaSourceType.getAll();
        for (int i = 0; i < sourceTypes.length; ++i) {
            JavaSourceType type = sourceTypes[i];
            JavaSourceStyleEntry entry = table.get(type);
            properties.setProperty(type.getName() + "_COLOR", this.getRgbString(entry.getColor()));
            properties.setProperty(type.getName() + "_BOLD", String.valueOf(entry.isBold()));
            properties.setProperty(type.getName() + "_ITALIC", String.valueOf(entry.isItalic()));
        }
    }

    private String getRgbString(RGB color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }
}

