/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource.test;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceType;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public abstract class JavaSourceParserTestCase
extends TestCase {
    private static Map map = new HashMap();

    protected static JavaSource doParse(String text) throws IOException {
        StringReader stringReader = new StringReader(text);
        JavaSourceParser parser = new JavaSourceParser();
        return parser.parse(stringReader);
    }

    protected void assertParsedTypesEquals(String sourceCode, String typeCode) throws IOException {
        JavaSourceParserTestCase.assertNotNull((String)"SourceCode null - testcase broken", (Object)sourceCode);
        JavaSourceParserTestCase.assertNotNull((String)"TypeCode null - testcase broken", (Object)typeCode);
        JavaSource source = JavaSourceParserTestCase.doParse(sourceCode);
        JavaSourceParserTestCase.assertTrue((String)"Error in TestCase: more types specified than resulted", (source.getClassification().length >= typeCode.length() ? 1 : 0) != 0);
        for (int i = 0; i < typeCode.length(); ++i) {
            if (typeCode.charAt(i) == ' ') continue;
            JavaSourceType expectedType = this.getSourceTypeForTypeCode(typeCode.charAt(i));
            if (expectedType == null) {
                throw new IllegalArgumentException("Unknown type mapping charcter for testing: '" + typeCode.charAt(i) + "'");
            }
            JavaSourceParserTestCase.assertEquals((String)("At character " + i + " (" + sourceCode.substring(i) + "):"), (Object)expectedType, (Object)source.getClassification()[i]);
        }
    }

    private JavaSourceType getSourceTypeForTypeCode(char character) {
        return (JavaSourceType)map.get(String.valueOf(character));
    }

    static {
        map.put("A", JavaSourceType.ANNOTATION);
        map.put("_", JavaSourceType.BACKGROUND);
        map.put(":", JavaSourceType.LINE_NUMBERS);
        map.put("#", JavaSourceType.COMMENT_BLOCK);
        map.put("/", JavaSourceType.COMMENT_LINE);
        map.put("K", JavaSourceType.KEYWORD);
        map.put("S", JavaSourceType.STRING);
        map.put("'", JavaSourceType.CHAR_CONSTANT);
        map.put("1", JavaSourceType.NUM_CONSTANT);
        map.put("{", JavaSourceType.PARENTHESIS);
        map.put("T", JavaSourceType.CODE_TYPE);
        map.put("C", JavaSourceType.CODE);
        map.put("@", JavaSourceType.JAVADOC_KEYWORD);
        map.put("<", JavaSourceType.JAVADOC_HTML_TAG);
        map.put("L", JavaSourceType.JAVADOC_LINKS);
        map.put("*", JavaSourceType.JAVADOC);
        map.put("-", JavaSourceType.UNDEFINED);
    }
}

