/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceType;

public class JavaSourceRun {
    private final JavaSource javaSource;
    private final int startIndex;
    private final int endIndex;

    public JavaSourceRun(JavaSource javaSource, int startIndex, int endIndex) {
        this.javaSource = javaSource;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean isAtEndOfLine() {
        return this.endIndex == this.javaSource.getCode().length() || this.javaSource.getCode().charAt(this.endIndex) == '\r';
    }

    public boolean isAtStartOfLine() {
        return this.startIndex == 0 || this.javaSource.getCode().charAt(this.startIndex - 1) == '\n';
    }

    public JavaSource getJavaSource() {
        return this.javaSource;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public JavaSourceType getType() {
        return this.javaSource.getClassification()[this.startIndex];
    }

    public String getCode() {
        return this.javaSource.getCode().substring(this.startIndex, this.endIndex);
    }

    public void dump() {
        System.out.print(this.isAtStartOfLine() ? "[" : "(");
        System.out.print(this.startIndex + ".." + this.endIndex);
        System.out.print(this.isAtEndOfLine() ? "]" : ")");
        System.out.println(" '" + this.getCode() + "'");
    }
}

