/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import de.java2html.JavaSourceConversionSettings;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.gui.Java2HtmlOptionsPanel;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.util.Ensure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class FileConversionPanel
implements ActionListener {
    private final DefaultListModel fileListModel = new DefaultListModel();
    private final JList list;
    private final JButton bAdd;
    private final JButton bRemove;
    private final JButton bConvert;
    private final JButton bClear;
    private File currentDirectory;
    private final JComponent content;
    private final Java2HtmlOptionsPanel optionsPanel;

    public FileConversionPanel(Java2HtmlOptionsPanel optionsPanel) {
        Ensure.ensureArgumentNotNull(optionsPanel);
        this.optionsPanel = optionsPanel;
        this.list = new JList(this.fileListModel);
        this.bAdd = new JButton("Add...");
        this.bAdd.addActionListener(this);
        this.bRemove = new JButton("Remove");
        this.bRemove.addActionListener(this);
        this.bRemove.setEnabled(false);
        this.bClear = new JButton("Clear");
        this.bClear.addActionListener(this);
        this.bClear.setEnabled(false);
        this.bConvert = new JButton("Convert");
        this.bConvert.addActionListener(this);
        this.bConvert.setEnabled(false);
        JPanel fileButtonPanel = new JPanel(new GridLayout(0, 1, 6, 6));
        fileButtonPanel.add(this.bAdd);
        fileButtonPanel.add(this.bRemove);
        fileButtonPanel.add(this.bClear);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)fileButtonPanel, "North");
        JPanel filesToConvertPanel = new JPanel(new BorderLayout(4, 4));
        filesToConvertPanel.add((Component)new JLabel("Files to convert:"), "North");
        filesToConvertPanel.add((Component)new JScrollPane(this.list), "Center");
        filesToConvertPanel.add((Component)buttonPanel, "East");
        JPanel southPanel = new JPanel(new FlowLayout(0));
        southPanel.add(this.bConvert);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(5, 6, 5, 6));
        panel.add((Component)filesToConvertPanel, "Center");
        panel.add((Component)southPanel, "South");
        this.content = panel;
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FileConversionPanel.this.updateButtonsEnabled();
            }
        });
        this.fileListModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                FileConversionPanel.this.updateButtonsEnabled();
            }

            public void intervalRemoved(ListDataEvent e) {
                FileConversionPanel.this.updateButtonsEnabled();
            }

            public void intervalAdded(ListDataEvent e) {
                FileConversionPanel.this.updateButtonsEnabled();
            }
        });
        this.updateButtonsEnabled();
    }

    private void updateButtonsEnabled() {
        this.bRemove.setEnabled(!this.list.isSelectionEmpty());
        this.bClear.setEnabled(!this.fileListModel.isEmpty());
        this.bConvert.setEnabled(!this.fileListModel.isEmpty());
    }

    private void add() {
        JFileChooser chooser = new JFileChooser(this.currentDirectory);
        chooser.setDialogTitle("Open Java Source");
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "*.java";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".java");
            }
        });
        int result = chooser.showOpenDialog(this.content);
        if (result != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        this.currentDirectory = selectedFile.getParentFile();
        this.fileListModel.addElement(selectedFile);
    }

    private void remove() {
        Object[] files = this.list.getSelectedValues();
        for (int i = 0; i < files.length; ++i) {
            this.fileListModel.removeElement(files[i]);
        }
    }

    private void clear() {
        this.fileListModel.clear();
    }

    private void convert() {
        JavaSourceConversionSettings settings = this.optionsPanel.getConversionSettings();
        settings.getConversionOptions().setShowJava2HtmlLink(true);
        StringBuffer report = new StringBuffer();
        StringWriter writer = new StringWriter();
        IJavaSourceConverter converter = settings.createConverter();
        Object[] files = this.fileListModel.toArray();
        try {
            converter.writeDocumentHeader(writer, settings.getConversionOptions(), "");
            for (int count = 0; count < files.length; ++count) {
                File file = (File)files[count];
                report.append("<li>File " + (count + 1) + ": " + file.getName() + "<blockquote>");
                try {
                    if (count > 0) {
                        converter.writeBlockSeparator(writer, settings.getConversionOptions());
                    }
                    JavaSourceParser parser = new JavaSourceParser(settings.getConversionOptions());
                    JavaSource source = parser.parse(file);
                    converter.convert(source, settings.getConversionOptions(), writer);
                    writer.write(10);
                    report.append(source.getStatistic().getScreenString("<br>") + "</blockquote></li>");
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Error converting " + file + ": " + e);
                }
            }
            converter.writeDocumentFooter(writer, settings.getConversionOptions());
        }
        catch (IOException e) {
            System.err.println("Error converting files " + e);
        }
        StringSelection sel = new StringSelection(writer.getBuffer().toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(sel, sel);
        String plural = "";
        if (files.length > 1) {
            plural = "s";
        }
        String title = "File" + plural + " converted";
        String text = "<html><b>" + files.length + " File" + plural + " successfully converted.</b>" + "<ul>" + report.toString() + "</ul>" + "<b>The converted source code has been copied the system clipboard</b>" + "</html>";
        JOptionPane.showMessageDialog(this.content, text, title, 1);
    }

    public JComponent getContent() {
        return this.content;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.bAdd) {
            this.add();
        } else if (source == this.bRemove) {
            this.remove();
        } else if (source == this.bClear) {
            this.clear();
        } else {
            this.convert();
        }
    }
}

