/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline.test;

import de.java2html.commandline.CommandlineArguments;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.test.BasicTestCase;

public class CommandlineArgumentsTest
extends BasicTestCase {
    static /* synthetic */ Class class$de$java2html$commandline$IllegalCommandlineParametersException;

    public void testIsFlagSet() throws IllegalCommandlineParametersException {
        CommandlineArguments emptyArguments = new CommandlineArguments(new String[0]);
        CommandlineArgumentsTest.assertFalse((boolean)emptyArguments.isFlagSet("flag"));
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-parameter", "value", "-flag"});
        CommandlineArgumentsTest.assertTrue((boolean)arguments.isFlagSet("flag"));
        CommandlineArgumentsTest.assertTrue((boolean)arguments.isFlagSet("FLAG"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isFlagSet("-flag"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isFlagSet("value"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isFlagSet("parameter"));
    }

    public void testIsParameterSet() throws IllegalCommandlineParametersException {
        CommandlineArguments emptyArguments = new CommandlineArguments(new String[0]);
        CommandlineArgumentsTest.assertFalse((boolean)emptyArguments.isParameterSet("flag"));
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-parameter", "value", "-flag"});
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isParameterSet("flag"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isParameterSet("FLAG"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isParameterSet("-flag"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isParameterSet("value"));
        CommandlineArgumentsTest.assertTrue((boolean)arguments.isParameterSet("parameter"));
        CommandlineArgumentsTest.assertTrue((boolean)arguments.isParameterSet("pArAmEtEr"));
    }

    public void testNumbersAreNotFlags() throws IllegalCommandlineParametersException {
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-flag", "-10"});
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isFlagSet("10"));
        CommandlineArgumentsTest.assertFalse((boolean)arguments.isFlagSet("flag"));
        CommandlineArgumentsTest.assertTrue((boolean)arguments.isParameterSet("flag"));
    }

    public void testDuplicateFlagDefinitionThrowsException() {
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag1"});
            }
        });
    }

    public void testDuplicateParameterDefinitionThrowsException() {
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag1", "value1"});
            }
        });
    }

    public void testDuplicateMixedDefinitionThrowsException() {
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag1", "value"});
            }
        });
    }

    public void testGetArgumentStringValue() throws IllegalCommandlineParametersException {
        CommandlineArgumentsTest.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getParameterStringValue("flag1"));
        CommandlineArgumentsTest.assertEquals(null, (String)new CommandlineArguments(new String[]{"-flag1", "-flag2"}).getParameterStringValue("flag1"));
    }

    public void testGetRequiredArgumentStringValue() throws IllegalCommandlineParametersException {
        CommandlineArgumentsTest.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getRequiredParameterStringValue("flag1"));
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1"}).getRequiredParameterStringValue("flag1");
            }
        });
    }

    public void testGetArgumentStringValueWithDefault() throws IllegalCommandlineParametersException {
        CommandlineArgumentsTest.assertEquals((String)"default", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getParameterStringValue("undefinedFlag", "default"));
        CommandlineArgumentsTest.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-definedflag", "value"}).getParameterStringValue("definedflag", "default"));
    }

    public void testGetArgumentIntValueWithDefault() throws IllegalCommandlineParametersException {
        CommandlineArgumentsTest.assertEquals((int)42, (int)new CommandlineArguments(new String[]{"-flag1", "42"}).getParameterPositiveIntValue("flag1", 1));
        CommandlineArgumentsTest.assertEquals((int)1, (int)new CommandlineArguments(new String[0]).getParameterPositiveIntValue("flag1", 1));
    }

    public void testGetArgumentIntValueWithIllegalValue() {
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "abc"}).getParameterPositiveIntValue("flag1", 1);
            }
        });
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-10"}).getParameterPositiveIntValue("flag1", 1);
            }
        });
    }

    public void testUnsupportedParameterThrowsException() throws IllegalCommandlineParametersException {
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"flag1"});
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"FLag1"});
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2", "value2"}).assertContainsNoUnsupportedParameters(new String[]{"flag1"});
            }
        });
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"flag2"});
            }
        });
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag", "value"}).assertContainsNoUnsupportedParameters(new String[0]);
            }
        });
    }

    public void testUnsupportedFlagThrowsException() throws IllegalCommandlineParametersException {
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag1", "flag2"});
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"FLag1", "FLag2"});
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag1"});
            }
        });
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag2"});
            }
        });
        CommandlineArgumentsTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = CommandlineArgumentsTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag"}).assertContainsNoUnsupportedFlags(new String[0]);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

