/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.anttasks;

import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.ConversionOptionsUtilities;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Java2HtmlTask
extends MatchingTask {
    private String style = JavaSourceConversionOptions.getDefault().getStyleTable().getName();
    private File srcDir;
    private File destDir;
    private boolean overwrite = false;
    private String outputFormat = JavaSourceConverterProvider.getDefaultConverterName();
    private int tabs = JavaSourceConversionOptions.getDefault().getTabSize();
    private boolean showLineNumbers = JavaSourceConversionOptions.getDefault().isShowLineNumbers();
    private boolean showDefaultTitle = false;
    private boolean addLineAnchors = false;
    private String lineAnchorPrefix = "";
    private boolean showTableBorder = false;
    private boolean showFileName = false;
    private boolean includeDocumentHeader = true;
    private boolean includeDocumentFooter = true;
    private boolean useShortFileName = false;
    private String horizontalAlignment = JavaSourceConversionOptions.getDefault().getHorizontalAlignment().getName();
    private String charset = "iso-8859-1";

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void execute() throws BuildException {
        String[] sourceFilesToProcess;
        if (this.srcDir == null) {
            this.srcDir = this.project.resolveFile(".");
        }
        DirectoryScanner dirScanner = this.getDirectoryScanner(this.srcDir);
        String[] allSourceFiles = dirScanner.getIncludedFiles();
        IJavaSourceConverter converter = this.getConverter();
        JavaSourceConversionOptions options = this.getConversionOptions();
        SourceFileScanner sourceScanner = new SourceFileScanner((Task)this);
        if (this.isOverwrite()) {
            sourceFilesToProcess = allSourceFiles;
        } else {
            GlobPatternMapper sourceToOutMapper = new GlobPatternMapper();
            sourceToOutMapper.setFrom("*");
            sourceToOutMapper.setTo("*." + converter.getMetaData().getDefaultFileExtension());
            sourceFilesToProcess = sourceScanner.restrict(allSourceFiles, this.srcDir, this.destDir, (FileNameMapper)sourceToOutMapper);
        }
        if (sourceFilesToProcess.length > 0) {
            String files = sourceFilesToProcess.length == 1 ? " file" : " files";
            this.log("Converting " + sourceFilesToProcess.length + files, 2);
        }
        for (int i = 0; i < sourceFilesToProcess.length; ++i) {
            this.process(sourceFilesToProcess[i], options, converter);
        }
    }

    private JavaSourceConversionOptions getConversionOptions() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setTabSize(this.tabs);
        options.setShowFileName(this.isShowFileName());
        options.setShowTableBorder(this.isShowTableBorder());
        options.setShowLineNumbers(this.isShowLineNumbers());
        options.setAddLineAnchors(this.isAddLineAnchors());
        options.setLineAnchorPrefix(this.lineAnchorPrefix);
        options.setCharset(this.charset);
        JavaSourceStyleTable table = JavaSourceStyleTable.getPredefinedTable(this.style);
        if (table == null) {
            throw new BuildException("Specified style table '" + this.style + "' does not exist " + " - valid values are: " + ConversionOptionsUtilities.getPredefinedStyleTableNameString());
        }
        options.setStyleTable(table);
        HorizontalAlignment alignment = HorizontalAlignment.getByName(this.horizontalAlignment);
        if (alignment == null) {
            throw new BuildException("Specified alignment '" + this.horizontalAlignment + "'does not exist - valid values are: " + ConversionOptionsUtilities.getAvailableHorizontalAlignmentNames());
        }
        options.setHorizontalAlignment(alignment);
        return options;
    }

    private IJavaSourceConverter getConverter() throws BuildException {
        IJavaSourceConverter converter = JavaSourceConverterProvider.getJavaSourceConverterByName(this.outputFormat);
        if (converter == null) {
            throw new BuildException("unknown output file format: " + this.outputFormat);
        }
        return converter;
    }

    private void process(String sourcefileName, JavaSourceConversionOptions options, IJavaSourceConverter converter) throws BuildException {
        JavaSource source;
        this.log("Converting '" + sourcefileName + "'", 3);
        JavaSourceParser parser = new JavaSourceParser(options);
        File inFile = new File(this.srcDir, sourcefileName);
        try {
            source = parser.parse(inFile);
        }
        catch (IOException e1) {
            throw new BuildException("Unable to parse file " + inFile.getName(), (Throwable)e1);
        }
        File outFile = this.createOutputFile(sourcefileName, converter);
        this.ensureDirectoryFor(outFile);
        FileWriter writer = null;
        try {
            writer = new FileWriter(outFile);
        }
        catch (Exception e) {
            throw new BuildException("Error opening output file " + outFile.getName(), (Throwable)e);
        }
        String title = "";
        if (this.isShowDefaultTitle()) {
            title = sourcefileName.replace('\\', '/');
        }
        try {
            if (this.isIncludeDocumentHeader()) {
                converter.writeDocumentHeader(writer, options, title);
            }
            converter.convert(source, options, writer);
            if (this.isIncludeDocumentFooter()) {
                converter.writeDocumentFooter(writer, options);
            }
        }
        catch (Exception e) {
            throw new BuildException("Error writing output to " + outFile.getName(), (Throwable)e);
        }
        finally {
            IoUtilities.close(writer);
        }
        this.log("Output: " + outFile, 3);
    }

    private File createOutputFile(String sourcefileName, IJavaSourceConverter converter) {
        int index;
        String fileNamePrefix = sourcefileName;
        if (this.isUseShortFileName() && (index = sourcefileName.lastIndexOf(46)) != -1) {
            fileNamePrefix = sourcefileName.substring(0, index);
        }
        return new File(this.destDir, fileNamePrefix + "." + converter.getMetaData().getDefaultFileExtension());
    }

    public void setTabs(int tabs) {
        this.tabs = tabs;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private boolean isShowFileName() {
        return this.showFileName;
    }

    private boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    private boolean isShowDefaultTitle() {
        return this.showDefaultTitle;
    }

    private boolean isShowTableBorder() {
        return this.showTableBorder;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    public void setShowDefaultTitle(boolean showDefaultTitle) {
        this.showDefaultTitle = showDefaultTitle;
    }

    public void setShowTableBorder(boolean showTableBorder) {
        this.showTableBorder = showTableBorder;
    }

    private boolean isIncludeDocumentFooter() {
        return this.includeDocumentFooter;
    }

    private boolean isIncludeDocumentHeader() {
        return this.includeDocumentHeader;
    }

    public void setIncludeDocumentFooter(boolean includeDocumentFooter) {
        this.includeDocumentFooter = includeDocumentFooter;
    }

    public void setIncludeDocumentHeader(boolean includeDocumentHeader) {
        this.includeDocumentHeader = includeDocumentHeader;
    }

    private boolean isAddLineAnchors() {
        return this.addLineAnchors;
    }

    public void setAddLineAnchors(boolean addLineAnchors) {
        this.addLineAnchors = addLineAnchors;
    }

    public void setLineAnchorPrefix(String string) {
        this.lineAnchorPrefix = string;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    private boolean isUseShortFileName() {
        return this.useShortFileName;
    }

    public void setUseShortFileName(boolean useShortFileName) {
        this.useShortFileName = useShortFileName;
    }

    private boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

