/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.RGB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class JavaSourceCanvas
extends JComponent {
    protected JavaSource source;
    protected int scale = 1;
    private JavaSourceStyleTable colorTable = JavaSourceStyleTable.getDefault();

    public JavaSourceCanvas(JavaSource source) {
        this.source = source;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.scale * this.source.getMaxLineLength(), this.scale * this.source.getLineCount());
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        Dimension d = this.getPreferredSize();
        g.fillRect(0, 0, d.width, d.height);
        int y = 0;
        int index = 0;
        StringTokenizer st = new StringTokenizer(this.source.getCode(), "\n\r", true);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.charAt(0) == '\n' || line.charAt(0) == '\r') {
                ++index;
                ++y;
                continue;
            }
            this.paint(g, y, index, index + line.length() - 1);
            index += line.length();
        }
    }

    protected void paint(Graphics g, int y, int start, int end) {
        int x = 0;
        int index1 = start;
        int index2 = start;
        JavaSourceType[] sourceTypes = this.source.getClassification();
        while (index2 <= end) {
            while (index2 < end && sourceTypes[index2 + 1] == sourceTypes[index1]) {
                ++index2;
            }
            if (sourceTypes[index1] != JavaSourceType.BACKGROUND) {
                g.setColor(this.getAwtColor(this.colorTable.get(sourceTypes[index1]).getColor()));
                if (this.scale == 1) {
                    g.drawLine(x, y, x + index2 - index1, y);
                } else if (this.scale == 2) {
                    g.drawLine(2 * x, 2 * y, 2 * (x + index2 - index1) + 1, 2 * y);
                    g.drawLine(2 * x, 2 * y + 1, 2 * (x + index2 - index1) + 1, 2 * y + 1);
                } else {
                    System.err.println("scale>2 not implemented yet!");
                }
            }
            x += index2 - index1 + 1;
            index2 = index1 = index2 + 1;
        }
    }

    private Color getAwtColor(RGB rgb) {
        return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
    }

    public static void main(String[] args) throws Exception {
        JavaSourceParser parser = new JavaSourceParser();
        JavaSource j = parser.parse(new File("f:\\eclipse\\de\\java2html\\JavaSource2TeXConverter.java"));
        JavaSourceCanvas canny = new JavaSourceCanvas(j);
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setLayout(new BorderLayout());
        f.add((Component)canny, "Center");
        f.pack();
        f.setVisible(true);
    }
}

