/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceContexts;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.dd.PersistenceContextRef;
import org.jboss.ejb3.entity.ExtendedEntityManager;
import org.jboss.ejb3.entity.ExtendedHibernateSession;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedHibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.ExtendedPersistenceContextInjector;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiFieldInjector;
import org.jboss.ejb3.injection.JndiMethodInjector;
import org.jboss.ejb3.injection.PersistenceUnitHandler;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextHandler {
    private static final Logger log = Logger.getLogger(PersistenceContextHandler.class);

    private static void loadXmlDependencies(List<PersistenceContextRef> refs, EJBContainer container) {
        for (PersistenceContextRef ref : refs) {
            container.getPuEncXmlEntries().put("env/" + ref.getRefName(), ref.getUnitName());
            try {
                PersistenceUnitHandler.addPUDependency(ref.getUnitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal <persistence-context-ref> of " + ref.getRefName() + " :" + e.getMessage());
            }
        }
    }

    private static void loadXml(List<PersistenceContextRef> refs, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (PersistenceContextRef ref : refs) {
            String encName = "env/" + ref.getRefName();
            String error = "unable to load <persistence-context-ref> for unitName: " + ref.getUnitName() + " <ref-name>: " + ref.getRefName();
            PersistenceContextType type = ref.getPersistenceContextType();
            String unitName = ref.getUnitName();
            Class<?> injectionType = null;
            if (ref.getInjectionTarget() != null) {
                AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, ref.getInjectionTarget());
                if (ao instanceof Field) {
                    injectionType = ((Field)ao).getType();
                    injectors.put(ao, new JndiFieldInjector((Field)ao, encName, container.getEnc()));
                } else {
                    injectionType = ((Method)ao).getParameterTypes()[0];
                    injectors.put(ao, new JndiMethodInjector((Method)ao, encName, container.getEnc()));
                }
            }
            PersistenceContextHandler.bindPersistenceContext(container, unitName, error, type, encName, injectionType);
        }
    }

    private static void bindPersistenceContext(EJBContainer container, String unitName, String error, PersistenceContextType type, String encName, Class injectionType) {
        ManagedEntityManagerFactory factory = null;
        try {
            factory = PersistenceUnitHandler.getManagedEntityManagerFactory(container, unitName);
        }
        catch (NameNotFoundException e) {
            error = error + " " + e.getMessage();
        }
        if (factory == null) {
            throw new RuntimeException(error);
        }
        if (type == PersistenceContextType.EXTENDED) {
            container.getExtendedPCs().put(factory.getKernelName(), new ExtendedPersistenceContextInjector(container, factory));
            Serializable extendedPc = null;
            extendedPc = injectionType == null || injectionType.getName().equals(EntityManager.class.getName()) ? new ExtendedEntityManager(factory.getKernelName()) : new ExtendedHibernateSession(factory.getKernelName());
            try {
                Util.bind((Context)container.getEnc(), (String)encName, (Object)extendedPc);
            }
            catch (NamingException e) {
                throw new RuntimeException(error, e);
            }
        }
        Externalizable entityManager = null;
        entityManager = injectionType == null || injectionType.getName().equals(EntityManager.class.getName()) ? new InjectedEntityManager(factory) : new InjectedHibernateSession(factory);
        try {
            Util.bind((Context)container.getEnc(), (String)encName, (Object)entityManager);
        }
        catch (NamingException e) {
            throw new RuntimeException(error, e);
        }
    }

    private static void loadPersistenceContextClassAnnotations(EJBContainer container, Class clazz, boolean isContainer) {
        PersistenceContexts resources = (PersistenceContexts)InjectionUtil.getAnnotation(PersistenceContexts.class, container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceContext ref : resources.value()) {
            PersistenceContextHandler.loadPersistenceContextClassAnnotation(ref, container);
        }
        PersistenceContext pc = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, clazz, isContainer);
        if (pc != null) {
            PersistenceContextHandler.loadPersistenceContextClassAnnotation(pc, container);
        }
    }

    private static void loadPersistenceContextClassAnnotation(PersistenceContext ref, EJBContainer container) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @PersistenceContext");
        }
        if (container.getPuEncXmlEntries().containsKey("env/" + encName)) {
            return;
        }
        String error = "Unable to load class-level @PersistenceContext(" + ref.unitName() + ") on " + container.getObjectName();
        PersistenceContextHandler.bindPersistenceContext(container, ref.unitName(), error, ref.type(), ref.name(), null);
    }

    private static void loadClassPUDependencies(EJBContainer container, Class clazz, boolean isContainer) {
        PersistenceContexts resources = (PersistenceContexts)InjectionUtil.getAnnotation(PersistenceContexts.class, container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceContext ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            if (container.getPuEncXmlEntries().containsKey("env/" + encName)) continue;
            try {
                PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Invalid " + clazz.getName() + " annotation @PersistenceContext: " + e.getMessage());
            }
        }
        PersistenceContext pu = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, clazz, isContainer);
        if (pu != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            if (container.getPuEncXmlEntries().containsKey("env/" + encName)) {
                return;
            }
            try {
                PersistenceUnitHandler.addPUDependency(pu.unitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Invalid " + clazz.getName() + " annotation @PersistenceContext: " + e.getMessage());
            }
        }
    }

    public static void loadMethodDependencies(HashSet<String> visitedMethods, EJBContainer container, Class clazz, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String encName;
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            encName = (encName = ref.name()) == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + encName;
            if (container.getPuEncXmlEntries().containsKey(encName)) continue;
            try {
                PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                continue;
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Method " + methods[i].toString() + " @PersistenceContext in error: " + e.getMessage());
            }
        }
        PersistenceContextHandler.loadMethodDependencies(visitedMethods, container, clazz.getSuperclass(), isContainer);
    }

    private static void loadFieldDependencies(Class clazz, EJBContainer container, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceContextHandler.loadFieldDependencies(clazz.getSuperclass(), container, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, fields[i], isContainer);
            if (ref == null) continue;
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(fields[i]) : "env/" + encName;
            if (container.getPuEncXmlEntries().containsKey(encName)) continue;
            try {
                PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                continue;
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Field " + fields[i].toString() + " @PersistenceUnit in error: " + e.getMessage());
            }
        }
    }

    public static void loadInjectors(EJBContainer ejb) throws Exception {
        Class clazz = ejb.getBeanClass();
        if (clazz == null) {
            throw new RuntimeException("CLAZZ CANNOT BE NULL");
        }
        PersistenceContextHandler.loadInjectors(clazz, ejb.getXml(), ejb, ejb.getEncInjections(), true);
    }

    public static void loadInjectors(InterceptorInjector injector) throws Exception {
        PersistenceContextHandler.loadInjectors(injector.getClazz(), injector.getXml(), (EJBContainer)injector.getContainer(), injector.getEncInjections(), false);
    }

    private static void loadInjectors(Class clazz, Injectable xml, EJBContainer container, HashMap<AccessibleObject, Injector> encInjections, boolean isContainer) throws Exception {
        if (xml != null) {
            PersistenceContextHandler.loadXml(xml.getPersistenceContextRefs(), container, clazz, encInjections);
        }
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceContextHandler.loadPersistenceContextClassAnnotations(container, clazz, isContainer);
        PersistenceContextHandler.loadMethodInjectors(visitedMethods, container, clazz, encInjections, isContainer);
        PersistenceContextHandler.loadFieldInjectors(clazz, container, encInjections, isContainer);
    }

    public static void loadDependencies(Injectable xml, EJBContainer container, Class clazz, boolean isContainer) {
        if (xml != null) {
            PersistenceContextHandler.loadXmlDependencies(xml.getPersistenceContextRefs(), container);
        }
        PersistenceContextHandler.loadClassPUDependencies(container, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceContextHandler.loadMethodDependencies(visitedMethods, container, clazz, isContainer);
        PersistenceContextHandler.loadFieldDependencies(clazz, container, isContainer);
    }

    private static void loadMethodInjectors(HashSet<String> visitedMethods, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method of one parameter: " + methods[i]);
            }
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + ref.name();
            String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getObjectName() + " failed to inject on method " + methods[i].toString();
            boolean bindingExists = container.getPuEncXmlEntries().containsKey(encName);
            if (injectors.containsKey(methods[i])) continue;
            if (!bindingExists) {
                PersistenceContextHandler.bindPersistenceContext(container, ref.unitName(), error, ref.type(), encName, methods[i].getParameterTypes()[0]);
            }
            injectors.put(methods[i], new JndiMethodInjector(methods[i], encName, container.getEnc()));
        }
        PersistenceContextHandler.loadMethodInjectors(visitedMethods, container, clazz.getSuperclass(), injectors, isContainer);
    }

    private static void loadFieldInjectors(Class clazz, EJBContainer container, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceContextHandler.loadFieldInjectors(clazz.getSuperclass(), container, injectors, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, fields[i], isContainer);
            if (ref == null) continue;
            fields[i].setAccessible(true);
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(fields[i]) : "env/" + ref.name();
            String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getObjectName() + " failed to inject on field " + fields[i].toString();
            boolean bindingExists = container.getPuEncXmlEntries().containsKey(encName);
            if (injectors.containsKey(fields[i])) continue;
            if (!bindingExists) {
                PersistenceContextHandler.bindPersistenceContext(container, ref.unitName(), error, ref.type(), encName, fields[i].getType());
            }
            injectors.put(fields[i], new JndiFieldInjector(fields[i], encName, container.getEnc()));
        }
    }
}

