/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.util.Ensure;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;

public abstract class AbstractJava2HtmlConversion
implements IJava2HtmlConversion {
    private IJavaSourceConverter converter;
    private final JavaSourceConversionOptions options;

    public AbstractJava2HtmlConversion(IJavaSourceConverter converter, JavaSourceConversionOptions options) {
        Ensure.ensureArgumentNotNull(converter);
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
        this.converter = converter;
    }

    public final JavaSourceConversionOptions getConversionOptions() {
        return this.options;
    }

    public final IJavaSourceConverter getConverter() {
        return this.converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byArray = IoUtilities.readBytes(inputStream);
        }
        catch (Throwable throwable) {
            IoUtilities.close(inputStream);
            throw throwable;
        }
        IoUtilities.close(inputStream);
        return byArray;
    }

    protected String readAndConvert(File sourceFile) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.converter.writeDocumentHeader(stringWriter, this.getConversionOptions(), "");
        JavaSourceParser parser = new JavaSourceParser(this.getConversionOptions());
        JavaSource source = parser.parse(sourceFile);
        try {
            this.converter.convert(source, this.getConversionOptions(), stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.converter.writeDocumentFooter(stringWriter, this.getConversionOptions());
        return stringWriter.toString();
    }

    protected void convertFile(File sourceFile, File targetFile) {
        String text;
        try {
            text = this.readAndConvert(sourceFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return;
        }
        if (targetFile == null) {
            targetFile = IoUtilities.exchangeFileExtension(sourceFile, this.getConverter().getMetaData().getDefaultFileExtension());
        }
        IoUtilities.ensureFoldersExist(targetFile.getParentFile());
        try {
            this.writeFile(targetFile, text.getBytes());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File targetFile, byte[] contents) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            outputStream.write(contents);
        }
        catch (Throwable throwable) {
            IoUtilities.close(outputStream);
            throw throwable;
        }
        IoUtilities.close(outputStream);
    }
}

