/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.jms.JMSException;
import org.jboss.mq.pm.PersistenceManager;

public class Tx
implements Comparable,
Externalizable {
    static final long serialVersionUID = -5428592493990463362L;
    private static final int OPEN = 0;
    private static final int ENDED = 2;
    long value = 0L;
    boolean persisted = false;
    transient ArrayList postCommitTasks;
    transient ArrayList postRollbackTasks;
    transient int status = 0;
    transient Object lock = new Object();

    public Tx() {
    }

    public Tx(long value) {
        this.value = value;
    }

    public void setValue(long tx) {
        this.value = tx;
    }

    public long longValue() {
        return this.value;
    }

    public synchronized boolean checkPersisted() {
        boolean result = this.persisted;
        this.persisted = true;
        return result;
    }

    public synchronized boolean wasPersisted() {
        return this.persisted;
    }

    public int compareTo(Tx anotherLong) {
        long thisVal = this.value;
        long anotherVal = anotherLong.value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public int compareTo(Object o) {
        return this.compareTo((Tx)o);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(PersistenceManager pm) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 2) {
                throw new JMSException("Transaction is not active for commit");
            }
            this.status = 2;
            this.postRollbackTasks = null;
        }
        pm.commitPersistentTx(this);
        object = this.lock;
        synchronized (object) {
            if (this.postCommitTasks == null) {
                return;
            }
            for (int i = 0; i < this.postCommitTasks.size(); ++i) {
                Runnable task = (Runnable)this.postCommitTasks.get(i);
                task.run();
            }
            this.postCommitTasks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPostCommitTask(Runnable task) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 2) {
                throw new JMSException("Transacation is not active.");
            }
            if (this.postCommitTasks == null) {
                this.postCommitTasks = new ArrayList();
            }
            this.postCommitTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(PersistenceManager pm) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 2) {
                throw new JMSException("Transaction is not active for rollback");
            }
            this.status = 2;
            this.postCommitTasks = null;
        }
        pm.rollbackPersistentTx(this);
        object = this.lock;
        synchronized (object) {
            if (this.postRollbackTasks == null) {
                return;
            }
            for (int i = 0; i < this.postRollbackTasks.size(); ++i) {
                Runnable task = (Runnable)this.postRollbackTasks.get(i);
                task.run();
            }
            this.postRollbackTasks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostRollbackTask(Runnable task) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 2) {
                throw new JMSException("Transacation is not active.");
            }
            if (this.postRollbackTasks == null) {
                this.postRollbackTasks = new ArrayList();
            }
            this.postRollbackTasks.add(task);
        }
    }
}

