/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.oil.OILClientIL;

public final class OILClientILService
implements Runnable,
ClientILService {
    private static final Logger cat = Logger.getLogger((Class)OILClientILService.class);
    private OILClientIL clientIL;
    private Thread worker;
    private Socket socket = null;
    private Connection connection;
    private boolean running;
    private ServerSocket serverSocket;
    private static int threadNumber = 0;
    private boolean enableTcpNoDelay = false;

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.serverSocket = new ServerSocket(0);
        String t = props.getProperty("OIL_TCPNODELAY_KEY");
        if (t != null) {
            this.enableTcpNoDelay = t.equals("yes");
        }
        this.clientIL = new OILClientIL(InetAddress.getLocalHost(), this.serverSocket.getLocalPort(), this.enableTcpNoDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block35: {
            code = 0;
            out = null;
            in = null;
            this.socket = null;
            serverPort = this.serverSocket.getLocalPort();
            try {
                block36: {
                    if (OILClientILService.cat.isDebugEnabled()) {
                        OILClientILService.cat.debug((Object)("Waiting for the server to connect to me on port " + this.serverSocket.getLocalPort()));
                    }
                    this.serverSocket.setSoTimeout(1000);
                    while (this.running && this.socket == null) {
                        try {
                            this.socket = this.serverSocket.accept();
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (IOException e) {
                            if (this.running) {
                                this.connection.asynchFailure("Error accepting connection from server in OILClientILService.", e);
                            }
                            var7_14 = null;
                            try {
                                this.serverSocket.close();
                                this.serverSocket = null;
                                return;
                            }
                            catch (IOException e) {
                                if (OILClientILService.cat.isDebugEnabled() == false) return;
                                OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                            }
                            return;
                        }
                    }
                    if (!this.running) break block36;
                    this.socket.setTcpNoDelay(this.enableTcpNoDelay);
                    this.socket.setSoTimeout(0);
                    out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    out.flush();
                    in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    ** GOTO lbl71
                }
                var7_15 = null;
                ** GOTO lbl63
            }
            catch (IOException e) {
                this.connection.asynchFailure("Could not initialize the OILClientIL Service.", e);
                var7_17 = null;
                ** try [egrp 3[TRYBLOCK] [9 : 241->256)] { 
lbl45:
                // 1 sources

                this.serverSocket.close();
                this.serverSocket = null;
                return;
lbl48:
                // 1 sources

                catch (IOException e) {
                    if (OILClientILService.cat.isDebugEnabled() == false) return;
                    OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                }
                return;
            }
            {
                catch (Throwable var6_26) {
                    var7_18 = null;
                    ** try [egrp 3[TRYBLOCK] [9 : 241->256)] { 
lbl56:
                    // 1 sources

                    this.serverSocket.close();
                    this.serverSocket = null;
                    throw var6_26;
lbl59:
                    // 1 sources

                    catch (IOException e) {
                        if (OILClientILService.cat.isDebugEnabled() == false) throw var6_26;
                        OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                    }
                    throw var6_26;
                }
lbl63:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [9 : 241->256)] { 
lbl64:
                // 1 sources

                this.serverSocket.close();
                this.serverSocket = null;
                return;
lbl67:
                // 1 sources

                catch (IOException e) {
                    if (OILClientILService.cat.isDebugEnabled() == false) return;
                    OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                }
                return;
lbl71:
                // 1 sources

                var7_16 = null;
                ** try [egrp 3[TRYBLOCK] [9 : 241->256)] { 
lbl73:
                // 1 sources

                this.serverSocket.close();
                this.serverSocket = null;
lbl76:
                // 1 sources

                catch (IOException e) {}
                if (!OILClientILService.cat.isDebugEnabled()) break block35;
                OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
            }
        }
        while (this.running) {
            try {
                code = in.readByte();
            }
            catch (InterruptedIOException e) {
                continue;
            }
            catch (IOException e) {
                break;
            }
            try {
                switch (code) {
                    case 19: {
                        numReceives = in.readInt();
                        messages = new ReceiveRequest[numReceives];
                        for (i = 0; i < numReceives; ++i) {
                            messages[i] = new ReceiveRequest();
                            messages[i].readExternal(in);
                        }
                        this.connection.asynchDeliver(messages);
                        break;
                    }
                    case 15: {
                        this.connection.asynchDeleteTemporaryDestination((SpyDestination)in.readObject());
                        break;
                    }
                    case 29: {
                        this.connection.asynchClose();
                        break;
                    }
                    case 28: {
                        this.connection.asynchPong(in.readLong());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    out.writeByte(0);
                    out.flush();
                }
                catch (IOException e) {
                    this.connection.asynchFailure("Connection failure(1)", e);
                }
            }
            catch (Exception e) {
                if (!this.running) break;
                try {
                    OILClientILService.cat.error((Object)"Exception handling server request", (Throwable)e);
                    out.writeByte(2);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                }
                catch (IOException e2) {
                    this.connection.asynchFailure("Connection failure(2)", e2);
                    break;
                }
            }
        }
        try {
            OILClientILService.cat.debug((Object)("Closing receiver connections on port: " + serverPort));
            out.close();
            in.close();
            this.socket.close();
            this.socket = null;
        }
        catch (IOException e) {
            this.connection.asynchFailure("Connection failure", e);
        }
        this.running = false;
    }

    public void start() throws Exception {
        this.running = true;
        this.worker = new Thread(Connection.getThreadGroup(), this, "OILClientILService-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        cat.trace((Object)"Stop called on OILClientService");
        this.running = false;
        this.worker.interrupt();
    }
}

