/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.hibernate.jdbc.JDBCContext;

public class BorrowedConnectionProxy
implements InvocationHandler {
    private final JDBCContext jdbcContext;

    public BorrowedConnectionProxy(JDBCContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            return null;
        }
        try {
            Object object = method.invoke((Object)this.jdbcContext.connection(), args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            this.jdbcContext.getConnectionManager().afterStatement();
        }
    }

    public static Connection generateProxy(JDBCContext jdbcContext) {
        BorrowedConnectionProxy handler = new BorrowedConnectionProxy(jdbcContext);
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)handler);
    }
}

