/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;

public abstract class TransactionHelper {
    private static final Log log = LogFactory.getLog((Class)TransactionHelper.class);

    protected abstract Serializable doWorkInCurrentTransaction(Connection var1, String var2) throws SQLException;

    /*
     * Unable to fully structure code
     */
    public Serializable doWorkInNewTransaction(SessionImplementor session) throws HibernateException {
        tm = session.getFactory().getTransactionManager();
        surroundingTransaction = null;
        conn = null;
        sql = null;
        isJta = tm != null;
        catchedException = false;
        try {
            if (isJta) {
                surroundingTransaction = tm.suspend();
                if (TransactionHelper.log.isDebugEnabled()) {
                    TransactionHelper.log.debug((Object)"surrounding tx suspended");
                }
                tm.begin();
                conn = session.getBatcher().openConnection();
            } else {
                conn = session.getBatcher().openConnection();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
            }
            result = this.doWorkInCurrentTransaction(conn, sql);
            if (isJta) {
                session.getBatcher().closeConnection(conn);
                tm.commit();
            } else {
                conn.commit();
            }
            var9_11 = result;
            return var9_11;
        }
        catch (SQLException sqle) {
            catchedException = true;
            if (isJta) {
                try {
                    try {
                        if (!conn.isClosed()) {
                            session.getBatcher().closeConnection(conn);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    tm.rollback();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
        }
        catch (Exception e) {
            catchedException = true;
            if (isJta) {
                try {
                    try {
                        if (!conn.isClosed()) {
                            session.getBatcher().closeConnection(conn);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    tm.rollback();
                    throw new HibernateException(e);
                }
                catch (SystemException e1) {
                    throw new HibernateException(e1);
                }
            }
            throw new HibernateException(e);
        }
        finally {
            if (isJta) {
                if (isJta && surroundingTransaction != null) {
                    try {
                        tm.resume(surroundingTransaction);
                        if (!TransactionHelper.log.isDebugEnabled()) ** GOTO lbl69
                        TransactionHelper.log.debug((Object)"surrounding tx resumed");
                    }
                    catch (Exception e) {
                        if (catchedException) ** GOTO lbl69
                        throw new HibernateException(e);
                    }
                }
            } else {
                session.getBatcher().closeConnection(conn);
            }
lbl69:
            // 5 sources

        }
    }
}

