package trail.mdpojo;

import java.sql.Timestamp;
import java.util.ArrayList;

public class RecordManager {

  private static ArrayList <CalculationRecord> crs =
      new ArrayList <CalculationRecord> ();
  // The manager holds 100 messages maximum
  // This should work for low volume sites
  private static int maxSize = 100;

  public static void addRecord (Timestamp sent, double result) {
    // Remove the earliest item if the cache is full
    if (crs.size () > maxSize) {
      crs.remove (0);
    }

    Timestamp processed =
        new Timestamp (System.currentTimeMillis());
    crs.add(new CalculationRecord (sent, processed, result ));
  }

  // The sent timestamp acts as the ID of the message
  // reasonable for low volume sites
  public static CalculationRecord getRecord (long sent) {
    for (int i = 0; i < crs.size (); i++) {
      CalculationRecord cr = crs.get(i);
      if (cr.sent.equals(new Timestamp(sent))) {
        return cr;
      }
    }
    return null;
  }

}
