/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.ejb.Basic;
import javax.ejb.CascadeType;
import javax.ejb.Entity;
import javax.ejb.FetchType;
import javax.ejb.GeneratorType;
import javax.ejb.Id;
import javax.ejb.JoinColumn;
import javax.ejb.Transient;
import javax.ejb.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.Binder;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

public class AnnotationBinder {
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindRoot(Class annotatedClass, Mappings mappings) throws MappingException {
        if (!annotatedClass.isAnnotationPresent(Entity.class)) {
            throw new MappingException("Annotated class should have an @Entity annotation: " + annotatedClass.getName());
        }
        RootClass rootClass = new RootClass();
        AnnotationBinder.bindEntity(rootClass, annotatedClass, mappings);
        do {
            Method[] methods = annotatedClass.getDeclaredMethods();
            for (int index = 0; index < methods.length; ++index) {
                Method currentElt = methods[index];
                AnnotedElementInferredData inferredData = new AnnotedElementInferredData(currentElt);
                if (!inferredData.isAnnotable()) continue;
                AnnotationBinder.processRootAnnotations(rootClass, currentElt, mappings, inferredData);
            }
            annotatedClass = annotatedClass.getSuperclass();
        } while (!Object.class.equals(annotatedClass = Object.class));
        rootClass.createPrimaryKey();
        mappings.addClass((PersistentClass)rootClass);
    }

    public static void bindEntity(RootClass rootClass, Class clazz, Mappings mappings) {
        rootClass.setAbstract(false);
        rootClass.setClassName(clazz.getName());
        rootClass.setDynamic(false);
        rootClass.setEntityName(clazz.getName());
        Table table = mappings.addTable(mappings.getSchemaName(), mappings.getCatalogName(), AnnotationBinder.getClassTableName((PersistentClass)rootClass, mappings), null, rootClass.isAbstract());
        rootClass.setTable(table);
        rootClass.setProxyInterfaceName(clazz.getName());
    }

    private static void processRootAnnotations(RootClass rootClass, AnnotatedElement annotedElt, Mappings mappings, AnnotedElementInferredData inferredData) throws MappingException {
        String sqlType;
        javax.ejb.Column ann;
        Ejb3Column column = null;
        if (annotedElt.isAnnotationPresent(Transient.class)) {
            return;
        }
        log.debug((Object)("Processing " + inferredData.getPropertyName()));
        if (annotedElt.isAnnotationPresent(javax.ejb.Column.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.Column.class);
            sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? inferredData.getPropertyName() : ann.name();
            column = new Ejb3Column(sqlType, ann.length(), name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), mappings);
        } else if (annotedElt.isAnnotationPresent(JoinColumn.class)) {
            ann = annotedElt.getAnnotation(JoinColumn.class);
            sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? inferredData.getPropertyName() : ann.name();
            column = new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), mappings);
        } else {
            column = new Ejb3Column(null, 255, inferredData.getPropertyName(), true, false, true, true, mappings);
        }
        if (annotedElt.isAnnotationPresent(Id.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            ann = annotedElt.getAnnotation(Id.class);
            AnnotationBinder.bindId(AnnotationBinder.generatorType(ann.generate()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), column.getMappingColumn(), rootClass, mappings);
            log.debug((Object)("Bind @Id on " + inferredData.getPropertyName()));
        } else if (annotedElt.isAnnotationPresent(Version.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            boolean lazy = false;
            boolean insertable = true;
            boolean updatable = true;
            Property prop = AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, column, rootClass);
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (annotedElt.isAnnotationPresent(javax.ejb.ManyToOne.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.ManyToOne.class);
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade()), (Ejb3JoinColumn)column, ann.optional(), AnnotationBinder.getOuterJoinFetchSetting(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), rootClass, mappings);
        } else if (annotedElt.isAnnotationPresent(javax.ejb.OneToMany.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.OneToMany.class);
            AnnotationBinder.bindOneToMany(inferredData.getCollectionType(), ann.targetEntity(), inferredData.getPropertyName(), inferredData.getReturnedClass(), AnnotationBinder.getOuterJoinFetchSetting(ann.fetch()), (Ejb3JoinColumn)column, AnnotationBinder.getCascadeStrategy(ann.cascade()), rootClass, mappings);
        } else {
            Basic ann2;
            log.debug((Object)(inferredData.getPropertyName() + " is a property"));
            boolean lazy = false;
            if (annotedElt.isAnnotationPresent(Basic.class) && (ann2 = annotedElt.getAnnotation(Basic.class)).fetch() == FetchType.LAZY) {
                lazy = true;
                log.debug((Object)(inferredData.getPropertyName() + " is lazy"));
            }
            Property prop = AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, column, rootClass);
        }
    }

    private static void bindId(String generator, String property, String returnedClassName, Column column, RootClass rootClass, Mappings model) {
        SimpleValue id = AnnotationBinder.makeSimpleValue(property, returnedClassName, column, rootClass);
        rootClass.setIdentifier((KeyValue)id);
        Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generator);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        id.setIdentifierGeneratorProperties(params);
        Property prop = AnnotationBinder.makeProperty(property, (Value)id, true, true, false, null);
        rootClass.setIdentifierProperty(prop);
    }

    private static SimpleValue makeSimpleValue(String propertyName, String returnedClassName, Column column, RootClass rootClass) {
        log.debug((Object)("making simplevalue for " + propertyName));
        Table table = rootClass.getTable();
        SimpleValue simpleValue = new SimpleValue(table);
        return AnnotationBinder.fillSimpleValue(simpleValue, propertyName, returnedClassName, column, rootClass);
    }

    private static SimpleValue fillSimpleValue(SimpleValue simpleValue, String propertyName, String returnedClassName, Column column, RootClass rootClass) {
        simpleValue.setTypeName(returnedClassName);
        if (rootClass != null) {
            simpleValue.setTypeUsingReflection(rootClass.getClassName(), propertyName);
        }
        column.setValue((Value)simpleValue);
        simpleValue.getTable().addColumn(column);
        simpleValue.addColumn(column);
        return simpleValue;
    }

    private static Property bindProperty(String name, String returnedClassName, boolean lazy, Ejb3Column column, RootClass rootClass) {
        log.debug((Object)("binding property " + name));
        SimpleValue propertyValue = AnnotationBinder.makeSimpleValue(name, returnedClassName, column.getMappingColumn(), rootClass);
        Property prop = AnnotationBinder.makeProperty(name, (Value)propertyValue, column.isInsertable(), column.isUpdatable(), lazy, null);
        rootClass.addProperty(prop);
        return prop;
    }

    private static Property makeProperty(String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade);
        log.debug((Object)("Cascading " + propertyName + " with " + cascade));
        return prop;
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn column, boolean optional, int outerJoinFetch, String propertyName, String returnedClassName, String targetEntity, RootClass rootClass, Mappings mappings) {
        ManyToOne value = new ManyToOne(rootClass.getTable());
        if (targetEntity.equals("")) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity);
        }
        value.setOuterJoinFetchSetting(outerJoinFetch);
        if (!optional) {
            throw new NotYetImplementedException("ManyToOne.optional()");
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(rootClass.getClassName(), propertyName);
        column.getMappingColumn().setValue((Value)value);
        value.getTable().addColumn(column.getMappingColumn());
        value.addColumn(column.getMappingColumn());
        String referencedColumn = column.getReferencedColumn();
        if (referencedColumn != null && !referencedColumn.equals("")) {
            throw new NotYetImplementedException("JoinColumn.referencedColumnName");
        }
        String propertyRef = value.getReferencedPropertyName();
        if (propertyRef != null) {
            mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
        }
        value.createForeignKey();
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)value, true, true, false, cascadeStrategy);
        prop.setCascade(cascadeStrategy);
        rootClass.addProperty(prop);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bindOneToMany(Class collectionType, String targetEntity, String propertyName, Class returnedClass, int outerJoinFetchSetting, Ejb3JoinColumn column, String cascadeStrategy, RootClass rootClass, Mappings mappings) {
        Set collection;
        log.trace((Object)("Generic collection type is " + collectionType));
        String collType = null;
        if (targetEntity.equals("")) {
            if (collectionType == null) throw new AnnotationException("Collection " + propertyName + "has neither generic type or OneToMany.targerEntity() defined");
            collType = collectionType.getName();
        } else {
            collType = targetEntity;
        }
        if (returnedClass.equals(java.util.Set.class)) {
            collection = new Set((PersistentClass)rootClass);
        } else {
            if (!returnedClass.equals(Collection.class)) throw new AnnotationException(collType + " collection not yet supported");
            collection = new Bag((PersistentClass)rootClass);
        }
        collection.setRole(StringHelper.qualify((String)collType, (String)propertyName));
        collection.setInverse(true);
        collection.setOuterJoinFetchSetting(outerJoinFetchSetting);
        collection.setLazy(outerJoinFetchSetting == -1);
        OneToMany oneToMany = new OneToMany(collection.getOwner());
        collection.setElement((Value)oneToMany);
        oneToMany.setReferencedEntityName(collType);
        mappings.addSecondPass((Binder.SecondPass)new CollectionSecondPass(mappings, (org.hibernate.mapping.Collection)collection, column));
        mappings.addCollection((org.hibernate.mapping.Collection)collection);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)collection, true, true, false, cascadeStrategy);
        rootClass.addProperty(prop);
    }

    public static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn column) throws MappingException {
        String propRef;
        if (collValue.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collValue.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(persistentClass);
            collValue.setCollectionTable(persistentClass.getTable());
            log.info((Object)("Mapping collection: " + collValue.getRole() + " -> " + collValue.getCollectionTable().getName()));
        }
        KeyValue keyVal = (propRef = collValue.getReferencedPropertyName()) == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        AnnotationBinder.fillSimpleValue((SimpleValue)key, null, null, column.getMappingColumn(), null);
        collValue.setKey((KeyValue)key);
    }

    private static String generatorType(GeneratorType generatorEnum) {
        block3: {
            block2: {
                block1: {
                    block0: {
                        GeneratorType generatorType = generatorEnum;
                        generatorType.getClass();
                        GeneratorType generatorType2 = generatorType;
                        if (generatorType2 == GeneratorType.NONE) break block0;
                        if (generatorType2 == GeneratorType.IDENTITY) break block1;
                        if (generatorType2 == GeneratorType.AUTO) break block2;
                        break block3;
                    }
                    return "assigned";
                }
                return "identity";
            }
            return "native";
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static String getClassTableName(PersistentClass model, Mappings mappings) {
        return mappings.getNamingStrategy().classToTableName(model.getEntityName());
    }

    private static String getCascadeStrategy(CascadeType[] cascades) {
        if (cascades.length == 0) {
            return "none";
        }
        boolean all = false;
        boolean create = false;
        boolean merge = false;
        boolean remove = false;
        for (CascadeType cascade : cascades) {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            CascadeType cascadeType;
                            cascade.getClass();
                            if (cascadeType == CascadeType.ALL) break block11;
                            if (cascadeType == CascadeType.CREATE) break block12;
                            if (cascadeType == CascadeType.MERGE) break block13;
                            if (cascadeType != CascadeType.REMOVE) {
                                continue;
                            }
                            break block14;
                        }
                        all = true;
                        continue;
                    }
                    create = true;
                    continue;
                }
                merge = true;
                continue;
            }
            remove = true;
        }
        if (!all) {
            boolean bl = all = create && merge && remove;
        }
        if (all) {
            return "all";
        }
        if (create && merge) {
            return "create,merge";
        }
        if (create && remove) {
            return "create,delete";
        }
        if (merge && remove) {
            return "merge,delete";
        }
        if (remove) {
            return "delete";
        }
        if (create) {
            return "create";
        }
        if (merge) {
            return "merge";
        }
        throw new AssertionFailure("Error in cascade strategies mapper");
    }

    private static void initOuterJoinFetchSetting(Fetchable value, FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            value.setOuterJoinFetchSetting(1);
        } else {
            value.setOuterJoinFetchSetting(-1);
        }
    }

    private static int getOuterJoinFetchSetting(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return 1;
        }
        return -1;
    }
}

