/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyConnectionMetaData;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;
import org.jboss.util.UnreachableStatementException;

public abstract class Connection
implements Serializable,
javax.jms.Connection {
    private static final long serialVersionUID = 87938199839407082L;
    private static ThreadGroup threadGroup = new ThreadGroup("JBossMQ Client Threads");
    static Logger log = Logger.getLogger((Class)Connection.class);
    static boolean trace = log.isTraceEnabled();
    protected static ClockDaemon clockDaemon = new ClockDaemon();
    public HashMap destinationSubscriptions = new HashMap();
    public HashMap subscriptions = new HashMap();
    public boolean modeStop = true;
    protected ServerIL serverIL;
    protected String clientID;
    protected ConnectionToken connectionToken = null;
    protected ClientILService clientILService;
    protected long pingPeriod = 60000L;
    protected boolean ponged = true;
    Semaphore pingTaskSemaphore = new Semaphore(1L);
    Object pingTaskId;
    protected volatile boolean closing = false;
    private volatile boolean setClientIdAllowed = true;
    HashSet createdSessions;
    int subscriptionCounter = Integer.MIN_VALUE;
    Object subCountLock = new Object();
    boolean closed = false;
    SpyXAResourceManager spyXAResourceManager;
    GenericConnectionFactory genericConnectionFactory;
    private int lastMessageID = 0;
    private ExceptionListener exceptionListener;
    private Object elLock = new Object();
    private Thread elThread;
    private StringBuffer sb = new StringBuffer();
    private char[] charStack = new char[22];
    String sessionId;
    protected HashSet temps = new HashSet();

    public static ThreadGroup getThreadGroup() {
        if (threadGroup.isDestroyed()) {
            threadGroup = new ThreadGroup("JBossMQ Client Threads");
        }
        return threadGroup;
    }

    Connection(String userName, String password, GenericConnectionFactory genericConnectionFactory) throws JMSException {
        this.createdSessions = new HashSet();
        if (trace) {
            log.trace((Object)("Connection Initializing userName=" + userName + " " + this));
        }
        this.genericConnectionFactory = genericConnectionFactory;
        genericConnectionFactory.initialise(this);
        if (trace) {
            log.trace((Object)("Getting the serverIL " + this));
        }
        this.serverIL = genericConnectionFactory.createServerIL();
        if (trace) {
            log.trace((Object)("serverIL=" + this.serverIL + " " + this));
        }
        try {
            this.authenticate(userName, password);
            if (userName != null) {
                this.askForAnID(userName, password);
            }
            this.startILService();
        }
        catch (Throwable t) {
            try {
                this.serverIL.connectionClosing(null);
            }
            catch (Throwable t2) {
                log.debug((Object)"Error closing the connection", t2);
            }
            SpyJMSException.rethrowAsJMSException("Failed to create connection", t);
        }
        try {
            if (trace) {
                log.trace((Object)("Creating XAResourceManager " + this));
            }
            this.spyXAResourceManager = new SpyXAResourceManager(this);
            if (trace) {
                log.trace((Object)("Starting the ping thread " + this));
            }
            this.startPingThread();
            if (trace) {
                log.trace((Object)("Connection establishment successful " + this));
            }
        }
        catch (Throwable t) {
            try {
                this.serverIL.connectionClosing(this.connectionToken);
            }
            catch (Throwable t2) {
                log.debug((Object)"Error closing the connection", t2);
            }
            try {
                this.stopILService();
            }
            catch (Throwable t2) {
                log.debug((Object)"Error stopping the client IL", t2);
            }
            SpyJMSException.rethrowAsJMSException("Failed to create connection", t);
        }
    }

    Connection(GenericConnectionFactory genericConnectionFactory) throws JMSException {
        this(null, null, genericConnectionFactory);
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public void asynchClose() {
    }

    public void asynchDeleteTemporaryDestination(SpyDestination dest) {
        if (trace) {
            log.trace((Object)("Deleting temporary destination " + dest));
        }
        try {
            this.deleteTemporaryDestination(dest);
        }
        catch (Throwable t) {
            this.asynchFailure("Error deleting temporary destination " + dest, t);
        }
    }

    public void asynchDeliver(ReceiveRequest[] requests) {
        if (this.closing) {
            return;
        }
        if (trace) {
            log.trace((Object)("Async deliver requests=" + Arrays.asList(requests) + " " + this));
        }
        try {
            for (int i = 0; i < requests.length; ++i) {
                if (trace) {
                    log.trace((Object)("Processing request=" + requests[i] + " " + this));
                }
                SpyConsumer consumer = (SpyConsumer)this.subscriptions.get(requests[i].subscriptionId);
                requests[i].message.createAcknowledgementRequest(requests[i].subscriptionId);
                if (consumer == null) {
                    this.send(requests[i].message.getAcknowledgementRequest(false));
                    log.debug((Object)("WARNING: NACK issued due to non existent subscription " + requests[i].message.header.messageId));
                    continue;
                }
                if (trace) {
                    log.trace((Object)("Delivering messageid=" + requests[i].message.header.messageId + " to consumer=" + consumer));
                }
                consumer.addMessage(requests[i].message);
            }
        }
        catch (Throwable t) {
            this.asynchFailure("Error during async delivery", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchFailure(String reason, Throwable t) {
        if (trace) {
            log.trace((Object)("Notified of failure reason=" + reason + " " + this), t);
        }
        if (this.closing) {
            return;
        }
        JMSException excep = SpyJMSException.getAsJMSException(reason, t);
        Object object = this.elLock;
        synchronized (object) {
            ExceptionListener el = this.exceptionListener;
            if (el != null && this.elThread == null) {
                try {
                    ExceptionListenerRunnable run = new ExceptionListenerRunnable(el, excep);
                    this.elThread = new Thread(Connection.getThreadGroup(), run, "ExceptionListener " + this);
                    this.elThread.setDaemon(false);
                    this.elThread.start();
                }
                catch (Throwable t1) {
                    log.warn((Object)"Connection failure: ", (Throwable)excep);
                    log.warn((Object)"Unable to start exception listener thread: ", t1);
                }
            } else if (this.elThread != null) {
                log.warn((Object)"Connection failure, already in the exception listener", (Throwable)excep);
            } else {
                log.warn((Object)"Connection failure, use javax.jms.Connection.setExceptionListener() to handle this error and reconnect", (Throwable)excep);
            }
        }
    }

    public void asynchPong(long serverTime) {
        if (trace) {
            log.trace((Object)("PONG serverTime=" + serverTime + " " + this));
        }
        this.ponged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("DeleteDestination dest=" + dest + " " + this));
        }
        try {
            this.serverIL.deleteTemporaryDestination(this.connectionToken, dest);
            Cloneable cloneable = this.subscriptions;
            synchronized (cloneable) {
                this.destinationSubscriptions.remove(dest);
            }
            cloneable = this.temps;
            synchronized (cloneable) {
                this.temps.remove(dest);
            }
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot delete the TemporaryDestination", t);
        }
    }

    public void setClientID(String cID) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.clientID != null) {
            throw new IllegalStateException("The connection has already a clientID");
        }
        if (!this.setClientIdAllowed) {
            throw new IllegalStateException("SetClientID was not called emediately after creation of connection");
        }
        if (trace) {
            log.trace((Object)("SetClientID clientID=" + this.clientID + " " + this));
        }
        try {
            this.serverIL.checkID(cID);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot connect to the JMSServer", t);
        }
        this.clientID = cID;
        this.connectionToken.setClientID(this.clientID);
    }

    public String getClientID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        this.exceptionListener = listener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        return new SpyConnectionMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        JMSException exception;
        block25: {
            block24: {
                block23: {
                    if (this.closed) {
                        return;
                    }
                    if (trace) {
                        log.trace((Object)("Closing connection " + this));
                    }
                    this.closing = true;
                    this.exceptionListener = null;
                    exception = null;
                    try {
                        this.doStop();
                    }
                    catch (Throwable t) {
                        exception = SpyJMSException.getAsJMSException("Error duing stop", t);
                    }
                    if (trace) {
                        log.trace((Object)("Closing sessions " + this));
                    }
                    Object[] vect = null;
                    HashSet hashSet = this.createdSessions;
                    synchronized (hashSet) {
                        vect = this.createdSessions.toArray();
                    }
                    for (int i = 0; i < vect.length; ++i) {
                        try {
                            ((SpySession)vect[i]).close();
                            continue;
                        }
                        catch (Throwable t) {
                            if (exception != null) continue;
                            exception = SpyJMSException.getAsJMSException("Error closing sessions", t);
                        }
                    }
                    if (trace) {
                        log.trace((Object)("Closed sessions " + this));
                    }
                    if (trace) {
                        log.trace((Object)("Notifying the server of close " + this));
                    }
                    try {
                        this.serverIL.connectionClosing(this.connectionToken);
                    }
                    catch (Throwable t) {
                        if (exception != null) break block23;
                        exception = SpyJMSException.getAsJMSException("Cannot close properly the connection", t);
                    }
                }
                if (trace) {
                    log.trace((Object)("Stopping ping thread " + this));
                }
                try {
                    this.stopPingThread();
                }
                catch (Throwable t) {
                    if (exception != null) break block24;
                    exception = SpyJMSException.getAsJMSException("Cannot stop the ping thread", t);
                }
            }
            if (trace) {
                log.trace((Object)("Stopping the ClientIL service " + this));
            }
            try {
                this.stopILService();
            }
            catch (Throwable t) {
                if (exception != null) break block25;
                exception = SpyJMSException.getAsJMSException("Cannot stop the client il service", t);
            }
        }
        this.closed = true;
        if (trace) {
            log.trace((Object)("Disconnected from server " + this));
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void start() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        if (!this.modeStop) {
            return;
        }
        this.modeStop = false;
        if (trace) {
            log.trace((Object)("Starting connection " + this));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, true);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot enable the connection with the JMS server", t);
        }
    }

    public void stop() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        this.doStop();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Connection@").append(System.identityHashCode(this));
        buffer.append('[');
        if (this.connectionToken != null) {
            buffer.append("token=").append(this.connectionToken);
        } else {
            buffer.append("clientID=").append(this.clientID);
        }
        if (this.closed) {
            buffer.append(" CLOSED");
        } else if (this.closing) {
            buffer.append(" CLOSING");
        }
        buffer.append(" rcvstate=");
        if (this.modeStop) {
            buffer.append("STOPPED");
        } else {
            buffer.append("STARTED");
        }
        buffer.append(']');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        StringBuffer stringBuffer = this.sb;
        synchronized (stringBuffer) {
            this.sb.setLength(0);
            this.sb.append(this.clientID);
            this.sb.append('-');
            long time = System.currentTimeMillis();
            int count = 0;
            do {
                this.charStack[count] = (char)(48L + time % 10L);
                ++count;
            } while ((time /= 10L) != 0L);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            ++this.lastMessageID;
            if (this.lastMessageID < 0) {
                this.lastMessageID = 0;
            }
            int id = this.lastMessageID;
            count = 0;
            do {
                this.charStack[count] = (char)(48 + id % 10);
                ++count;
            } while ((id /= 10) != 0);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            return this.sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        Object object = this.subCountLock;
        synchronized (object) {
            req.subscriptionId = this.subscriptionCounter++;
        }
        req.connectionToken = this.connectionToken;
        if (trace) {
            log.trace((Object)("addConsumer sub=" + req));
        }
        try {
            object = this.subscriptions;
            synchronized (object) {
                this.subscriptions.put(new Integer(req.subscriptionId), consumer);
                LinkedList<SpyConsumer> ll = (LinkedList<SpyConsumer>)this.destinationSubscriptions.get(req.destination);
                if (ll == null) {
                    ll = new LinkedList<SpyConsumer>();
                    this.destinationSubscriptions.put(req.destination, ll);
                }
                ll.add(consumer);
            }
            this.serverIL.subscribe(this.connectionToken, req);
        }
        catch (JMSSecurityException ex) {
            this.removeConsumerInternal(consumer);
            throw ex;
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot subscribe to this Destination: ", t);
        }
    }

    SpyMessage[] browse(Queue queue, String selector) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("Browsing queue=" + queue + " selector=" + selector + " " + this));
        }
        try {
            return this.serverIL.browse(this.connectionToken, (Destination)queue, selector);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot browse the Queue", t);
            throw new UnreachableStatementException();
        }
    }

    void pingServer(long clientTime) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("PING " + clientTime + " " + this));
        }
        try {
            this.serverIL.ping(this.connectionToken, clientTime);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot ping the JMS server", t);
        }
    }

    SpyMessage receive(Subscription sub, long wait) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("Receive subscription=" + sub + " wait=" + wait));
        }
        try {
            SpyMessage message = this.serverIL.receive(this.connectionToken, sub.subscriptionId, wait);
            if (message != null) {
                message.createAcknowledgementRequest(sub.subscriptionId);
            }
            return message;
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot receive ", t);
            throw new UnreachableStatementException();
        }
    }

    void removeConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        if (trace) {
            log.trace((Object)("removeConsumer req=" + req));
        }
        try {
            this.serverIL.unsubscribe(this.connectionToken, req.subscriptionId);
            this.removeConsumerInternal(consumer);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot unsubscribe to this destination", t);
        }
    }

    void sendToServer(SpyMessage mes) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("SendToServer message=" + mes.header.jmsMessageID + " " + this));
        }
        try {
            this.serverIL.addMessage(this.connectionToken, mes);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot send a message to the JMS server", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionClosing(SpySession who) {
        if (trace) {
            log.trace((Object)("Closing session " + who));
        }
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.remove(who);
        }
    }

    void unsubscribe(DurableSubscriptionID id) throws JMSException {
        if (trace) {
            log.trace((Object)("Unsubscribe id=" + id + " " + this));
        }
        try {
            this.serverIL.destroySubscription(this.connectionToken, id);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot destroy durable subscription " + id, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTemporary(Destination destination) throws JMSException {
        if (destination instanceof TemporaryQueue || destination instanceof TemporaryTopic) {
            HashSet hashSet = this.temps;
            synchronized (hashSet) {
                if (!this.temps.contains(destination)) {
                    throw new JMSException("Cannot create a consumer for a temporary destination from a different session. " + destination);
                }
            }
        }
    }

    protected synchronized void checkClientID() throws JMSException {
        if (!this.setClientIdAllowed) {
            return;
        }
        this.setClientIdAllowed = false;
        if (trace) {
            log.trace((Object)("Checking clientID=" + this.clientID + " " + this));
        }
        if (this.clientID == null) {
            this.askForAnID();
            if (this.clientID == null) {
                throw new JMSException("Could not get a clientID");
            }
            this.connectionToken.setClientID(this.clientID);
            if (trace) {
                log.trace((Object)("ClientID established " + this));
            }
        }
    }

    protected void askForAnID() throws JMSException {
        if (trace) {
            log.trace((Object)("Ask for an id " + this));
        }
        try {
            if (this.clientID == null) {
                this.clientID = this.serverIL.getID();
            }
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot get a client ID", t);
        }
    }

    protected void askForAnID(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("Ask for an id user=" + userName + " " + this));
        }
        try {
            String configuredClientID = this.serverIL.checkUser(userName, password);
            if (configuredClientID != null) {
                this.clientID = configuredClientID;
            }
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot get a client ID", t);
        }
    }

    protected void authenticate(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("Authenticating user " + userName + " " + this));
        }
        try {
            this.sessionId = this.serverIL.authenticate(userName, password);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot authenticate user", t);
        }
    }

    protected void send(AcknowledgementRequest item) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("Acknowledge item=" + item + " " + this));
        }
        try {
            this.serverIL.acknowledge(this.connectionToken, item);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot acknowlege a message", t);
        }
    }

    protected void send(TransactionRequest transaction) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (trace) {
            log.trace((Object)("Transact request=" + transaction + " " + this));
        }
        try {
            this.serverIL.transact(this.connectionToken, transaction);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot process a transaction", t);
        }
    }

    protected void startILService() throws JMSException {
        if (trace) {
            log.trace((Object)("Starting the client il " + this));
        }
        try {
            this.clientILService = this.genericConnectionFactory.createClientILService(this);
            this.clientILService.start();
            if (trace) {
                log.trace((Object)("Using client id " + this.clientILService + " " + this));
            }
            this.connectionToken = new ConnectionToken(this.clientID, this.clientILService.getClientIL(), this.sessionId);
            this.serverIL.setConnectionToken(this.connectionToken);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot start a the client IL service", t);
        }
    }

    protected void stopILService() throws JMSException {
        try {
            this.clientILService.stop();
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot stop a the client IL service", t);
        }
    }

    public void doStop() throws JMSException {
        if (this.modeStop) {
            return;
        }
        this.modeStop = true;
        if (trace) {
            log.trace((Object)("Stopping connection " + this));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, false);
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Cannot disable the connection with the JMS server", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerInternal(SpyConsumer consumer) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            Subscription req = consumer.getSubscription();
            this.subscriptions.remove(new Integer(req.subscriptionId));
            LinkedList ll = (LinkedList)this.destinationSubscriptions.get(req.destination);
            if (ll != null) {
                ll.remove(consumer);
                if (ll.size() == 0) {
                    this.destinationSubscriptions.remove(req.destination);
                }
            }
        }
    }

    private void startPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        this.pingTaskId = clockDaemon.executePeriodically(this.pingPeriod, (Runnable)new PingTask(), true);
    }

    private void stopPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        ClockDaemon.cancel((Object)this.pingTaskId);
        try {
            this.pingTaskSemaphore.attempt(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        log.debug((Object)"Setting the clockDaemon's thread factory");
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(Connection.getThreadGroup(), r, "Connection Monitor Thread");
                t.setDaemon(true);
                return t;
            }
        });
    }

    class ExceptionListenerRunnable
    implements Runnable {
        ExceptionListener el;
        JMSException excep;

        public ExceptionListenerRunnable(ExceptionListener el, JMSException excep) {
            this.el = el;
            this.excep = excep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                object = this.el;
                synchronized (object) {
                    this.el.onException(this.excep);
                }
            }
            catch (Throwable t) {
                log.warn((Object)"Connection failure: ", (Throwable)this.excep);
                log.warn((Object)"Exception listener ended abnormally: ", t);
            }
            object = Connection.this.elLock;
            synchronized (object) {
                Connection.this.elThread = null;
            }
        }
    }

    class PingTask
    implements Runnable {
        PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Connection.this.pingTaskSemaphore.acquire();
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted requesting ping semaphore");
                return;
            }
            try {
                if (!Connection.this.ponged) {
                    throw new SpyJMSException("No pong received", new IOException("ping timeout."));
                }
                Connection.this.ponged = false;
                Connection.this.pingServer(System.currentTimeMillis());
            }
            catch (Throwable t) {
                Connection.this.asynchFailure("Unexpected ping failure", t);
            }
            finally {
                Connection.this.pingTaskSemaphore.release();
            }
        }
    }
}

