/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.HashCode;
import org.jboss.util.MuNumber;
import org.jboss.util.NotCoercibleException;
import org.jboss.util.Primitives;

public class MuFloat
extends MuNumber {
    private float value;

    public MuFloat() {
    }

    public MuFloat(float f) {
        this.value = f;
    }

    public MuFloat(Object obj) {
        this.setValue(obj);
    }

    public float set(float f) {
        float old = this.value;
        this.value = f;
        return old;
    }

    public float get() {
        return this.value;
    }

    public boolean commit(float assumed, float b) {
        boolean success = Primitives.equals(assumed, this.value);
        if (success) {
            this.value = b;
        }
        return success;
    }

    public float swap(MuFloat b) {
        if (b == this) {
            return this.value;
        }
        float temp = this.value;
        this.value = b.value;
        b.value = temp;
        return this.value;
    }

    public float add(float amount) {
        return this.value += amount;
    }

    public float subtract(float amount) {
        return this.value -= amount;
    }

    public float multiply(float factor) {
        return this.value *= factor;
    }

    public float divide(float factor) {
        return this.value /= factor;
    }

    public float negate() {
        this.value = -this.value;
        return this.value;
    }

    public int compareTo(float other) {
        return this.value < other ? -1 : (Primitives.equals(this.value, other) ? 0 : 1);
    }

    public int compareTo(Object obj) {
        return this.compareTo((MuFloat)obj);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return HashCode.generate(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return Primitives.equals(this.value, ((MuFloat)obj).floatValue());
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void setValue(Object obj) {
        if (obj instanceof Number) {
            this.value = ((Number)obj).floatValue();
        } else if (obj instanceof String) {
            try {
                this.value = Float.parseFloat(String.valueOf(obj));
            }
            catch (Exception e) {
                throw new NotCoercibleException("can not convert to 'float': " + obj);
            }
        } else {
            throw new NotCoercibleException("can not convert to 'float': " + obj);
        }
    }

    public Object getValue() {
        return new Float(this.value);
    }
}

