/*
 * Decompiled with CFR 0.152.
 */
package de.tisje.java2html;

import de.java2html.converter.AbstractJavaSourceToXmlConverter;
import de.java2html.converter.JavaSource2XhtmlConverter;
import de.java2html.converter.JavaSource2XmlConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

public class XsltTask {
    private static JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
    private static AbstractJavaSourceToXmlConverter converter = new JavaSource2XhtmlConverter();
    private static JavaSource source = null;
    private static boolean xhtml = false;

    public static void setOptions(boolean lineNumbers, boolean pre, boolean xhtml) {
        converter = xhtml ? new JavaSource2XhtmlConverter() : new JavaSource2XmlConverter();
        converter.setOptions(lineNumbers, pre);
        XsltTask.xhtml = xhtml;
    }

    public static void setSource(String javaSource) {
        source = new JavaSourceParser().parse(javaSource);
    }

    public static void readFile(String javaFile) throws IOException {
        source = new JavaSourceParser().parse(new File(javaFile));
    }

    public static String getSource() throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(converter.getDocumentHeader(options, ""));
        converter.convert(source, options, writer);
        writer.write(converter.getDocumentFooter(options));
        return writer.getBuffer().toString();
    }

    public static void writeFile(String filename) throws IOException {
        XsltTask.writeFile(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(converter.getDocumentHeader(options, ""));
            converter.convert(source, options, fileWriter);
            fileWriter.write(converter.getDocumentFooter(options));
        }
        finally {
            IoUtilities.close(fileWriter);
        }
    }

    public static void main(String[] args) {
        String ext = ".xhtml";
        if (!xhtml) {
            ext = ".xml";
        }
        for (int i = 0; args.length > i; ++i) {
            try {
                XsltTask.readFile(args[i]);
                XsltTask.writeFile(args[i] + ext);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

