/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.util;

import de.java2html.util.RGB;
import java.util.Hashtable;

public class HtmlUtilities {
    private static Hashtable entityTableEncode;
    private static final String[] ENTITIES;

    private HtmlUtilities() {
    }

    protected static void buildEntityTables() {
        entityTableEncode = new Hashtable(ENTITIES.length);
        for (int i = 0; i < ENTITIES.length; i += 2) {
            if (entityTableEncode.containsKey(ENTITIES[i + 1])) continue;
            entityTableEncode.put(ENTITIES[i + 1], ENTITIES[i]);
        }
    }

    public static final String encode(String s, String ignore) {
        return HtmlUtilities.encode(s, 0, s.length(), ignore);
    }

    public static final String encode(String s, int start, int end, String ignore) {
        if (entityTableEncode == null) {
            HtmlUtilities.buildEntityTables();
        }
        StringBuffer sb = new StringBuffer((end - start) * 2);
        for (int i = start; i < end; ++i) {
            char ch = s.charAt(i);
            if (ch >= '?' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ignore.indexOf(ch) != -1) {
                sb.append(ch);
                continue;
            }
            sb.append(HtmlUtilities.encodeSingleChar(String.valueOf(ch)));
        }
        return sb.toString();
    }

    protected static final String encodeSingleChar(String ch) {
        String s = (String)entityTableEncode.get(ch);
        return s == null ? ch : s;
    }

    public static final String toHTML(RGB color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    static {
        ENTITIES = new String[]{" ", " ", "-", "-", "'", "'", "`", "`", "&Uuml;", "\uff9c", "&Auml;", "\uff84", "&Ouml;", "\uff96", "&Euml;", "\uff8b", "&Ccedil;", "\uff87", "&AElig;", "\uff86", "&Aring;", "\uff85", "&Oslash;", "\uff98", "&uuml;", "\ufffd", "&auml;", "\ufffd", "&ouml;", "\ufffd", "&euml;", "\ufffd", "&ccedil;", "\ufffd", "&aring;", "\ufffd", "&oslash;", "\ufffd", "&grave;", "`", "&agrave;", "\ufffd", "&egrave;", "\ufffd", "&igrave;", "\ufffd", "&ograve;", "\ufffd", "&ugrave;", "\ufffd", "&amp;", "&", "&#34;", "\"", "&szlig;", "\uff9f", "&nbsp;", " ", "&gt;", ">", "&lt;", "<", "&copy;", "(C)", "&cent;", "\uff62", "&pound;", "\uff63", "&laquo;", "\uff6b", "&raquo;", "\uff7b", "&reg;", "(R)", "&middot;", " - ", "&times;", " x ", "&acute;", "'", "&aacute;", "\ufffd", "&uacute;", "\ufffd", "&oacute;", "\ufffd", "&eacute;", "\ufffd", "&iacute;", "\ufffd", "&ntilde;", "\ufffd", "&sect;", "\uff67", "&egrave;", "\ufffd", "&icirc;", "\ufffd", "&ocirc;", "\ufffd", "&acirc;", "\ufffd", "&ucirc;", "\ufffd", "&ecirc;", "\ufffd", "&aelig;", "\ufffd", "&iexcl;", "\uff61", "&#151;", "-", "&#0151;", "-", "&#0146;", "'", "&#146;", "'", "&#0145;", "'", "&#145;", "'", "&quot;", "\""};
    }
}

