/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter.test;

import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import junit.framework.TestCase;

public class JavaSourceConverterProviderTest
extends TestCase {
    public void testGetConverterNames() {
        String[] names = JavaSourceConverterProvider.getAllConverterNames();
        JavaSourceConverterProviderTest.assertNotNull((Object)names);
        JavaSourceConverterProviderTest.assertTrue((2 < names.length ? 1 : 0) != 0);
        for (int i = 0; i < names.length; ++i) {
            JavaSourceConverterProviderTest.assertNotNull((Object)names[i]);
        }
    }

    public void testGetConverterPrintNames() {
        String[] names = JavaSourceConverterProvider.getAllConverterPrintNames();
        JavaSourceConverterProviderTest.assertNotNull((Object)names);
        JavaSourceConverterProviderTest.assertTrue((2 < names.length ? 1 : 0) != 0);
        for (int i = 0; i < names.length; ++i) {
            JavaSourceConverterProviderTest.assertNotNull((Object)names[i]);
        }
    }

    public void testGetConvertersByName() {
        String[] names = JavaSourceConverterProvider.getAllConverterNames();
        for (int i = 0; i < names.length; ++i) {
            IJavaSourceConverter converter = JavaSourceConverterProvider.getJavaSourceConverterByName(names[i]);
            JavaSourceConverterProviderTest.assertNotNull((Object)converter);
            JavaSourceConverterProviderTest.assertTrue((boolean)names[i].equalsIgnoreCase(converter.getMetaData().getName()));
        }
    }

    public void testGetConvertersByNameIgnoresCase() {
        String[] names = JavaSourceConverterProvider.getAllConverterNames();
        for (int i = 0; i < names.length; ++i) {
            IJavaSourceConverter converter1 = JavaSourceConverterProvider.getJavaSourceConverterByName(names[i].toLowerCase());
            IJavaSourceConverter converter2 = JavaSourceConverterProvider.getJavaSourceConverterByName(names[i].toUpperCase());
            JavaSourceConverterProviderTest.assertSame((Object)converter1, (Object)converter2);
        }
    }

    public void testGetAllConvetersReturnsConverters() {
        IJavaSourceConverter[] allConverters = JavaSourceConverterProvider.getAllConverters();
        JavaSourceConverterProviderTest.assertTrue((allConverters.length > 2 ? 1 : 0) != 0);
        for (int i = 0; i < allConverters.length; ++i) {
            JavaSourceConverterProviderTest.assertNotNull((Object)allConverters[i]);
        }
    }
}

