/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "ScoreMng.h"

#define HISCORE_DATA_VER 1
//#define HISCORE_DATA_FNAME ".qtapscore.dat"

#define MAX_NAME_LENGTH  6


CScoreMng::CScoreMng( QString scoreFile )
{
  int i;

  m_version = HISCORE_DATA_VER;

  for( i = 0 ; i < REGIST_MAX; i++){
    m_pScore[i] = NULL;
  }

  m_scoreFile = scoreFile;

}
bool CScoreMng::IsRankIn(int score)
{
  int i;

  for( i = 0; i < REGIST_MAX; i++){
    
    if( m_pScore[i] ){

      if( score > m_pScore[i]->GetScore() ){
	return true;
      }

    }

  }

  return false;

}
void CScoreMng::InitHiScore()
{
  int i;

  for( i = 0 ; i < REGIST_MAX; i++){
    
    if( m_pScore[i] ){
      delete m_pScore[i];
    }

  }

  RegistHiScore( QString("TUX"),  1000 );
  RegistHiScore( QString("ZAURU"), 900 );
  RegistHiScore( QString("SENNA"), 800 );
  RegistHiScore( QString("KEN"),   700 );
  RegistHiScore( QString("JUN"),   600 );
  RegistHiScore( QString("KING"),  500 );
  RegistHiScore( QString("TAIGA"), 400 );
  RegistHiScore( QString("KENGO"), 300 );
  RegistHiScore( QString("TAKU"),  200 );
  RegistHiScore( QString("BILL"),  100 );

}
bool CScoreMng::SaveHiScore()
{

  QFile file( m_scoreFile );

  if( QFile::exists( m_scoreFile ) ){
    // file exist
    QFile::remove(  m_scoreFile );
  }

  file.open( IO_Raw | IO_ReadWrite );

  // write data
  Save( &file );
  file.close();
  
  return TRUE;
}
bool CScoreMng::RegistHiScore(QString name, int score, bool order)
{

  CScore* pScore[REGIST_MAX];
  int i;

  for( i = 0 ; i < REGIST_MAX; i++){

    pScore[i] = m_pScore[i];
    m_pScore[i] = NULL;

  }
  
  for( i = 0 ; i < REGIST_MAX; i++){

    if(pScore[i]){

      bool regist = false;

      if( order && ( score > pScore[i]->GetScore() ) ){
	regist = true;
      }
      if( !order && ( score < pScore[i]->GetScore() ) ){
	regist = true;
      }

      if( regist ){

	// regist score
	m_pScore[i] = new CScore();
	m_pScore[i]->SetName( name );
	m_pScore[i]->SetScore( score );

	for( int j = i + 1; j < REGIST_MAX; j++ )  m_pScore[j] = pScore[j-1];
	if( pScore[REGIST_MAX - 1] ){
	  delete pScore[REGIST_MAX - 1];
	}
	break;

      } else {

	m_pScore[i] = pScore[i];

      }


    } else {

      m_pScore[i] = new CScore();
      m_pScore[i]->SetName( name );
      m_pScore[i]->SetScore( score );
     
      break;

    }

  }
  
  return true;
}
//
// Download Hi-score from file.
//
void CScoreMng::DownLoadHiScore()
{

  QFile file( m_scoreFile );

  if(OpenDataFile(&file)){

    if( Load(&file) ){
      InitHiScore();
    }

    file.close();
  } else {
    InitHiScore();
  }

}
void CScoreMng::Save(QFile *pFile)
{

  int i,j;
  QString str;
  char rowData;

  // write data ver
  if( !pFile->writeBlock ( (char *)&m_version, sizeof(int) ) ){
    pFile->close();
  }

  // write score data
  for(i = 0; i < REGIST_MAX; i++){

    str = m_pScore[i]->GetName();

    for( j = 0; j < (int)str.length(); j++ ){

      QChar ch = str[j];
      rowData = ch.latin1();
      if( !pFile->writeBlock ( (char *)&rowData, sizeof(char) ) ){
	return;
      }

    }
    // Fill zero
    rowData = 0;
    while( j < MAX_NAME_LENGTH + 1 ){
      if( !pFile->writeBlock ( (char *)&rowData, sizeof(char) ) ){
	return;
      }
      j++;
    }  

    int score = m_pScore[i]->GetScore();
    if( !pFile->writeBlock ( (char *)&score, sizeof(int) ) ){
      return;
    }    

  }

}
//
// Loading Hi-score data
//
int CScoreMng::Load(QFile *pFile)
{
  char name[ MAX_NAME_LENGTH + 1 ];
  int i;
  int score = 0;

  for(i = 0; i < REGIST_MAX; i++){
    
    
    // Load name  
    if(pFile->readBlock ( name , MAX_NAME_LENGTH + 1 ) == -1){
      return -1;
    }
    name[ MAX_NAME_LENGTH ] = 0;

    // Load score
    if(pFile->readBlock ( (char *)&score , sizeof(score) ) == -1){
      return -1;
    }

    // Regist 
    RegistHiScore(QString(name), score);

  }

  return 0;


}
bool CScoreMng::OpenDataFile(QFile *pFile)
{

  int version;

  if(!QFile::exists( m_scoreFile )){
      return false;
  }

  pFile->open(IO_ReadOnly);
  if(pFile->readBlock ( (char *)&version , sizeof(int)) == -1){
    pFile->close();
    return false;
  }

  if( version != m_version ){
    pFile->close();
    return false;
  }

  return true;

}
bool CScoreMng::GetHiScore( int rank, QString *name, int *score )
{
  
  if( rank > REGIST_MAX ) return FALSE;

  if( m_pScore[rank - 1] ){
    *name = m_pScore[rank - 1]->GetName();
    *score = m_pScore[rank - 1]->GetScore();
  } else {
    return FALSE;
  }

  return TRUE;
}
int  CScoreMng::GetHiScore(int rank)
{

  if( rank > REGIST_MAX ) return 0;

  return m_pScore[rank - 1]->GetScore();
}
