/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdlib.h>
#include <time.h>

#include "Field.h"
#include "Locallib.h"


CField::CField()
{
  m_fildLock = false;
  m_blockTypeNum=5;
  initFiled();
}


void CField::initNextBlock()
{
  int i;
	
  for(i = 0;i < FIELD_NUM_X;i++){
    m_nextBlock[i].SetType(NONE);
    m_nextBlock[i].SetPosX( (i % FIELD_NUM_X) * FIELD_WIDTH + NEXTBLK_OFFSET_X );
    m_nextBlock[i].SetPosY( NEXTBLK_OFFSET_Y );
  }

}
void CField::setRandomBlock()
{
  int i;

  for(i = FIELD_NUM_X * FIELD_NUM_Y - 1;i >= FIELD_NUM_X * (FIELD_NUM_Y - 5);i--){
		
    if(i >= (FIELD_NUM_X * (FIELD_NUM_Y - 1)) ){
      m_field[i].SetType( GetRandVar( 1, m_blockTypeNum) );
    } else {
      if(m_field[i + FIELD_NUM_X].GetType() == NONE) {
	m_field[i].SetType( NONE );
	continue;
      } else {
	m_field[i].SetType( GetRandVar( 0, m_blockTypeNum) );
      }
    }

  }

}
//
// initialize
//
void CField::initFiled()
{
  
  int i;
	
  m_blockTypeNum = 3;
  m_fildLock = false;

  /* initialize random number generator */
  srand(::time(0));
	
  for(i = 0;i < FIELD_NUM_X * FIELD_NUM_Y;i++){
    m_field[i].SetType(NONE);
    m_field[i].SetSameBlock(false);
    m_field[i].SetPosX( (i % FIELD_NUM_X) * FIELD_WIDTH + FIELD_OFFSET_X );
    m_field[i].SetPosY( (i / FIELD_NUM_X) * FIELD_HEIGHT + FIELD_OFFSET_Y );
  }
	
  for(i = 0;i < FIELD_NUM_X;i++){
    m_nextBlock[i].SetType(NONE);
  }
	
  setRandomBlock();
	
  initNextBlock();
  setNextBlock();

}
//
// The position that corresponds on the screen that corresponds to argument x and
// y coordinates is returned. 
// true: It is on field. false:It is not on field. 
// hashval:Position on field(It is effective only for true.)
//
bool CField::hashFunc(int x, int y, int* hashval)
{
  int posx,posy;
	
  x -= FIELD_OFFSET_X;
  y -= FIELD_OFFSET_Y;
	
  if(x > ((FIELD_NUM_X + 1 )* FIELD_WIDTH) || (y > (FIELD_NUM_Y * 1) * FIELD_HEIGHT)) {
    return false;
  }
	
  posx = x / FIELD_WIDTH;
  posy = y / FIELD_HEIGHT;
	
  if(posx > (FIELD_NUM_X - 1) || (posy > (FIELD_NUM_Y - 1))) {
    return false;
  }
	
  *hashval = (posx + posy * FIELD_NUM_X);
	
  return true;

}
//
// Set of the next block table.
//
void CField::setNextBlock()
{
  int i;
	
  for(i = 0; i < FIELD_NUM_X; i++){

    m_nextBlock[i].SetType( GetRandVar(1, m_blockTypeNum) );
    // The probability of the explosion is changed.
    if(m_nextBlock[i].GetType() == BOMB){
      if( GetRandVar( 1, 10) != 10 ) m_nextBlock[i].SetType(TYPE1);
    }

  }

}
//
// The blocks are raised. 
// True : gameover
//
bool CField::upBlock()
{
  
  int i;
	
  bool ret = false;
	
  //set filed[]
  for(i = 0; i < FIELD_NUM_X * FIELD_NUM_Y; i++){

    if(i < FIELD_NUM_X){
			
      if( m_field[i].GetType() == NONE) continue;
      ret = true;
			
    } else {
      //It copies it onto the block on the row. 
      m_field[i - FIELD_NUM_X].SetType( m_field[i].GetType() );
    }
	
  }
	
  //copy next block
  for(i = 0;i < FIELD_NUM_X;i++){
    m_field[FIELD_NUM_X * (FIELD_NUM_Y - 1) + i].SetType(m_nextBlock[i].GetType());
  }
	
  return ret;

}

int CField::checkLine(int index, int parent)
{
	int sameBlk = 0;
	int nextBlk = 0;
	
	
	if( index >= FIELD_NUM_X * FIELD_NUM_Y) return 0;
	
	if( m_field[index].GetType() == NONE) return 0;

	if(index != parent){

		if( (m_field[index].GetType() == m_field[parent].GetType()) ){
			sameBlk++;
			m_field[index].SetSameBlock();

		} else {
			return 0;
		}

	} else {
		m_field[index].SetSameBlock();
		if( m_field[parent].GetType() == BOMB )
		  return checkClkBomb( index );
	}
	
	//It excludes it because there is no block on up. 
	if(index >= FIELD_NUM_X) {
		nextBlk = index - FIELD_NUM_X;
		if(nextBlk != parent){

			if(! m_field[nextBlk].IsSameBlock()){
			    sameBlk += checkLine(nextBlk,index);
			  }


		}
	}
	//It excludes it because in the under, there is no block below. 
	if(index < FIELD_NUM_X * (FIELD_NUM_Y - 1)){
		nextBlk = index + FIELD_NUM_X;
		if(nextBlk != parent){
			if(!m_field[nextBlk].IsSameBlock()){


			    sameBlk += checkLine(nextBlk,index);


			}
		}
	}
	//Because the leftmost doesn't have the block in the left, it excludes it.
	if((index % FIELD_NUM_X) != 0 ) {
		nextBlk = index - 1;
		if(nextBlk != parent){
			if(!m_field[nextBlk].IsSameBlock()){

				
			    sameBlk += checkLine(nextBlk,index);

			}
		}
	}
	//It excludes it because there is no block in the right rightmost. 
	if((index % FIELD_NUM_X) != (FIELD_NUM_X - 1)){
		nextBlk = index + 1;
		if(nextBlk != parent){
		       if(!m_field[nextBlk].IsSameBlock()){

     
   
				sameBlk += checkLine(nextBlk,index);
		       }

		}
	}

	return sameBlk;
}
//
//
//
void CField::DeletSameBlk()
{
  int i;
	
  for(i = 0; i < FIELD_NUM_X * FIELD_NUM_Y; i++){
    if(m_field[i].IsSameBlock()){
      m_field[i].SetType(NONE);
      m_field[i].SetSameBlock(false);
    }
  }

}
void CField::CancelSameBlk()
{
  int i;
	
  for(i = 0; i < FIELD_NUM_X * FIELD_NUM_Y; i++){
    if(m_field[i].IsSameBlock()){
      m_field[i].SetSameBlock(false);
    }
  }

}
//
// Whether the bomb was done in the tap is checked.
//
int CField::checkClkBomb(int index)
{

  int sameBlk = 0;
  int target;

  m_field[index].SetSameBlock();
	
  if( index < FIELD_NUM_X * (FIELD_NUM_Y - 1) ){
		
    //The block is not the under. 
    target = index + FIELD_NUM_X;
    if( (m_field[target].GetType() != NONE) && (!m_field[target].IsSameBlock()) ){
      m_field[target].SetSameBlock();
      sameBlk += checkLine( target, target );
    }
    
    if((index % FIELD_NUM_X) == 0){
      //The leftmost side
      target = index + FIELD_NUM_X + 1;
      if( (m_field[target].GetType() != NONE) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    } else if((index % FIELD_NUM_X) == FIELD_NUM_X - 1){
      //The rightmost side
      target = index + FIELD_NUM_X - 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    } else {
      target = index + FIELD_NUM_X - 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
      target = index + FIELD_NUM_X + 1;
      if( (m_field[target].GetType() != NONE) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    }

  }
	
  if(index >= FIELD_NUM_X){
    //It is not a block on most.
    target = index - FIELD_NUM_X;		
    if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock())){
      m_field[target].SetSameBlock();
      sameBlk += checkLine( target, target );
    }
		
    if((index % FIELD_NUM_X) == 0){
      // most left
      target = index - FIELD_NUM_X + 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    } else if((index % FIELD_NUM_X) == FIELD_NUM_X - 1){
      // most right
      target = index - FIELD_NUM_X - 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    } else {
      target = index - FIELD_NUM_X - 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
      target = index - FIELD_NUM_X + 1;
      if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
	m_field[target].SetSameBlock();
	sameBlk += checkLine( target, target );
      }
    }

  }
	
	
  if( (index % FIELD_NUM_X) != 0){
    //Not most left
    target = index - 1;
    if( (m_field[target].GetType() != NONE) && (!m_field[target].IsSameBlock()) ){
      m_field[target].SetSameBlock();
      sameBlk += checkLine( target, target );
    }
  }
	
  if( (index % FIELD_NUM_X) != (FIELD_NUM_X - 1)){
    //Not most right
    target = index + 1;
    if( (m_field[target].GetType() != NONE ) && (!m_field[target].IsSameBlock()) ){
      m_field[target].SetSameBlock();
      sameBlk += checkLine( target, target );
    }
  }

  return sameBlk;

}
//
// It drops if there is no block below.
//
void CField::downBlkLine(int index)
{

  int topNull;
	
  //It excludes it because there is no block on up.
  if(index < FIELD_NUM_X) {
    return;
  }
	
  if( m_field[index].GetType() == NONE ){
    for(topNull = index - FIELD_NUM_X;topNull >= 0;topNull -= FIELD_NUM_X){
      if( m_field[topNull].GetType() != NONE ){
	m_field[index].SetType( m_field[topNull].GetType() );
	m_field[topNull].SetType(NONE);
	break;
      }
    }

    if( topNull < 0 ) return;

  }
	
  downBlkLine(index - FIELD_NUM_X);

}
//
// block fall processing
//
void CField::downBlk()
{
  int i;
	
  for( i = FIELD_NUM_X * (FIELD_NUM_Y - 1); i < FIELD_NUM_X * FIELD_NUM_Y; i++ ){
    downBlkLine(i);
  }

}
void CField::slideBlk()
{

  int row;
  int SlideCounter = 0;

  //The right side from center
  for(row = FIELD_NUM_X / 2; row < FIELD_NUM_X && SlideCounter < FIELD_NUM_X / 2; row++ ){

    if(IsEmptyRow( row )){
      slideLeft( row );
      row--;
      SlideCounter++;
    }
    
  }

  //The left side from center
  SlideCounter = 0;
  for(row = FIELD_NUM_X / 2 - 1; row > -1  && SlideCounter < FIELD_NUM_X / 2 ; row-- ){

    if(IsEmptyRow( row )){
      slideRight( row );
      row++;
      SlideCounter++;
    }
    
  }


}
//
// TRUE:There is no block in the row. 
//
bool CField::IsEmptyRow(int row)
{
    bool bAllNone = true;
    int i;

    for( i = 0; row + i <  FIELD_NUM_X * FIELD_NUM_Y; i += FIELD_NUM_X ){
      if( m_field[row + i].GetType() == NONE ){
	continue;
      } else {
	bAllNone = false;
	break;
      }
    }

    return bAllNone;

}
//
// The row is packed into the right. 
//
void CField::slideRight(int row)
{

  int i;

  if( row < 0 ) return;

  for( i = 0; row + i <  FIELD_NUM_X * FIELD_NUM_Y; i += FIELD_NUM_X ){

    if( row == 0 ){
      //most left
      m_field[row + i].SetType( NONE );
    } else {
      m_field[row + i].SetType( m_field[row + i - 1 ].GetType() );
      m_field[row + i - 1].SetType( NONE );
    }
  }

  slideRight( row - 1 );

}
//
// The row is packed into the left. 
//
void CField::slideLeft(int row)
{

  int i;

  if( row > FIELD_NUM_X - 1 ) return;

  for( i = 0; row + i <  FIELD_NUM_X * FIELD_NUM_Y; i += FIELD_NUM_X ){

    if( row == FIELD_NUM_X - 1 ){
      //most right
      m_field[row + i].SetType( NONE );
    } else {
      m_field[row + i].SetType( m_field[row + i + 1 ].GetType() );
      m_field[row + i + 1].SetType( NONE );
    }
  }

  slideLeft( row + 1 );

}
void CField::setBlockTypeNum(int num)
{
  m_blockTypeNum = num;
}

CCell& CField::getNextBlock(int index)
{
  return m_nextBlock[index];
}
CCell& CField::getFieldBlock(int index)
{
  return m_field[index];
}
int CField::getNextBlockCount()
{
  return FIELD_NUM_X;
}
int  CField::getFiledBlockWidth()
{
  return FIELD_NUM_X;
}
int  CField::getFiledBlockHeight()
{
  return FIELD_NUM_Y;
}
//
// Check All Block Braken
//
bool  CField::IsBrokenAll()
{
  int i;

  for(i = 0;i < FIELD_NUM_X * FIELD_NUM_Y;i++){
    if( m_field[i].GetType() != NONE) return false;
  }

  return true;

}
//
//
//
bool CField::IsBomb( int index )
{

  if( m_field[index].GetType() == BOMB ){
    return true;
  } else {
    return false;
  }

}
